/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;

public class ParsedAutoDateHistogram
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Histogram {
    private String interval;
    private static final ObjectParser<ParsedAutoDateHistogram, Void> PARSER = new ObjectParser(ParsedAutoDateHistogram.class.getSimpleName(), true, ParsedAutoDateHistogram::new);

    @Override
    public String getType() {
        return "auto_date_histogram";
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Override
    public List<? extends Histogram.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedAutoDateHistogram fromXContent(XContentParser parser, String name) throws IOException {
        ParsedAutoDateHistogram aggregation = (ParsedAutoDateHistogram)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = super.doXContentBody(builder, params);
        builder.field("interval", this.getInterval());
        return builder;
    }

    static {
        ParsedAutoDateHistogram.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
        PARSER.declareString((parsed, value) -> {
            parsed.interval = value;
        }, new ParseField("interval", new String[0]));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Histogram.Bucket {
        private Long key;

        @Override
        public Object getKey() {
            if (this.key != null) {
                return Instant.ofEpochMilli(this.key).atZone(ZoneOffset.UTC);
            }
            return null;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Long.toString(this.key);
            }
            return null;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseXContent(parser, keyed, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.longValue();
            });
        }
    }
}

