/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.util.StringUtil;
import org.openrdf.util.log.ThreadLog;

public class MySQL
extends RDBMS {
    private int _majorVersion;
    private int _minorVersion;

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    protected void _initConstants(DatabaseMetaData metaData) throws SQLException {
        super._initConstants(metaData);
        this._majorVersion = metaData.getDatabaseMajorVersion();
        this._minorVersion = metaData.getDatabaseMinorVersion();
        if (this._majorVersion == 4 && this._minorVersion >= 1 || this._majorVersion >= 5) {
            ThreadLog.trace((String)"Detected MySQL 4.1 or newer, using case-sensitive utf-8 character columns");
            this.LOCALNAME = "VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_bin";
            this.LANGUAGE = "VARCHAR(16) CHARACTER SET utf8 COLLATE utf8_bin";
            this.LABEL = "TEXT CHARACTER SET utf8 COLLATE utf8_bin";
            this.LABEL_TYPE = -1;
            this.PREFIX = "VARCHAR(16) CHARACTER SET utf8 COLLATE utf8_bin";
            this.NAME = "TEXT CHARACTER SET utf8 COLLATE utf8_bin";
            this.NAME_TYPE = -1;
            this.INFOFIELD = "VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_bin";
        } else {
            ThreadLog.trace((String)"Detected MySQL 4.0 or older, using binary varchar columns");
            this.LOCALNAME = "VARCHAR(255) BINARY";
            this.LANGUAGE = "VARCHAR(16) BINARY";
            this.LABEL = "BLOB";
            this.LABEL_TYPE = 2004;
            this.PREFIX = "VARCHAR(16) BINARY";
            this.NAME = "BLOB";
            this.NAME_TYPE = 2004;
            this.INFOFIELD = "VARCHAR(255) BINARY";
        }
        this.BOOLEAN = "BOOL";
        this.TRUE = "1";
        this.FALSE = "0";
    }

    public void dropIndex(String table, String[] columns) throws SQLException {
        this.executeUpdate("DROP INDEX " + this.getIndexName(table, columns) + " ON " + table);
    }

    public void optimizeTable(String tableName) throws SQLException {
        Connection con = this.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("OPTIMIZE TABLE " + tableName);
        rs.close();
        st.close();
        con.close();
    }

    protected void _clearTable(String tableName) throws SQLException {
        this.executeUpdate("TRUNCATE TABLE " + tableName);
    }

    public void renameTableColumn(String tableName, String currentColumnName, String newColumnName, String columnSignature) throws SQLException {
        this.executeUpdate("ALTER TABLE " + tableName + " CHANGE " + currentColumnName + " " + newColumnName + " " + columnSignature);
    }

    public boolean supportsPatternMatches(boolean caseSensitive) {
        return true;
    }

    public String getPatternMatchOperator(boolean caseSensitive) {
        return caseSensitive ? "LIKE" : "REGEXP";
    }

    public String getPatternMatchExpr(String pattern, boolean caseSensitive) {
        boolean endsWithWildcard;
        if (caseSensitive) {
            pattern = StringUtil.gsub((String)"\\", (String)"\\\\\\\\", (String)pattern);
            pattern = StringUtil.gsub((String)"%", (String)"\\\\%", (String)pattern);
            pattern = StringUtil.gsub((String)"_", (String)"\\\\_", (String)pattern);
            pattern = StringUtil.gsub((String)"*", (String)"%", (String)pattern);
            return pattern;
        }
        boolean startsWithWildcard = pattern.startsWith("*");
        boolean bl = endsWithWildcard = pattern.endsWith("*") && pattern.length() >= 2;
        if (startsWithWildcard) {
            pattern = pattern.substring(1);
        }
        if (endsWithWildcard) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        StringBuffer regexp = new StringBuffer(pattern.length() * 4);
        if (!startsWithWildcard) {
            regexp.append('^');
        }
        for (int i = 0; i < pattern.length(); ++i) {
            char lcChar;
            char c = pattern.charAt(i);
            if (c == '\\') {
                regexp.append("\\\\\\\\");
                continue;
            }
            if (c == '%' || c == '_' || c == '^' || c == '$') {
                regexp.append("\\\\").append(c);
                continue;
            }
            if (c == '*') {
                regexp.append(".*");
                continue;
            }
            char ucChar = Character.toUpperCase(c);
            if (ucChar == (lcChar = Character.toLowerCase(c))) {
                regexp.append(c);
                continue;
            }
            regexp.append('[');
            regexp.append(ucChar);
            regexp.append(lcChar);
            regexp.append(']');
        }
        if (!endsWithWildcard) {
            regexp.append('$');
        }
        return regexp.toString();
    }
}

