/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class RdfsClass
implements ClassQuery {
    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        try {
            String[] columnHeader = new String[]{"Classes"};
            listener.startTableQueryResult(columnHeader);
            ResourceIterator iter = this.getClasses(rss);
            while (iter.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter.next());
                listener.endTuple();
            }
            iter.close();
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) {
        return this.getClasses(rss);
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) {
        return new StatementSubjectIterator(rss.getClasses());
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return "Class";
    }

    public String toString() {
        return "Class";
    }
}

