/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.MetadataSearchAndReplace;
import org.fao.geonet.api.processing.report.MetadataReplacementProcessingReport;
import org.fao.geonet.api.processing.report.ProcessingReport;
import org.fao.geonet.api.processing.report.registry.IProcessingReportRegistry;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/processes"})
@Tag(name="processes", description="Processing operations")
@Controller(value="process")
public class ProcessApi {
    @Autowired
    IProcessingReportRegistry registry;
    @Autowired
    DataManager dataMan;
    @Autowired
    SettingManager settingManager;

    @Operation(summary="Get current process reports", description="When processing, the report is stored in memory and allows to retrieve progress repport during processing. Usually, process reports are returned by the synchronous processing operation.")
    @RequestMapping(path={"/reports"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of reports returned."), @ApiResponse(responseCode="403", description="Operation not allowed. Only authenticated user can access it.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    public List<ProcessingReport> getProcessReport() throws Exception {
        return this.registry.get();
    }

    @Operation(summary="Clear process reports list")
    @RequestMapping(path={"/reports"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Report registry cleared."), @ApiResponse(responseCode="403", description="Operation not allowed. Only authenticated user can access it.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="isAuthenticated()")
    public void delete() throws Exception {
        this.registry.clear();
    }

    @Operation(summary="Search and replace values in one or more records", description="Service to apply replacements to one or more records.\n To define a replacement, send the following parameters:\n * mdsection-139815551372=metadata\n * mdfield-1398155513728=id.contact.individualName\n * replaceValue-1398155513728=Juan\n * searchValue-1398155513728=Jose\n\nTODO: Would be good to provide a simple object to define list of changes instead of group of parameters.<br/>Batch editing can also be used for similar works.")
    @RequestMapping(value={"/search-and-replace"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replacements applied."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public MetadataReplacementProcessingReport searchAndReplace(@RequestParam(defaultValue="massive-content-update") String process, @Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Test only (ie. metadata are not saved). Return the report only.", required=false) @RequestParam(defaultValue="false") boolean isTesting, @Parameter(description="Case insensitive search.", required=false) @RequestParam(defaultValue="false") boolean isCaseInsensitive, @RequestParam(defaultValue="") @Parameter(description="'record' to apply vacuum.xsl, 'element' to remove empty elements. Empty to not affect empty elements.", required=false) String vacuumMode, @Parameter(hidden=true) @RequestParam Map<String, String> allParams, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        try (MetadataReplacementProcessingReport report = new MetadataReplacementProcessingReport("massive-content-update");){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
            report.setTotalRecords(records.size());
            MetadataSearchAndReplace m = new MetadataSearchAndReplace(this.dataMan, process, isTesting, isCaseInsensitive, vacuumMode, allParams, ApiUtils.createServiceContext(request), records, report);
            m.process(this.settingManager.getSiteId());
        }
        return report;
    }
}

