/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.ByteIteratorToIteratorAdapter;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class ByteSetToSetAdapter
extends AbstractSet {
    protected ByteSet set;

    public ByteSetToSetAdapter(ByteSet set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.set.add((Byte)o);
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.set.contains((Byte)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public Iterator iterator() {
        return new ByteIteratorToIteratorAdapter(this.set.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.set.remove((Byte)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.set.size();
    }
}

