/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.CreateNodeAndPopulateAutomaticAttributes;
import org.jclouds.domain.JsonBall;
import org.jclouds.logging.Logger;
import org.jclouds.ohai.Automatic;

@Singleton
public class CreateNodeAndPopulateAutomaticAttributesImpl
implements CreateNodeAndPopulateAutomaticAttributes {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    private final ChefApi chef;
    private final Supplier<Map<String, JsonBall>> automaticSupplier;

    @Inject
    public CreateNodeAndPopulateAutomaticAttributesImpl(ChefApi chef, @Automatic Supplier<Map<String, JsonBall>> automaticSupplier) {
        this.chef = (ChefApi)Preconditions.checkNotNull((Object)chef, (Object)"chef");
        this.automaticSupplier = (Supplier)Preconditions.checkNotNull(automaticSupplier, (Object)"automaticSupplier");
    }

    @Override
    public Node execute(Node node) {
        this.logger.trace("creating node %s", new Object[]{node.getName()});
        Node withAutomatic = Node.builder().name(node.getName()).normalAttributes(node.getNormalAttributes()).overrideAttributes(node.getOverrideAttributes()).defaultAttributes(node.getDefaultAttributes()).automaticAttributes(node.getAutomaticAttributes()).automaticAttributes((Map)this.automaticSupplier.get()).runList(node.getRunList()).environment(node.getEnvironment()).build();
        this.chef.createNode(withAutomatic);
        this.logger.debug("created node %s", new Object[]{withAutomatic.getName()});
        return node;
    }

    @Override
    public Node execute(String nodeName, Iterable<String> runList) {
        return this.execute(Node.builder().name(nodeName).runList(runList).environment("_default").build());
    }
}

