/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.binders;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.Group;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.binders.BindToJsonPayload;

@Singleton
public class BindGroupToUpdateRequestJsonPayload
extends BindToJsonPayload {
    @Inject
    public BindGroupToUpdateRequestJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)payload, (Object)"payload") instanceof Group), (Object)"this binder is only valid for Group objects");
        GroupUpdateRequest updateGroup = new GroupUpdateRequest((Group)payload);
        return (R)super.bindToRequest(request, (Object)updateGroup);
    }

    private static class ActorConfiguration {
        private Set<String> clients;
        private Set<String> groups;
        private Set<String> users;

        public ActorConfiguration(Group group) {
            this.clients = group.getClients();
            this.groups = group.getGroups();
            this.users = group.getUsers();
        }
    }

    private static class GroupUpdateRequest {
        private String name;
        private String groupname;
        private String orgname;
        private ActorConfiguration actors;

        public GroupUpdateRequest(Group group) {
            this.name = group.getName();
            this.groupname = group.getGroupname();
            this.orgname = group.getOrgname();
            this.actors = new ActorConfiguration(group);
        }
    }
}

