/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class DateFieldScript
extends AbstractLongFieldScript {
    public static final ScriptContext<Factory> CONTEXT = DateFieldScript.newContext("date_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = (field, params, lookup, formatter) -> ctx -> new DateFieldScript(field, params, lookup, formatter, ctx){

        @Override
        public void execute() {
            this.emitFromSource();
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private final DateFormatter formatter;

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup, formatter) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new DateFieldScript(leafFieldName, params, searchLookup, formatter, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public DateFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, DateFormatter formatter, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
        this.formatter = formatter;
    }

    @Override
    protected void emitFromObject(Object v) {
        try {
            this.emit(this.formatter.parseMillis(Objects.toString(v)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3, DateFormatter var4);
    }

    public static interface LeafFactory {
        public DateFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Parse {
        private final DateFieldScript script;

        public Parse(DateFieldScript script) {
            this.script = script;
        }

        public long parse(Object str) {
            return this.script.formatter.parseMillis(str.toString());
        }
    }

    public static class Emit {
        private final DateFieldScript script;

        public Emit(DateFieldScript script) {
            this.script = script;
        }

        public void emit(long v) {
            this.script.emit(v);
        }
    }
}

