/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TypeFieldMapper;

public class DocumentMapper {
    private final String type;
    private final CompressedXContent mappingSource;
    private final MappingLookup mappingLookup;
    private final DocumentParser documentParser;

    public static DocumentMapper createEmpty(String type, MapperService mapperService) {
        Mapping mapping = mapperService.parseMapping(type, null, true);
        return new DocumentMapper(mapperService.documentParser(), mapping);
    }

    DocumentMapper(DocumentParser documentParser, Mapping mapping) {
        this.documentParser = documentParser;
        this.type = mapping.getRoot().name();
        this.mappingLookup = MappingLookup.fromMapping(mapping);
        this.mappingSource = mapping.toCompressedXContent();
    }

    public Mapping mapping() {
        return this.mappingLookup.getMapping();
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping().getMetadataMapperByClass(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.metadataMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public MappingLookup mappers() {
        return this.mappingLookup;
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mappingLookup);
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping().validate(this.mappingLookup);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.mappers().hasNested()) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
        if (checkLimits) {
            this.mappingLookup.checkLimits(settings);
        }
    }

    public String toString() {
        return "DocumentMapper{type='" + this.type + '\'' + ", mappingSource=" + this.mappingSource + ", mappingLookup=" + this.mappingLookup + ", objectMappers=" + this.mappers().objectMappers() + ", hasNestedObjects=" + this.mappingLookup.hasNested() + '}';
    }
}

