/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public class SSLTermination {
    private final boolean enabled;
    private final boolean secureTrafficOnly;
    private final int securePort;
    private final Optional<String> certificate;
    @Named(value="privatekey")
    private final Optional<String> privateKey;
    private final Optional<String> intermediateCertificate;

    @ConstructorProperties(value={"enabled", "secureTrafficOnly", "securePort", "certificate", "privatekey", "intermediateCertificate"})
    protected SSLTermination(boolean enabled, boolean secureTrafficOnly, int securePort, String certificate, String privateKey, String intermediateCertificate) {
        this.enabled = enabled;
        this.secureTrafficOnly = secureTrafficOnly;
        this.securePort = securePort;
        this.certificate = Optional.fromNullable((Object)certificate);
        this.privateKey = Optional.fromNullable((Object)privateKey);
        this.intermediateCertificate = Optional.fromNullable((Object)intermediateCertificate);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getSecureTrafficOnly() {
        return this.secureTrafficOnly;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public Optional<String> getCertificate() {
        return this.certificate;
    }

    public Optional<String> getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getIntermediateCertificate() {
        return this.intermediateCertificate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.secureTrafficOnly, this.securePort, this.certificate, this.privateKey, this.intermediateCertificate});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SSLTermination that = (SSLTermination)SSLTermination.class.cast(obj);
        return Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)this.secureTrafficOnly, (Object)that.secureTrafficOnly) && Objects.equal((Object)this.securePort, (Object)that.securePort) && Objects.equal(this.certificate, that.certificate) && Objects.equal(this.privateKey, that.privateKey) && Objects.equal(this.intermediateCertificate, that.intermediateCertificate);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("enabled", this.enabled).add("secureTrafficOnly", this.secureTrafficOnly).add("securePort", this.securePort).add("certificate", this.certificate.orNull()).add("privateKey", this.privateKey.orNull()).add("intermediateCertificate", this.intermediateCertificate.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private boolean enabled;
        private boolean secureTrafficOnly;
        private int securePort;
        private String certificate;
        private String privateKey;
        private String intermediateCertificate;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder secureTrafficOnly(boolean secureTrafficOnly) {
            this.secureTrafficOnly = secureTrafficOnly;
            return this;
        }

        public Builder securePort(int securePort) {
            this.securePort = securePort;
            return this;
        }

        public Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder privatekey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder intermediateCertificate(String intermediateCertificate) {
            this.intermediateCertificate = intermediateCertificate;
            return this;
        }

        public SSLTermination build() {
            return new SSLTermination(this.enabled, this.secureTrafficOnly, this.securePort, this.certificate, this.privateKey, this.intermediateCertificate);
        }

        public Builder from(SSLTermination in) {
            return this.enabled(in.getEnabled()).secureTrafficOnly(in.getSecureTrafficOnly()).securePort(in.getSecurePort()).certificate((String)in.getCertificate().orNull()).privatekey((String)in.getPrivateKey().orNull()).intermediateCertificate((String)in.getIntermediateCertificate().orNull());
        }
    }
}

