/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.ThesaurusManager;
import org.jdom.Content;
import org.jdom.Element;

public class List
implements Service {
    private String _localThesaurusDir;
    private String _externalDir;
    private String _initType;
    private final FilenameFilter directoryFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return dir.isDirectory() && !name.startsWith(".");
        }
    };
    private final FilenameFilter thesauriFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (dir.isDirectory() && !name.startsWith(".")) {
                return true;
            }
            return !dir.isDirectory() && name.endsWith(".xml") || name.endsWith(".rdf");
        }
    };

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this._localThesaurusDir = File.separator + "local" + File.separator + "thesauri" + File.separator;
        this._externalDir = File.separator + "external" + File.separator + "thesauri" + File.separator;
        this._initType = params.getValue("type", "_none_");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String mode;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        ThesaurusManager thesaurusMan = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
        Path THESAURUS_DIR = thesaurusMan.getThesauriDirectory();
        Element thesauriList = new Element("thesaurusList");
        String type = Util.getParam((Element)params, (String)"type", (String)this._initType);
        if (type.equals("all-directories")) {
            this.listThesauri(thesauriList, THESAURUS_DIR + this._externalDir, 1, this.directoryFilter, "external");
            this.listThesauri(thesauriList, THESAURUS_DIR + this._localThesaurusDir, 1, this.directoryFilter, "local");
        } else if (type.equals("upload-directories")) {
            this.listThesauri(thesauriList, THESAURUS_DIR + this._externalDir, 1, this.directoryFilter, "external");
        } else if (type.equals("all-thesauri")) {
            this.listThesauri(thesauriList, THESAURUS_DIR + this._externalDir, 2, this.thesauriFilter, "external");
            this.listThesauri(thesauriList, THESAURUS_DIR + this._localThesaurusDir, 2, this.thesauriFilter, "local");
        } else if (type.equals("update-thesauri")) {
            this.listThesauri(thesauriList, THESAURUS_DIR + this._localThesaurusDir, 3, this.thesauriFilter, "local");
        } else {
            this.listThesauri(thesauriList, THESAURUS_DIR + this._externalDir, 3, this.thesauriFilter, "external");
            this.listThesauri(thesauriList, THESAURUS_DIR + this._localThesaurusDir, 3, this.thesauriFilter, "local");
        }
        Element elRes = new Element("response").addContent((Content)thesauriList);
        String selected = Util.getParam((Element)params, (String)"selected", (String)"none");
        if (!selected.equals("none")) {
            Element elSelected = new Element("selectedThesaurus");
            elSelected.addContent(selected);
            elRes.addContent((Content)elSelected);
        }
        if (!(mode = Util.getParam((Element)params, (String)"mode", (String)"none")).equals("none")) {
            Element elMode = new Element("mode");
            elMode.addContent(mode);
            elRes.addContent((Content)elMode);
        }
        return elRes;
    }

    private void listThesauri(Element list, String dir, int mode, FilenameFilter filter, String rootName) throws Exception {
        File thesauriDirectory = new File(dir);
        if (thesauriDirectory.isDirectory()) {
            File[] rdfDataDirectory = thesauriDirectory.listFiles(filter);
            for (int i = 0; i < rdfDataDirectory.length; ++i) {
                if (rdfDataDirectory[i].isDirectory()) {
                    Element dirE;
                    if (mode == 1) {
                        dirE = new Element("directory").setAttribute("label", rdfDataDirectory[i].getName());
                        dirE.setAttribute("type", rootName);
                        list.addContent((Content)dirE);
                        this.listThesauri(dirE, rdfDataDirectory[i].getAbsolutePath(), mode, filter, rootName);
                        continue;
                    }
                    if (mode == 2) {
                        dirE = new Element("directory").setAttribute("label", rdfDataDirectory[i].getName());
                        dirE.setAttribute("type", rootName);
                        java.util.List children = list.getChildren("directory");
                        Element element = null;
                        for (Element e : children) {
                            if (!e.getAttribute("label").getValue().equals(rdfDataDirectory[i].getName())) continue;
                            element = e;
                            break;
                        }
                        if (element != null) {
                            this.listThesauri(element, rdfDataDirectory[i].getAbsolutePath(), mode, filter, rootName);
                            continue;
                        }
                        list.addContent((Content)dirE);
                        this.listThesauri(dirE, rdfDataDirectory[i].getAbsolutePath(), mode, filter, rootName);
                        continue;
                    }
                    this.listThesauri(list, rdfDataDirectory[i].getAbsolutePath(), mode, filter, rootName);
                    continue;
                }
                if (mode == 1) continue;
                String thesaurusName = rootName + '.' + thesauriDirectory.getName() + '.' + rdfDataDirectory[i].getName().substring(0, rdfDataDirectory[i].getName().indexOf(".rdf"));
                Element thesaurusE = new Element("thesaurus").setAttribute("value", thesaurusName);
                thesaurusE.setAttribute("type", rootName);
                Element dirE = new Element("dname").setText(thesauriDirectory.getName());
                Element fnameE = new Element("fname").setText(rdfDataDirectory[i].getName());
                thesaurusE.addContent((Content)fnameE);
                thesaurusE.addContent((Content)dirE);
                list.addContent((Content)thesaurusE);
            }
        }
    }
}

