/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.process;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DataCounts
implements ToXContentObject {
    public static final ParseField PROCESSED_RECORD_COUNT = new ParseField("processed_record_count", new String[0]);
    public static final ParseField PROCESSED_FIELD_COUNT = new ParseField("processed_field_count", new String[0]);
    public static final ParseField INPUT_BYTES = new ParseField("input_bytes", new String[0]);
    public static final ParseField INPUT_RECORD_COUNT = new ParseField("input_record_count", new String[0]);
    public static final ParseField INPUT_FIELD_COUNT = new ParseField("input_field_count", new String[0]);
    public static final ParseField INVALID_DATE_COUNT = new ParseField("invalid_date_count", new String[0]);
    public static final ParseField MISSING_FIELD_COUNT = new ParseField("missing_field_count", new String[0]);
    public static final ParseField OUT_OF_ORDER_TIME_COUNT = new ParseField("out_of_order_timestamp_count", new String[0]);
    public static final ParseField EMPTY_BUCKET_COUNT = new ParseField("empty_bucket_count", new String[0]);
    public static final ParseField SPARSE_BUCKET_COUNT = new ParseField("sparse_bucket_count", new String[0]);
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField EARLIEST_RECORD_TIME = new ParseField("earliest_record_timestamp", new String[0]);
    public static final ParseField LATEST_RECORD_TIME = new ParseField("latest_record_timestamp", new String[0]);
    public static final ParseField LAST_DATA_TIME = new ParseField("last_data_time", new String[0]);
    public static final ParseField LATEST_EMPTY_BUCKET_TIME = new ParseField("latest_empty_bucket_timestamp", new String[0]);
    public static final ParseField LATEST_SPARSE_BUCKET_TIME = new ParseField("latest_sparse_bucket_timestamp", new String[0]);
    public static final ParseField LOG_TIME = new ParseField("log_time", new String[0]);
    public static final ConstructingObjectParser<DataCounts, Void> PARSER = new ConstructingObjectParser("data_counts", true, a -> new DataCounts((String)a[0], (Long)a[1], (Long)a[2], (Long)a[3], (Long)a[4], (Long)a[5], (Long)a[6], (Long)a[7], (Long)a[8], (Long)a[9], (Long)a[10], (Date)a[11], (Date)a[12], (Date)a[13], (Date)a[14], (Date)a[15], (Instant)a[16]));
    private final String jobId;
    private long processedRecordCount;
    private long processedFieldCount;
    private long inputBytes;
    private long inputFieldCount;
    private long invalidDateCount;
    private long missingFieldCount;
    private long outOfOrderTimeStampCount;
    private long emptyBucketCount;
    private long sparseBucketCount;
    private long bucketCount;
    private Date earliestRecordTimeStamp;
    private Date latestRecordTimeStamp;
    private Date lastDataTimeStamp;
    private Date latestEmptyBucketTimeStamp;
    private Date latestSparseBucketTimeStamp;
    private Instant logTime;

    public DataCounts(String jobId, long processedRecordCount, long processedFieldCount, long inputBytes, long inputFieldCount, long invalidDateCount, long missingFieldCount, long outOfOrderTimeStampCount, long emptyBucketCount, long sparseBucketCount, long bucketCount, Date earliestRecordTimeStamp, Date latestRecordTimeStamp, Date lastDataTimeStamp, Date latestEmptyBucketTimeStamp, Date latestSparseBucketTimeStamp, Instant logTime) {
        this.jobId = jobId;
        this.processedRecordCount = processedRecordCount;
        this.processedFieldCount = processedFieldCount;
        this.inputBytes = inputBytes;
        this.inputFieldCount = inputFieldCount;
        this.invalidDateCount = invalidDateCount;
        this.missingFieldCount = missingFieldCount;
        this.outOfOrderTimeStampCount = outOfOrderTimeStampCount;
        this.emptyBucketCount = emptyBucketCount;
        this.sparseBucketCount = sparseBucketCount;
        this.bucketCount = bucketCount;
        this.latestRecordTimeStamp = latestRecordTimeStamp;
        this.earliestRecordTimeStamp = earliestRecordTimeStamp;
        this.lastDataTimeStamp = lastDataTimeStamp;
        this.latestEmptyBucketTimeStamp = latestEmptyBucketTimeStamp;
        this.latestSparseBucketTimeStamp = latestSparseBucketTimeStamp;
        this.logTime = logTime == null ? null : Instant.ofEpochMilli(logTime.toEpochMilli());
    }

    DataCounts(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getProcessedRecordCount() {
        return this.processedRecordCount;
    }

    public long getProcessedFieldCount() {
        return this.processedFieldCount;
    }

    public long getInputRecordCount() {
        return this.processedRecordCount + this.outOfOrderTimeStampCount + this.invalidDateCount;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public long getInputFieldCount() {
        return this.inputFieldCount;
    }

    public long getInvalidDateCount() {
        return this.invalidDateCount;
    }

    public long getMissingFieldCount() {
        return this.missingFieldCount;
    }

    public long getOutOfOrderTimeStampCount() {
        return this.outOfOrderTimeStampCount;
    }

    public long getEmptyBucketCount() {
        return this.emptyBucketCount;
    }

    public long getSparseBucketCount() {
        return this.sparseBucketCount;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public Date getEarliestRecordTimeStamp() {
        return this.earliestRecordTimeStamp;
    }

    public Date getLatestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public Date getLastDataTimeStamp() {
        return this.lastDataTimeStamp;
    }

    public Date getLatestEmptyBucketTimeStamp() {
        return this.latestEmptyBucketTimeStamp;
    }

    public Date getLatestSparseBucketTimeStamp() {
        return this.latestSparseBucketTimeStamp;
    }

    public Instant getLogTime() {
        return this.logTime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(PROCESSED_RECORD_COUNT.getPreferredName(), this.processedRecordCount);
        builder.field(PROCESSED_FIELD_COUNT.getPreferredName(), this.processedFieldCount);
        builder.field(INPUT_BYTES.getPreferredName(), this.inputBytes);
        builder.field(INPUT_FIELD_COUNT.getPreferredName(), this.inputFieldCount);
        builder.field(INVALID_DATE_COUNT.getPreferredName(), this.invalidDateCount);
        builder.field(MISSING_FIELD_COUNT.getPreferredName(), this.missingFieldCount);
        builder.field(OUT_OF_ORDER_TIME_COUNT.getPreferredName(), this.outOfOrderTimeStampCount);
        builder.field(EMPTY_BUCKET_COUNT.getPreferredName(), this.emptyBucketCount);
        builder.field(SPARSE_BUCKET_COUNT.getPreferredName(), this.sparseBucketCount);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        if (this.earliestRecordTimeStamp != null) {
            builder.timeField(EARLIEST_RECORD_TIME.getPreferredName(), EARLIEST_RECORD_TIME.getPreferredName() + "_string", this.earliestRecordTimeStamp.getTime());
        }
        if (this.latestRecordTimeStamp != null) {
            builder.timeField(LATEST_RECORD_TIME.getPreferredName(), LATEST_RECORD_TIME.getPreferredName() + "_string", this.latestRecordTimeStamp.getTime());
        }
        if (this.lastDataTimeStamp != null) {
            builder.timeField(LAST_DATA_TIME.getPreferredName(), LAST_DATA_TIME.getPreferredName() + "_string", this.lastDataTimeStamp.getTime());
        }
        if (this.latestEmptyBucketTimeStamp != null) {
            builder.timeField(LATEST_EMPTY_BUCKET_TIME.getPreferredName(), LATEST_EMPTY_BUCKET_TIME.getPreferredName() + "_string", this.latestEmptyBucketTimeStamp.getTime());
        }
        if (this.latestSparseBucketTimeStamp != null) {
            builder.timeField(LATEST_SPARSE_BUCKET_TIME.getPreferredName(), LATEST_SPARSE_BUCKET_TIME.getPreferredName() + "_string", this.latestSparseBucketTimeStamp.getTime());
        }
        builder.field(INPUT_RECORD_COUNT.getPreferredName(), this.getInputRecordCount());
        if (this.logTime != null) {
            builder.timeField(LOG_TIME.getPreferredName(), LOG_TIME.getPreferredName() + "_string", this.logTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataCounts that = (DataCounts)other;
        return Objects.equals(this.jobId, that.jobId) && this.processedRecordCount == that.processedRecordCount && this.processedFieldCount == that.processedFieldCount && this.inputBytes == that.inputBytes && this.inputFieldCount == that.inputFieldCount && this.invalidDateCount == that.invalidDateCount && this.missingFieldCount == that.missingFieldCount && this.outOfOrderTimeStampCount == that.outOfOrderTimeStampCount && this.emptyBucketCount == that.emptyBucketCount && this.sparseBucketCount == that.sparseBucketCount && this.bucketCount == that.bucketCount && Objects.equals(this.latestRecordTimeStamp, that.latestRecordTimeStamp) && Objects.equals(this.earliestRecordTimeStamp, that.earliestRecordTimeStamp) && Objects.equals(this.lastDataTimeStamp, that.lastDataTimeStamp) && Objects.equals(this.latestEmptyBucketTimeStamp, that.latestEmptyBucketTimeStamp) && Objects.equals(this.latestSparseBucketTimeStamp, that.latestSparseBucketTimeStamp) && Objects.equals(this.logTime, that.logTime);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.processedRecordCount, this.processedFieldCount, this.inputBytes, this.inputFieldCount, this.invalidDateCount, this.missingFieldCount, this.outOfOrderTimeStampCount, this.lastDataTimeStamp, this.emptyBucketCount, this.sparseBucketCount, this.bucketCount, this.latestRecordTimeStamp, this.earliestRecordTimeStamp, this.latestEmptyBucketTimeStamp, this.latestSparseBucketTimeStamp, this.logTime);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSED_RECORD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSED_FIELD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INPUT_BYTES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INPUT_FIELD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INVALID_DATE_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MISSING_FIELD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_OF_ORDER_TIME_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), EMPTY_BUCKET_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), SPARSE_BUCKET_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_COUNT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeField(p, EARLIEST_RECORD_TIME.getPreferredName()), EARLIEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeField(p, LATEST_RECORD_TIME.getPreferredName()), LATEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeField(p, LAST_DATA_TIME.getPreferredName()), LAST_DATA_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeField(p, LATEST_EMPTY_BUCKET_TIME.getPreferredName()), LATEST_EMPTY_BUCKET_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeField(p, LATEST_SPARSE_BUCKET_TIME.getPreferredName()), LATEST_SPARSE_BUCKET_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, LOG_TIME.getPreferredName()), LOG_TIME, ObjectParser.ValueType.VALUE);
    }
}

