/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.ArrayList;
import java.util.Arrays;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

class SortKey {
    private static java.util.Comparator<Comparable> FORWARD_COMPARATOR = new java.util.Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    private static java.util.Comparator<Comparable> REVERSE_COMPARATOR = new java.util.Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return -FORWARD_COMPARATOR.compare(o1, o2);
        }
    };
    Object[] components;

    public SortKey(int length) {
        this.components = new Object[length];
    }

    public SortKey(SortKey other) {
        this(other.components.length);
        this.copy(other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.components);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortKey other = (SortKey)obj;
        return Arrays.equals(this.components, other.components);
    }

    public void copy(SortKey reference) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = reference.components[i];
        }
    }

    public String toString() {
        return "SortKey [components=" + Arrays.toString(this.components) + "]";
    }

    static Comparator buildComparator(SortBy[] sortBy) {
        if (sortBy == SortBy.UNSORTED || sortBy == null) {
            throw new IllegalArgumentException("Expected to get a sort, but found none");
        }
        ArrayList<java.util.Comparator<Comparable>> comparators = new ArrayList<java.util.Comparator<Comparable>>();
        for (SortBy sb : sortBy) {
            if (sb.getSortOrder() == SortOrder.ASCENDING) {
                comparators.add(FORWARD_COMPARATOR);
                continue;
            }
            comparators.add(REVERSE_COMPARATOR);
        }
        return new Comparator(comparators.toArray(new java.util.Comparator[comparators.size()]));
    }

    static class Comparator
    implements java.util.Comparator<SortKey> {
        java.util.Comparator<Object>[] comparators;

        public Comparator(java.util.Comparator<Object>[] componentComparators) {
            this.comparators = componentComparators;
        }

        @Override
        public int compare(SortKey sk1, SortKey sk2) {
            for (int i = 0; i < this.comparators.length; ++i) {
                int compare = this.comparators[i].compare(sk1.components[i], sk2.components[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }
}

