/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.change;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.support.change.ResourceChangeInfo;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;

public class ResourceChangeDetector {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceChangeDetector.class);
    @Inject
    private UriLocatorFactory locatorFactory;
    @Inject
    private HashStrategy hashStrategy;
    private final Map<String, ResourceChangeInfo> changeInfoMap = new ConcurrentHashMap<String, ResourceChangeInfo>(){

        @Override
        public ResourceChangeInfo get(Object key) {
            ResourceChangeInfo result = (ResourceChangeInfo)super.get(key);
            if (result == null) {
                result = new ResourceChangeInfo();
                this.put((String)key, result);
            }
            return result;
        }
    };

    public void reset() {
        for (ResourceChangeInfo resourceInfo : this.changeInfoMap.values()) {
            resourceInfo.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkChangeForGroup(String uri, String groupName) throws IOException {
        Validate.notNull((Object)uri);
        Validate.notNull((Object)groupName);
        LOG.debug("group={}, uri={}", (Object)groupName, (Object)uri);
        ResourceChangeInfo resourceInfo = this.changeInfoMap.get(uri);
        if (resourceInfo.isCheckRequiredForGroup(groupName)) {
            InputStream inputStream = this.locatorFactory.locate(uri);
            try {
                String currentHash = this.hashStrategy.getHash(inputStream);
                resourceInfo.updateHashForGroup(currentHash, groupName);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return resourceInfo.isChanged(groupName);
    }
}

