// validate.js 0.8.0
// http://validatejs.org/
// (c) 2013-2015 Nicklas Ansman, 2013 Wrapp
// validate.js may be freely distributed under the MIT license.

(function(a,b,c){"use strict";var d=function(a,b,c){c=e.extend({},e.options,c);var f,g,h=e.runValidations(a,b,c);for(f in h)for(g in h[f])if(e.isPromise(h[f][g]))throw new Error("Use validate.async if you want support for promises");return d.processValidationResults(h,c)},e=d;e.extend=function(a){return[].slice.call(arguments,1).forEach(function(b){for(var c in b)a[c]=b[c]}),a},e.extend(d,{version:{major:0,minor:8,patch:0,metadata:"",toString:function(){var a=e.format("%{major}.%{minor}.%{patch}",e.version);return e.isEmpty(e.version.metadata)||(a+="+"+e.version.metadata),a}},Promise:"undefined"!=typeof Promise?Promise:null,moment:"undefined"!=typeof moment?moment:null,XDate:"undefined"!=typeof XDate?XDate:null,EMPTY_STRING_REGEXP:/^\s*$/,runValidations:function(a,b,c){var d,f,g,h,i,j,k,l=[];(e.isDomElement(a)||e.isJqueryElement(a))&&(a=e.collectFormValues(a));for(d in b){g=e.getDeepObjectValue(a,d),h=e.result(b[d],g,a,d,c,b);for(f in h){if(i=e.validators[f],!i)throw k=e.format("Unknown validator %{name}",{name:f}),new Error(k);j=h[f],j=e.result(j,g,a,d,c,b),j&&l.push({attribute:d,value:g,validator:f,options:j,error:i.call(i,g,j,d,a)})}}return l},processValidationResults:function(a,b){var c;switch(a=e.pruneEmptyErrors(a,b),a=e.expandMultipleErrors(a,b),a=e.convertErrorMessages(a,b),b.format||"grouped"){case"detailed":break;case"flat":a=e.flattenErrorsToArray(a);break;case"grouped":a=e.groupErrorsByAttribute(a);for(c in a)a[c]=e.flattenErrorsToArray(a[c]);break;default:throw new Error(e.format("Unknown format %{format}",b))}return e.isEmpty(a)?void 0:a},async:function(a,b,c){c=e.extend({},e.async.options,c);var d=c.wrapErrors||function(a){return a};c.cleanAttributes!==!1&&(a=e.cleanAttributes(a,b));var f=e.runValidations(a,b,c);return new e.Promise(function(g,h){e.waitForResults(f).then(function(){var i=e.processValidationResults(f,c);i?h(new d(i,c,a,b)):g(a)},function(a){h(a)})})},single:function(a,b,c){return c=e.extend({},e.single.options,c,{format:"flat",fullMessages:!1}),e({single:a},{single:b},c)},waitForResults:function(a){return a.reduce(function(a,b){return e.isPromise(b.error)?a.then(function(){return b.error.then(function(a){b.error=a||null},function(a){if(a instanceof Error)throw a;console.log("Foo"),e.error("Rejecting promises with the result is deprecated. Please use the resolve callback instead."),b.error=a})}):a},new e.Promise(function(a){a()}))},result:function(a){var b=[].slice.call(arguments,1);return"function"==typeof a&&(a=a.apply(null,b)),a},isNumber:function(a){return"number"==typeof a&&!isNaN(a)},isFunction:function(a){return"function"==typeof a},isInteger:function(a){return e.isNumber(a)&&a%1===0},isObject:function(a){return a===Object(a)},isDate:function(a){return a instanceof Date},isDefined:function(a){return null!==a&&void 0!==a},isPromise:function(a){return!!a&&e.isFunction(a.then)},isJqueryElement:function(a){return a&&e.isString(a.jquery)},isDomElement:function(a){return a&&e.isFunction(a.querySelectorAll)&&e.isFunction(a.querySelector)?e.isObject(document)&&a===document?!0:"object"==typeof HTMLElement?a instanceof HTMLElement:a&&"object"==typeof a&&null!==a&&1===a.nodeType&&"string"==typeof a.nodeName:!1},isEmpty:function(a){var b;if(!e.isDefined(a))return!0;if(e.isFunction(a))return!1;if(e.isString(a))return e.EMPTY_STRING_REGEXP.test(a);if(e.isArray(a))return 0===a.length;if(e.isDate(a))return!1;if(e.isObject(a)){for(b in a)return!1;return!0}return!1},format:e.extend(function(a,b){return a.replace(e.format.FORMAT_REGEXP,function(a,c,d){return"%"===c?"%{"+d+"}":String(b[d])})},{FORMAT_REGEXP:/(%?)%\{([^\}]+)\}/g}),prettify:function(a){return e.isNumber(a)?100*a%1===0?""+a:parseFloat(Math.round(100*a)/100).toFixed(2):e.isArray(a)?a.map(function(a){return e.prettify(a)}).join(", "):e.isObject(a)?a.toString():(a=""+a,a.replace(/([^\s])\.([^\s])/g,"$1 $2").replace(/\\+/g,"").replace(/[_-]/g," ").replace(/([a-z])([A-Z])/g,function(a,b,c){return""+b+" "+c.toLowerCase()}).toLowerCase())},stringifyValue:function(a){return e.prettify(a)},isString:function(a){return"string"==typeof a},isArray:function(a){return"[object Array]"==={}.toString.call(a)},contains:function(a,b){return e.isDefined(a)?e.isArray(a)?-1!==a.indexOf(b):b in a:!1},forEachKeyInKeypath:function(a,b,c){if(!e.isString(b))return void 0;var d,f="",g=!1;for(d=0;d<b.length;++d)switch(b[d]){case".":g?(g=!1,f+="."):(a=c(a,f,!1),f="");break;case"\\":g?(g=!1,f+="\\"):g=!0;break;default:g=!1,f+=b[d]}return c(a,f,!0)},getDeepObjectValue:function(a,b){return e.isObject(a)?e.forEachKeyInKeypath(a,b,function(a,b){return e.isObject(a)?a[b]:void 0}):void 0},collectFormValues:function(a,b){var c,d,f,g,h={};if(e.isJqueryElement(a)&&(a=a[0]),!a)return h;for(b=b||{},f=a.querySelectorAll("input[name], textarea[name]"),c=0;c<f.length;++c)d=f.item(c),e.isDefined(d.getAttribute("data-ignored"))||(g=e.sanitizeFormValue(d.value,b),"number"===d.type?g=+g:"checkbox"===d.type?d.attributes.value?d.checked||(g=h[d.name]||null):g=d.checked:"radio"===d.type&&(d.checked||(g=h[d.name]||null)),h[d.name]=g);for(f=a.querySelectorAll("select[name]"),c=0;c<f.length;++c)d=f.item(c),g=e.sanitizeFormValue(d.options[d.selectedIndex].value,b),h[d.name]=g;return h},sanitizeFormValue:function(a,b){return b.trim&&e.isString(a)&&(a=a.trim()),b.nullify!==!1&&""===a?null:a},capitalize:function(a){return e.isString(a)?a[0].toUpperCase()+a.slice(1):a},pruneEmptyErrors:function(a){return a.filter(function(a){return!e.isEmpty(a.error)})},expandMultipleErrors:function(a){var b=[];return a.forEach(function(a){e.isArray(a.error)?a.error.forEach(function(c){b.push(e.extend({},a,{error:c}))}):b.push(a)}),b},convertErrorMessages:function(a,b){b=b||{};var c=[];return a.forEach(function(a){var d=a.error;"^"===d[0]?d=d.slice(1):b.fullMessages!==!1&&(d=e.capitalize(e.prettify(a.attribute))+" "+d),d=d.replace(/\\\^/g,"^"),d=e.format(d,{value:e.stringifyValue(a.value)}),c.push(e.extend({},a,{error:d}))}),c},groupErrorsByAttribute:function(a){var b={};return a.forEach(function(a){var c=b[a.attribute];c?c.push(a):b[a.attribute]=[a]}),b},flattenErrorsToArray:function(a){return a.map(function(a){return a.error})},cleanAttributes:function(a,b){function c(a,b,c){return e.isObject(a[b])?a[b]:a[b]=c?!0:{}}function d(a){var b,d={};for(b in a)a[b]&&e.forEachKeyInKeypath(d,b,c);return d}function f(a,b){if(!e.isObject(a))return a;var c,d,g=e.extend({},a);for(d in a)c=b[d],e.isObject(c)?g[d]=f(g[d],c):c||delete g[d];return g}return e.isObject(b)&&e.isObject(a)?(b=d(b),f(a,b)):{}},exposeModule:function(a,b,c,d,e){c?(d&&d.exports&&(c=d.exports=a),c.validate=a):(b.validate=a,a.isFunction(e)&&e.amd&&e([],function(){return a}))},warn:function(a){"undefined"!=typeof console&&console.warn&&console.warn("[validate.js] "+a)},error:function(a){"undefined"!=typeof console&&console.error&&console.error("[validate.js] "+a)}}),d.validators={presence:function(a,b){return b=e.extend({},this.options,b),e.isEmpty(a)?b.message||this.message||"can't be blank":void 0},length:function(a,b,c){if(!e.isEmpty(a)){b=e.extend({},this.options,b);var d,f=b.is,g=b.maximum,h=b.minimum,i=b.tokenizer||function(a){return a},j=[];a=i(a);var k=a.length;return e.isNumber(k)?(e.isNumber(f)&&k!==f&&(d=b.wrongLength||this.wrongLength||"is the wrong length (should be %{count} characters)",j.push(e.format(d,{count:f}))),e.isNumber(h)&&h>k&&(d=b.tooShort||this.tooShort||"is too short (minimum is %{count} characters)",j.push(e.format(d,{count:h}))),e.isNumber(g)&&k>g&&(d=b.tooLong||this.tooLong||"is too long (maximum is %{count} characters)",j.push(e.format(d,{count:g}))),j.length>0?b.message||j:void 0):(e.error(e.format("Attribute %{attr} has a non numeric value for `length`",{attr:c})),b.message||this.notValid||"has an incorrect length")}},numericality:function(a,b){if(!e.isEmpty(a)){b=e.extend({},this.options,b);var c,d,f=[],g={greaterThan:function(a,b){return a>b},greaterThanOrEqualTo:function(a,b){return a>=b},equalTo:function(a,b){return a===b},lessThan:function(a,b){return b>a},lessThanOrEqualTo:function(a,b){return b>=a}};if(b.noStrings!==!0&&e.isString(a)&&(a=+a),!e.isNumber(a))return b.message||this.notValid||"is not a number";if(b.onlyInteger&&!e.isInteger(a))return b.message||this.notInteger||"must be an integer";for(c in g)if(d=b[c],e.isNumber(d)&&!g[c](a,d)){var h=this["not"+e.capitalize(c)]||"must be %{type} %{count}";f.push(e.format(h,{count:d,type:e.prettify(c)}))}return b.odd&&a%2!==1&&f.push(this.notOdd||"must be odd"),b.even&&a%2!==0&&f.push(this.notEven||"must be even"),f.length?b.message||f:void 0}},datetime:e.extend(function(a,b){if(!e.isEmpty(a)){b=e.extend({},this.options,b);var c,d=[],f=b.earliest?this.parse(b.earliest,b):0/0,g=b.latest?this.parse(b.latest,b):0/0;return a=this.parse(a,b),isNaN(a)||b.dateOnly&&a%864e5!==0?b.message||this.notValid||"must be a valid date":(!isNaN(f)&&f>a&&(c=this.tooEarly||"must be no earlier than %{date}",c=e.format(c,{date:this.format(f,b)}),d.push(c)),!isNaN(g)&&a>g&&(c=this.tooLate||"must be no later than %{date}",c=e.format(c,{date:this.format(g,b)}),d.push(c)),d.length?b.message||d:void 0)}},{parse:function(a,b){if(e.isFunction(e.XDate))return new e.XDate(a,!0).getTime();if(e.isDefined(e.moment))return+e.moment.utc(a);throw new Error("Neither XDate or moment.js was found")},format:function(a,b){var c=b.dateFormat;if(e.isFunction(e.XDate))return c=c||(b.dateOnly?"yyyy-MM-dd":"yyyy-MM-dd HH:mm:ss"),new e.XDate(a,!0).toString(c);if(e.isDefined(e.moment))return c=c||(b.dateOnly?"YYYY-MM-DD":"YYYY-MM-DD HH:mm:ss"),e.moment.utc(a).format(c);throw new Error("Neither XDate or moment.js was found")}}),date:function(a,b){return b=e.extend({},b,{dateOnly:!0}),e.validators.datetime.call(e.validators.datetime,a,b)},format:function(a,b){(e.isString(b)||b instanceof RegExp)&&(b={pattern:b}),b=e.extend({},this.options,b);var c,d=b.message||this.message||"is invalid",f=b.pattern;return e.isEmpty(a)?void 0:e.isString(a)?(e.isString(f)&&(f=new RegExp(b.pattern,b.flags)),c=f.exec(a),c&&c[0].length==a.length?void 0:d):d},inclusion:function(a,b){if(!e.isEmpty(a)&&(e.isArray(b)&&(b={within:b}),b=e.extend({},this.options,b),!e.contains(b.within,a))){var c=b.message||this.message||"^%{value} is not included in the list";return e.format(c,{value:a})}},exclusion:function(a,b){if(!e.isEmpty(a)&&(e.isArray(b)&&(b={within:b}),b=e.extend({},this.options,b),e.contains(b.within,a))){var c=b.message||this.message||"^%{value} is restricted";return e.format(c,{value:a})}},email:e.extend(function(a,b){b=e.extend({},this.options,b);var c=b.message||this.message||"is not a valid email";if(!e.isEmpty(a))return e.isString(a)&&this.PATTERN.exec(a)?void 0:c},{PATTERN:/^[a-z0-9\u007F-\uffff!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9\u007F-\uffff!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z]{2,}$/i}),equality:function(a,b,c,d){if(!e.isEmpty(a)){e.isString(b)&&(b={attribute:b}),b=e.extend({},this.options,b);var f=b.message||this.message||"is not equal to %{attribute}";if(e.isEmpty(b.attribute)||!e.isString(b.attribute))throw new Error("The attribute must be a non empty string");var g=e.getDeepObjectValue(d,b.attribute),h=b.comparator||function(a,b){return a===b};return h(a,g,b,c,d)?void 0:e.format(f,{attribute:e.prettify(b.attribute)})}}},d.exposeModule(d,this,a,b,c)}).call(this,"undefined"!=typeof exports?exports:null,"undefined"!=typeof module?module:null,"undefined"!=typeof define?define:null);
//# sourceMappingURL=validate.min.map