/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.AnchorPointBuilder;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.brewer.styling.builder.DisplacementBuilder;
import org.geotools.brewer.styling.builder.ExternalGraphicBuilder;
import org.geotools.brewer.styling.builder.MarkBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Symbol;
import org.opengis.filter.expression.Expression;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.AnchorPoint;
import org.opengis.style.Displacement;
import org.opengis.style.GraphicalSymbol;

public class GraphicBuilder
extends AbstractStyleBuilder<org.opengis.style.Graphic> {
    List<Builder<? extends Symbol>> symbols = new ArrayList<Builder<? extends Symbol>>();
    Expression opacity;
    Expression size;
    Expression rotation;
    private AnchorPointBuilder anchor = new AnchorPointBuilder(this, 0.5, 0.5).unset();
    private DisplacementBuilder displacement = new DisplacementBuilder(this).unset();

    public GraphicBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    GraphicBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public GraphicBuilder opacity(Expression opacity) {
        this.unset = false;
        this.opacity = opacity;
        return this;
    }

    public GraphicBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public GraphicBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public GraphicBuilder size(Expression size) {
        this.unset = false;
        this.size = size;
        return this;
    }

    public GraphicBuilder size(double size) {
        return this.size(this.literal(size));
    }

    public GraphicBuilder size(String cqlExpression) {
        return this.size(this.cqlExpression(cqlExpression));
    }

    public GraphicBuilder rotation(Expression rotation) {
        this.unset = false;
        this.rotation = rotation;
        return this;
    }

    public GraphicBuilder rotation(double rotation) {
        return this.rotation(this.literal(rotation));
    }

    public GraphicBuilder rotation(String cqlExpression) {
        return this.rotation(this.cqlExpression(cqlExpression));
    }

    public ExternalGraphicBuilder externalGraphic() {
        this.unset = false;
        ExternalGraphicBuilder builder = new ExternalGraphicBuilder(this);
        this.symbols.add(builder);
        return builder;
    }

    public GraphicBuilder externalGraphic(URL onlineResource, String format) {
        this.unset = false;
        ExternalGraphicBuilder builder = this.externalGraphic();
        try {
            builder.format(format).resource((OnLineResource)new OnLineResourceImpl(onlineResource.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to build URI from URL", e);
        }
        return this;
    }

    public GraphicBuilder externalGraphic(String onlineResource, String format) {
        this.unset = false;
        ExternalGraphicBuilder builder = this.externalGraphic();
        builder.format(format).location(onlineResource);
        return this;
    }

    public MarkBuilder mark() {
        this.unset = false;
        MarkBuilder builder = new MarkBuilder(this);
        this.symbols.add(builder);
        return builder;
    }

    public AnchorPointBuilder anchor() {
        this.unset = false;
        return this.anchor;
    }

    public DisplacementBuilder displacement() {
        this.unset = false;
        return this.displacement;
    }

    @Override
    public Graphic build() {
        if (this.unset) {
            return null;
        }
        if (this.symbols.size() == 0) {
            this.mark();
        }
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (Builder<? extends Symbol> symbol : this.symbols) {
            list.add(symbol.build());
        }
        org.opengis.style.Graphic g = this.sf.graphic(list, this.opacity, this.size, this.rotation, (AnchorPoint)this.anchor.build(), (Displacement)this.displacement.build());
        if (this.parent == null) {
            this.reset();
        }
        return g;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().point().graphic().init(this);
    }

    @Override
    public GraphicBuilder unset() {
        this.displacement.unset();
        this.anchor.unset();
        return (GraphicBuilder)super.unset();
    }

    public GraphicBuilder reset() {
        this.unset = false;
        this.symbols.clear();
        this.opacity = this.literal(1.0);
        this.size = null;
        this.rotation = this.literal(0);
        this.displacement.unset();
        this.anchor.unset();
        return this;
    }

    public GraphicBuilder reset(org.opengis.style.Graphic graphic) {
        if (graphic == null || graphic.graphicalSymbols().size() == 0) {
            return this.unset();
        }
        this.unset = false;
        this.symbols.clear();
        for (GraphicalSymbol graphicalSymbol : graphic.graphicalSymbols()) {
            AbstractStyleBuilder builder;
            if (!(graphicalSymbol instanceof Symbol)) continue;
            Symbol symbol = (Symbol)graphicalSymbol;
            if (symbol instanceof Mark) {
                builder = new MarkBuilder(this).reset((Mark)symbol);
            } else if (symbol instanceof ExternalGraphic) {
                builder = new ExternalGraphicBuilder(this).reset((ExternalGraphic)symbol);
            } else {
                throw new IllegalArgumentException("Unrecognized symbol type: " + symbol.getClass());
            }
            if (builder != null) {
                this.symbols.add(builder);
                continue;
            }
            throw new RuntimeException("Failed to clone a builder for symbol: " + symbol);
        }
        this.opacity = graphic.getOpacity();
        this.size = graphic.getSize();
        this.rotation = graphic.getRotation();
        this.displacement.reset(graphic.getDisplacement());
        this.anchor.reset(graphic.getAnchorPoint());
        return this;
    }
}

