/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.ByteCollection;
import bak.pcj.ByteIterator;
import bak.pcj.set.AbstractByteSet;
import bak.pcj.set.ByteRange;
import bak.pcj.set.ByteSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;

public class ByteRangeSet
extends AbstractByteSet
implements ByteSortedSet,
Cloneable,
Serializable {
    private ArrayList ranges = new ArrayList();
    private int size = 0;

    public ByteRangeSet() {
    }

    public ByteRangeSet(byte[] a) {
        this();
        this.addAll(a);
    }

    public ByteRangeSet(ByteCollection c) {
        this();
        this.addAll(c);
    }

    private ByteRange range(int index) {
        return (ByteRange)this.ranges.get(index);
    }

    private ByteRange getRangeOf(byte v) {
        int index = this.getRangeIndexOf(v);
        return index >= 0 ? this.range(index) : null;
    }

    private int getRangeIndexOf(byte v) {
        if (this.size == 0) {
            return -1;
        }
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            ByteRange r = (ByteRange)this.ranges.get(mid);
            if (r.contains(v)) {
                return mid;
            }
            if (v < r.first()) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -(lo + 1);
    }

    private int insertRange(ByteRange range) {
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            ByteRange r = this.range(mid);
            int compare = range.compareTo(r);
            if (compare == 0) {
                return -1;
            }
            if (compare < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        this.ranges.add(lo, range);
        return lo;
    }

    private void normalize(int index) {
        while (index < this.ranges.size() - 1) {
            ByteRange r2;
            ByteRange r1 = this.range(index);
            ByteRange r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 == null) break;
            this.ranges.set(index, r3);
            this.ranges.remove(index + 1);
            this.size -= r1.intersectionLength(r2);
        }
    }

    private void normalize() {
        ByteRange r3;
        int index = 0;
        this.size = 0;
        while (index < this.ranges.size() - 1) {
            ByteRange r2;
            ByteRange r1 = this.range(index);
            r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 != null) {
                this.ranges.set(index, r3);
                this.ranges.remove(index + 1);
                continue;
            }
            this.size += r1.length();
            ++index;
        }
        r3 = this.range(this.ranges.size() - 1);
        this.size += r3.length();
    }

    public boolean add(byte v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return false;
        }
        int insertionIndex = -index - 1;
        this.ranges.add(insertionIndex, new ByteRange(v, v));
        if (insertionIndex > 0) {
            --insertionIndex;
        }
        ++this.size;
        this.normalize(insertionIndex);
        return true;
    }

    public ByteIterator iterator() {
        return new ByteIterator(){
            int nextIndex = 0;
            int lastIndex = -1;
            int currRange = 0;
            int currOffset = 0;
            byte lastValue;

            public boolean hasNext() {
                return this.nextIndex < ByteRangeSet.this.size;
            }

            public byte next() {
                if (this.nextIndex >= ByteRangeSet.this.size) {
                    Exceptions.endOfIterator();
                }
                this.lastIndex = this.nextIndex++;
                this.lastValue = this.curr();
                if (this.nextIndex < ByteRangeSet.this.size) {
                    if (this.currOffset == ByteRangeSet.this.range(this.currRange).length() - 1) {
                        ++this.currRange;
                        this.currOffset = 0;
                    } else {
                        ++this.currOffset;
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                ByteRangeSet.this.remove(this.lastValue);
                --this.nextIndex;
                if (this.nextIndex < ByteRangeSet.this.size) {
                    this.recalc();
                }
                this.lastIndex = -1;
            }

            private byte curr() {
                return (byte)(ByteRangeSet.this.range(this.currRange).first() + this.currOffset);
            }

            private void recalc() {
                int rs;
                this.currRange = 0;
                this.currOffset = this.nextIndex;
                while (this.currOffset >= (rs = ByteRangeSet.this.range(this.currRange).length())) {
                    this.currOffset -= rs;
                    ++this.currRange;
                }
            }
        };
    }

    public byte first() {
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        return this.range(0).first();
    }

    private byte firstFrom(byte v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        if ((index = -index - 1) >= this.ranges.size()) {
            Exceptions.setNoFirst();
        }
        return this.range(index).first();
    }

    public byte last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        return this.range(this.ranges.size() - 1).last();
    }

    private byte lastFrom(byte v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        index = -index - 1;
        if (--index < 0 || index >= this.ranges.size()) {
            Exceptions.setNoLast();
        }
        return this.range(index).last();
    }

    public ByteSortedSet headSet(byte to) {
        return new SubSet(false, 0, true, to);
    }

    public ByteSortedSet tailSet(byte from) {
        return new SubSet(true, from, false, 0);
    }

    public ByteSortedSet subSet(byte from, byte to) {
        return new SubSet(true, from, true, to);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        int i = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.range(i));
            ++i;
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            ByteRangeSet c = (ByteRangeSet)super.clone();
            c.ranges = (ArrayList)this.ranges.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        this.ranges.clear();
        this.size = 0;
    }

    public boolean contains(byte v) {
        return this.getRangeIndexOf(v) >= 0;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        boolean index = false;
        int rsize = this.ranges.size();
        while (i < rsize) {
            ByteRange r = this.range(i);
            byte c = r.first();
            byte last = r.last();
            while (c <= last) {
                h += c;
                c = (byte)(c + 1);
            }
            ++i;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(byte v) {
        int index = this.getRangeIndexOf(v);
        if (index < 0) {
            return false;
        }
        ByteRange r = this.range(index);
        if (v == r.first()) {
            if (r.length() == 1) {
                this.ranges.remove(index);
            } else {
                this.ranges.set(index, new ByteRange((byte)(r.first() + 1), r.last()));
            }
        } else if (v == r.last()) {
            this.ranges.set(index, new ByteRange(r.first(), (byte)(r.last() - 1)));
        } else {
            ByteRange r1 = new ByteRange(r.first(), (byte)(v - 1));
            ByteRange r2 = new ByteRange((byte)(v + 1), r.last());
            this.ranges.set(index, r1);
            this.ranges.add(index + 1, r2);
        }
        --this.size;
        return true;
    }

    public byte[] toArray(byte[] a) {
        if (a == null || a.length < this.size) {
            a = new byte[this.size];
        }
        int i = 0;
        int index = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            ByteRange r = this.range(i);
            byte c = r.first();
            byte last = r.last();
            while (c <= last) {
                a[index++] = c;
                c = (byte)(c + 1);
            }
            ++i;
        }
        return a;
    }

    public boolean containsAll(ByteRange range) {
        ByteRange r = this.getRangeOf(range.first());
        return r != null ? r.contains(range.last()) : false;
    }

    public boolean addAll(ByteRangeSet c) {
        int oldSize = this.size;
        int i = 0;
        int rsize = c.ranges.size();
        while (i < rsize) {
            this.addAll(c.range(i));
            ++i;
        }
        return this.size != oldSize;
    }

    public boolean addAll(ByteRange range) {
        int oldSize = this.size;
        int index = this.insertRange(range);
        if (index != -1) {
            int nindex = index;
            if (nindex > 0) {
                --nindex;
            }
            this.size += range.length();
            this.normalize(nindex);
        }
        return this.size != oldSize;
    }

    public boolean addAll(byte first, byte last) {
        return this.addAll(new ByteRange(first, last));
    }

    public boolean addAll(byte[] a) {
        byte[] sa;
        if (a.length == 0) {
            return false;
        }
        int oldSize = this.size;
        if (!this.isSorted(a)) {
            sa = (byte[])a.clone();
            Arrays.sort(sa);
        } else {
            sa = a;
        }
        int index = 0;
        while (index < sa.length) {
            byte c0 = sa[index];
            index = this.range(sa, index);
            byte c1 = sa[index];
            this.ranges.add(new ByteRange(c0, c1));
            ++index;
        }
        Collections.sort(this.ranges);
        this.normalize();
        return this.size != oldSize;
    }

    private int range(byte[] a, int index) {
        byte c0 = a[index++];
        while (index < a.length && a[index] == c0) {
            ++index;
        }
        while (index < a.length && a[index] == (byte)(c0 + 1)) {
            c0 = a[index++];
            while (index < a.length && a[index] == c0) {
                ++index;
            }
        }
        return index - 1;
    }

    private boolean isSorted(byte[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i] < a[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ByteRange[] ranges() {
        ByteRange[] a = new ByteRange[this.ranges.size()];
        this.ranges.toArray(a);
        return a;
    }

    private class SubSet
    extends AbstractByteSet
    implements ByteSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private byte lowerBound;
        private byte upperBound;

        SubSet(boolean hasLowerBound, byte lowerBound, boolean hasUpperBound, byte upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(byte v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ByteRangeSet.this.add(v);
        }

        public boolean remove(byte v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ByteRangeSet.this.remove(v);
        }

        public boolean contains(byte v) {
            return this.inSubRange(v) && ByteRangeSet.this.contains(v);
        }

        public ByteIterator iterator() {
            byte first;
            try {
                first = this.first();
            }
            catch (NoSuchElementException e) {
                return new EmptySubSetIterator();
            }
            byte last = this.last();
            int rangeIndexLow = ByteRangeSet.this.getRangeIndexOf(first);
            int rangeIndexHigh = ByteRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                return new SimpleSubSetIterator(first, last);
            }
            return new NonEmptySubSetIterator(first, last, rangeIndexLow, rangeIndexHigh);
        }

        public int size() {
            int size;
            int rangeIndexLow;
            byte first;
            if (ByteRangeSet.this.size() == 0) {
                return 0;
            }
            try {
                first = this.first();
                rangeIndexLow = ByteRangeSet.this.getRangeIndexOf(first);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            byte last = this.last();
            int rangeIndexHigh = ByteRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                size = last - first + 1;
            } else {
                ByteRange rangeLow = ByteRangeSet.this.range(rangeIndexLow);
                ByteRange rangeHigh = ByteRangeSet.this.range(rangeIndexHigh);
                int sizeLow = rangeLow.last() - first + 1;
                int sizeHigh = last - rangeHigh.first() + 1;
                size = sizeLow + sizeHigh;
                int i = rangeIndexLow + 1;
                while (i < rangeIndexHigh) {
                    size += ByteRangeSet.this.range(i).length();
                    ++i;
                }
            }
            return size;
        }

        public byte first() {
            byte first = ByteRangeSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : (byte)0);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public byte last() {
            byte last = ByteRangeSet.this.lastFrom(this.hasUpperBound ? (byte)(this.upperBound - 1) : ByteRangeSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public ByteSortedSet headSet(byte to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public ByteSortedSet tailSet(byte from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public ByteSortedSet subSet(byte from, byte to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(byte v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class NonEmptySubSetIterator
        implements ByteIterator {
            byte first;
            byte last;
            int rangeIndexLow;
            int rangeIndexHigh;
            ByteRange rangeLow;
            ByteRange rangeHigh;
            byte previousValue;
            ByteRange currRange;
            int currRangeIndex;
            int currOffset;
            boolean valueAvailable;
            int nextIndex;

            NonEmptySubSetIterator(byte first, byte last, int rangeIndexLow, int rangeIndexHigh) {
                if (rangeIndexLow == rangeIndexHigh) {
                    throw new RuntimeException("Internal error");
                }
                this.first = first;
                this.last = last;
                this.rangeIndexLow = rangeIndexLow;
                this.rangeIndexHigh = rangeIndexHigh;
                this.rangeLow = new ByteRange(first, ByteRangeSet.this.range(rangeIndexLow).last());
                this.rangeHigh = new ByteRange(ByteRangeSet.this.range(rangeIndexHigh).first(), last);
                this.currRangeIndex = rangeIndexLow;
                this.currRange = this.rangeLow;
                this.currOffset = 0;
                this.previousValue = first;
                this.valueAvailable = false;
                this.nextIndex = 0;
            }

            private ByteRange getRange(int rangeIndex) {
                if (rangeIndex == this.rangeIndexLow) {
                    return this.rangeLow;
                }
                if (rangeIndex == this.rangeIndexHigh) {
                    return this.rangeHigh;
                }
                return ByteRangeSet.this.range(rangeIndex);
            }

            private void recalc() {
                int rs;
                this.first = SubSet.this.first();
                this.last = SubSet.this.last();
                this.rangeIndexLow = ByteRangeSet.this.getRangeIndexOf(this.first);
                this.rangeIndexHigh = ByteRangeSet.this.getRangeIndexOf(this.last);
                if (this.rangeIndexLow == this.rangeIndexHigh) {
                    this.rangeLow = this.rangeHigh = new ByteRange(this.first, this.last);
                } else {
                    this.rangeLow = new ByteRange(this.first, ByteRangeSet.this.range(this.rangeIndexLow).last());
                    this.rangeHigh = new ByteRange(ByteRangeSet.this.range(this.rangeIndexHigh).first(), this.last);
                }
                this.currOffset = this.nextIndex;
                this.currRangeIndex = this.rangeIndexLow;
                this.currRange = this.rangeLow;
                while (this.currOffset >= (rs = this.currRange.length())) {
                    this.currOffset -= rs;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
            }

            public boolean hasNext() {
                return this.previousValue < this.last;
            }

            public byte next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.previousValue = (byte)(this.currRange.first() + this.currOffset++);
                if (this.currOffset == this.currRange.length() && this.previousValue < this.last) {
                    this.currOffset = 0;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
                ++this.nextIndex;
                this.valueAvailable = true;
                return this.previousValue;
            }

            public void remove() {
                if (!this.valueAvailable) {
                    Exceptions.noElementToRemove();
                }
                ByteRangeSet.this.remove(this.previousValue);
                --this.nextIndex;
                this.recalc();
                this.valueAvailable = false;
            }
        }

        class SimpleSubSetIterator
        implements ByteIterator {
            int nextIndex;
            int size;
            int lastIndex;
            byte lastValue;
            byte from;
            byte to;

            SimpleSubSetIterator(byte from, byte to) {
                this.size = to - from + 1;
                this.nextIndex = 0;
                this.lastIndex = -1;
                this.from = from;
                this.to = to;
            }

            public boolean hasNext() {
                return this.nextIndex < this.size;
            }

            public byte next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (byte)(this.from + this.nextIndex);
                this.lastIndex = this.nextIndex++;
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                ByteRangeSet.this.remove(this.lastValue);
                this.lastIndex = -1;
            }
        }

        class EmptySubSetIterator
        implements ByteIterator {
            EmptySubSetIterator() {
            }

            public boolean hasNext() {
                return false;
            }

            public byte next() {
                Exceptions.endOfIterator();
                throw new RuntimeException();
            }

            public void remove() {
                Exceptions.noElementToRemove();
            }
        }
    }
}

