/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.AbstractIntCollection;
import bak.pcj.IntCollection;
import bak.pcj.IntIterator;
import bak.pcj.ShortIterator;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.hash.ShortHashFunction;
import bak.pcj.map.AbstractShortKeyIntMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyIntMap;
import bak.pcj.map.ShortKeyIntMapIterator;
import bak.pcj.set.AbstractShortSet;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ShortKeyIntOpenHashMap
extends AbstractShortKeyIntMap
implements ShortKeyIntMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private ShortHashFunction keyhash;
    private int size;
    private transient short[] keys;
    private transient int[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient ShortSet ckeys;
    private transient IntCollection cvalues;
    private transient boolean hasLastValue;
    private transient int lastValue;

    private ShortKeyIntOpenHashMap(ShortHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.keys = new short[capacity];
        this.values = new int[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    private ShortKeyIntOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultShortHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public ShortKeyIntOpenHashMap() {
        this(11);
    }

    public ShortKeyIntOpenHashMap(ShortKeyIntMap map) {
        this();
        this.putAll(map);
    }

    public ShortKeyIntOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public ShortKeyIntOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public ShortKeyIntOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public ShortKeyIntOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public ShortKeyIntOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public ShortKeyIntOpenHashMap(ShortHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public ShortKeyIntOpenHashMap(ShortHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public ShortKeyIntOpenHashMap(ShortHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public ShortKeyIntOpenHashMap(ShortHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public ShortKeyIntOpenHashMap(ShortHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public ShortKeyIntOpenHashMap(ShortHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            short[] newkeys = new short[newcapacity];
            int[] newvalues = new int[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.keys.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    short k = this.keys[i];
                    int v = this.values[i];
                    int h = Math.abs(this.keyhash.hash(k));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newvalues[n] = v;
                    newkeys[n] = k;
                }
                ++i;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    public ShortSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    public int lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(short key, int value) {
        int i;
        block5: {
            int h = Math.abs(this.keyhash.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (this.keys[i] == key) {
                    int oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.keys[i] != key);
                int oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return MapDefaults.defaultInt();
    }

    public IntCollection values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            ShortKeyIntOpenHashMap c = (ShortKeyIntOpenHashMap)super.clone();
            c.keys = new short[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new int[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public ShortKeyIntMapIterator entries() {
        return new ShortKeyIntMapIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < ShortKeyIntOpenHashMap.this.keys.length && ShortKeyIntOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < ShortKeyIntOpenHashMap.this.keys.length;
            }

            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((ShortKeyIntOpenHashMap)ShortKeyIntOpenHashMap.this).states[this.lastEntry] = 2;
                ShortKeyIntOpenHashMap.this.size--;
                this.lastEntry = -1;
            }

            public short getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return ShortKeyIntOpenHashMap.this.keys[this.lastEntry];
            }

            public int getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return ShortKeyIntOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    public void clear() {
        Arrays.fill(this.states, (byte)0);
        this.size = 0;
        this.used = 0;
    }

    public boolean containsKey(short key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                this.hasLastValue = true;
                this.lastValue = this.values[i];
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                this.hasLastValue = false;
                return false;
            } while (this.states[i] != 1 || this.keys[i] != key);
            this.hasLastValue = true;
            this.lastValue = this.values[i];
            return true;
        }
        this.hasLastValue = false;
        return false;
    }

    public boolean containsValue(int value) {
        int i = 0;
        while (i < this.states.length) {
            if (this.states[i] == 1 && this.values[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int get(short key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return MapDefaults.defaultInt();
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        return MapDefaults.defaultInt();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int remove(short key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                int oldValue = this.values[i];
                this.states[i] = 2;
                --this.size;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return MapDefaults.defaultInt();
            } while (this.states[i] != 1 || this.keys[i] != key);
            int oldValue = this.values[i];
            this.states[i] = 2;
            --this.size;
            return oldValue;
        }
        return MapDefaults.defaultInt();
    }

    public int size() {
        return this.size;
    }

    public int tget(short key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                Exceptions.noSuchMapping(String.valueOf(key));
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        Exceptions.noSuchMapping(String.valueOf(key));
        throw new RuntimeException();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        ShortKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeShort(i.getKey());
            s.writeInt(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new short[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new int[this.keys.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            short key = s.readShort();
            int value = s.readInt();
            int h = Math.abs(this.keyhash.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
            ++n;
        }
    }

    private class ValueCollection
    extends AbstractIntCollection {
        private ValueCollection() {
        }

        public void clear() {
            ShortKeyIntOpenHashMap.this.clear();
        }

        public boolean contains(int v) {
            return ShortKeyIntOpenHashMap.this.containsValue(v);
        }

        public IntIterator iterator() {
            return new IntIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < ShortKeyIntOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length && ShortKeyIntOpenHashMap.access$300(ValueCollection.access$700(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < ShortKeyIntOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length;
                }

                public int next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return ShortKeyIntOpenHashMap.access$500(ValueCollection.access$700(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    ShortKeyIntOpenHashMap.access$300((ShortKeyIntOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = 2;
                    ShortKeyIntOpenHashMap.access$410(ValueCollection.access$700(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public int size() {
            return ShortKeyIntOpenHashMap.this.size;
        }

        static /* synthetic */ ShortKeyIntOpenHashMap access$700(ValueCollection x0) {
            return x0.ShortKeyIntOpenHashMap.this;
        }
    }

    private class KeySet
    extends AbstractShortSet {
        private KeySet() {
        }

        public void clear() {
            ShortKeyIntOpenHashMap.this.clear();
        }

        public boolean contains(short v) {
            return ShortKeyIntOpenHashMap.this.containsKey(v);
        }

        public ShortIterator iterator() {
            return new ShortIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < ShortKeyIntOpenHashMap.access$200(KeySet.access$600(this.this$1)).length && ShortKeyIntOpenHashMap.access$300(KeySet.access$600(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < ShortKeyIntOpenHashMap.access$200(KeySet.access$600(this.this$1)).length;
                }

                public short next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return ShortKeyIntOpenHashMap.access$200(KeySet.access$600(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    ShortKeyIntOpenHashMap.access$300((ShortKeyIntOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = 2;
                    ShortKeyIntOpenHashMap.access$410(KeySet.access$600(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public boolean remove(short v) {
            boolean result = ShortKeyIntOpenHashMap.this.containsKey(v);
            if (result) {
                ShortKeyIntOpenHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return ShortKeyIntOpenHashMap.this.size;
        }

        static /* synthetic */ ShortKeyIntOpenHashMap access$600(KeySet x0) {
            return x0.ShortKeyIntOpenHashMap.this;
        }
    }
}

