/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.AbstractLongCollection;
import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractObjectKeyLongMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyLongMap;
import bak.pcj.map.ObjectKeyLongMapIterator;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class ObjectKeyLongChainedHashMap
extends AbstractObjectKeyLongMap
implements ObjectKeyLongMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private int size;
    private transient Entry[] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient Set keys;
    private transient LongCollection values;
    private transient boolean hasLastValue;
    private transient long lastValue;

    private ObjectKeyLongChainedHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.data = new Entry[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    public ObjectKeyLongChainedHashMap() {
        this(11);
    }

    public ObjectKeyLongChainedHashMap(ObjectKeyLongMap map) {
        this();
        this.putAll(map);
    }

    public ObjectKeyLongChainedHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public ObjectKeyLongChainedHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public ObjectKeyLongChainedHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public ObjectKeyLongChainedHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public ObjectKeyLongChainedHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private static int hash(Object key) {
        return key == null ? 0 : key.hashCode();
    }

    private static boolean keyeq(Object k1, Object k2) {
        return k1 == null ? k2 == null : k1.equals(k2);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Entry[] newdata = new Entry[newcapacity];
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    int index = Math.abs(ObjectKeyLongChainedHashMap.hash(e.key)) % newdata.length;
                    Entry next = e.next;
                    e.next = newdata[index];
                    newdata[index] = e;
                    e = next;
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private Entry addList(Entry list, Entry v) {
        v.next = list;
        return v;
    }

    private Entry removeList(Entry list, Entry e) {
        if (list == e) {
            list = e.next;
            e.next = null;
            return list;
        }
        Entry listStart = list;
        while (list.next != e) {
            list = list.next;
        }
        list.next = e.next;
        e.next = null;
        return listStart;
    }

    private Entry searchList(Entry list, Object key) {
        while (list != null) {
            if (ObjectKeyLongChainedHashMap.keyeq(list.key, key)) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    private Entry getEntry(Object key) {
        int index = Math.abs(ObjectKeyLongChainedHashMap.hash(key)) % this.data.length;
        return this.searchList(this.data[index], key);
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public long lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public long put(Object key, long value) {
        long result;
        int index = Math.abs(ObjectKeyLongChainedHashMap.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            result = MapDefaults.defaultLong();
            e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            this.ensureCapacity(this.size + 1);
            ++this.size;
        } else {
            result = e.value;
            e.value = value;
        }
        return result;
    }

    public LongCollection values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public Object clone() {
        try {
            ObjectKeyLongChainedHashMap c = (ObjectKeyLongChainedHashMap)super.clone();
            c.data = new Entry[this.data.length];
            int i = 0;
            while (i < this.data.length) {
                c.data[i] = this.cloneList(this.data[i]);
                ++i;
            }
            c.values = null;
            c.keys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    private Entry cloneList(Entry e) {
        if (e == null) {
            return null;
        }
        Entry ne = new Entry(e.getKey(), e.getValue());
        ne.next = this.cloneList(e.next);
        return ne;
    }

    public ObjectKeyLongMapIterator entries() {
        return new ObjectKeyLongMapIterator(){
            Entry currEntry = null;
            int nextList = this.nextList(0);
            Entry nextEntry = this.nextList == -1 ? null : ObjectKeyLongChainedHashMap.access$300(ObjectKeyLongChainedHashMap.this)[this.nextList];

            int nextList(int index) {
                while (index < ObjectKeyLongChainedHashMap.this.data.length && ObjectKeyLongChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < ObjectKeyLongChainedHashMap.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.nextEntry != null;
            }

            public void next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = ObjectKeyLongChainedHashMap.this.data[this.nextList];
                    }
                }
            }

            public Object getKey() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getKey();
            }

            public long getValue() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getValue();
            }

            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                ObjectKeyLongChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }
        };
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    public boolean containsKey(Object key) {
        Entry e = this.getEntry(key);
        if (e == null) {
            this.hasLastValue = false;
        } else {
            this.hasLastValue = true;
            this.lastValue = e.value;
        }
        return this.hasLastValue;
    }

    public boolean containsValue(long value) {
        int i = 0;
        while (i < this.data.length) {
            Entry e = this.data[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    public long get(Object key) {
        int index = Math.abs(ObjectKeyLongChainedHashMap.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        return e != null ? e.value : MapDefaults.defaultLong();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long remove(Object key) {
        long value;
        int index = Math.abs(ObjectKeyLongChainedHashMap.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e != null) {
            this.data[index] = this.removeList(this.data[index], e);
            value = e.value;
            --this.size;
        } else {
            value = MapDefaults.defaultLong();
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    public long tget(Object key) {
        int index = Math.abs(ObjectKeyLongChainedHashMap.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            Exceptions.noSuchMapping(key);
        }
        return e.value;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        ObjectKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeObject(i.getKey());
            s.writeLong(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new Entry[s.readInt()];
        int i = 0;
        while (i < this.size) {
            Object key = s.readObject();
            long value = s.readLong();
            int index = Math.abs(ObjectKeyLongChainedHashMap.hash(key)) % this.data.length;
            Entry e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            ++i;
        }
    }

    private class ValueCollection
    extends AbstractLongCollection {
        private ValueCollection() {
        }

        public void clear() {
            ObjectKeyLongChainedHashMap.this.clear();
        }

        public boolean contains(long v) {
            return ObjectKeyLongChainedHashMap.this.containsValue(v);
        }

        public LongIterator iterator() {
            return new LongIterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : ObjectKeyLongChainedHashMap.access$300(ValueCollection.access$700(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < ObjectKeyLongChainedHashMap.access$300(ValueCollection.access$700(this.this$1)).length && ObjectKeyLongChainedHashMap.access$300(ValueCollection.access$700(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < ObjectKeyLongChainedHashMap.access$300(ValueCollection.access$700(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public long next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = ObjectKeyLongChainedHashMap.access$300(ValueCollection.access$700(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.value;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    ValueCollection.access$700(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public int size() {
            return ObjectKeyLongChainedHashMap.this.size;
        }

        static /* synthetic */ ObjectKeyLongChainedHashMap access$700(ValueCollection x0) {
            return x0.ObjectKeyLongChainedHashMap.this;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public void clear() {
            ObjectKeyLongChainedHashMap.this.clear();
        }

        public boolean contains(Object v) {
            return ObjectKeyLongChainedHashMap.this.getEntry(v) != null;
        }

        public Iterator iterator() {
            return new Iterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : ObjectKeyLongChainedHashMap.access$300(KeySet.access$500(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < ObjectKeyLongChainedHashMap.access$300(KeySet.access$500(this.this$1)).length && ObjectKeyLongChainedHashMap.access$300(KeySet.access$500(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < ObjectKeyLongChainedHashMap.access$300(KeySet.access$500(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public Object next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = ObjectKeyLongChainedHashMap.access$300(KeySet.access$500(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.key;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    KeySet.access$500(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public boolean remove(Object v) {
            boolean result = ObjectKeyLongChainedHashMap.this.containsKey(v);
            if (result) {
                ObjectKeyLongChainedHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return ObjectKeyLongChainedHashMap.this.size;
        }

        static /* synthetic */ ObjectKeyLongChainedHashMap access$500(KeySet x0) {
            return x0.ObjectKeyLongChainedHashMap.this;
        }
    }

    private static class Entry {
        Object key;
        long value;
        Entry next;

        Entry(Object key, long value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return ObjectKeyLongChainedHashMap.keyeq(e.getKey(), this.key) && e.getValue() == this.value;
        }
    }
}

