/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.AbstractFloatCollection;
import bak.pcj.FloatCollection;
import bak.pcj.FloatIterator;
import bak.pcj.LongIterator;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.hash.LongHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractLongKeyFloatMap;
import bak.pcj.map.LongKeyFloatMap;
import bak.pcj.map.LongKeyFloatMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.AbstractLongSet;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class LongKeyFloatChainedHashMap
extends AbstractLongKeyFloatMap
implements LongKeyFloatMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private LongHashFunction keyhash;
    private int size;
    private transient Entry[] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient LongSet keys;
    private transient FloatCollection values;
    private transient boolean hasLastValue;
    private transient float lastValue;

    private LongKeyFloatChainedHashMap(LongHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        this.data = new Entry[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    private LongKeyFloatChainedHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultLongHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public LongKeyFloatChainedHashMap() {
        this(11);
    }

    public LongKeyFloatChainedHashMap(LongKeyFloatMap map) {
        this();
        this.putAll(map);
    }

    public LongKeyFloatChainedHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public LongKeyFloatChainedHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public LongKeyFloatChainedHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public LongKeyFloatChainedHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongKeyFloatChainedHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public LongKeyFloatChainedHashMap(LongHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public LongKeyFloatChainedHashMap(LongHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public LongKeyFloatChainedHashMap(LongHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public LongKeyFloatChainedHashMap(LongHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public LongKeyFloatChainedHashMap(LongHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongKeyFloatChainedHashMap(LongHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Entry[] newdata = new Entry[newcapacity];
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    int index = Math.abs(this.keyhash.hash(e.key)) % newdata.length;
                    Entry next = e.next;
                    e.next = newdata[index];
                    newdata[index] = e;
                    e = next;
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private Entry addList(Entry list, Entry v) {
        v.next = list;
        return v;
    }

    private Entry removeList(Entry list, Entry e) {
        if (list == e) {
            list = e.next;
            e.next = null;
            return list;
        }
        Entry listStart = list;
        while (list.next != e) {
            list = list.next;
        }
        list.next = e.next;
        e.next = null;
        return listStart;
    }

    private Entry searchList(Entry list, long key) {
        while (list != null) {
            if (list.key == key) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    private Entry getEntry(long key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        return this.searchList(this.data[index], key);
    }

    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public float lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public float put(long key, float value) {
        float result;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            result = MapDefaults.defaultFloat();
            e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            this.ensureCapacity(this.size + 1);
            ++this.size;
        } else {
            result = e.value;
            e.value = value;
        }
        return result;
    }

    public FloatCollection values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public Object clone() {
        try {
            LongKeyFloatChainedHashMap c = (LongKeyFloatChainedHashMap)super.clone();
            c.data = new Entry[this.data.length];
            int i = 0;
            while (i < this.data.length) {
                c.data[i] = this.cloneList(this.data[i]);
                ++i;
            }
            c.values = null;
            c.keys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    private Entry cloneList(Entry e) {
        if (e == null) {
            return null;
        }
        Entry ne = new Entry(e.getKey(), e.getValue());
        ne.next = this.cloneList(e.next);
        return ne;
    }

    public LongKeyFloatMapIterator entries() {
        return new LongKeyFloatMapIterator(){
            Entry currEntry = null;
            int nextList = this.nextList(0);
            Entry nextEntry = this.nextList == -1 ? null : LongKeyFloatChainedHashMap.access$200(LongKeyFloatChainedHashMap.this)[this.nextList];

            int nextList(int index) {
                while (index < LongKeyFloatChainedHashMap.this.data.length && LongKeyFloatChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < LongKeyFloatChainedHashMap.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.nextEntry != null;
            }

            public void next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = LongKeyFloatChainedHashMap.this.data[this.nextList];
                    }
                }
            }

            public long getKey() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getKey();
            }

            public float getValue() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getValue();
            }

            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                LongKeyFloatChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }
        };
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    public boolean containsKey(long key) {
        Entry e = this.getEntry(key);
        if (e == null) {
            this.hasLastValue = false;
        } else {
            this.hasLastValue = true;
            this.lastValue = e.value;
        }
        return this.hasLastValue;
    }

    public boolean containsValue(float value) {
        int i = 0;
        while (i < this.data.length) {
            Entry e = this.data[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    public float get(long key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        return e != null ? e.value : MapDefaults.defaultFloat();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public float remove(long key) {
        float value;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e != null) {
            this.data[index] = this.removeList(this.data[index], e);
            value = e.value;
            --this.size;
        } else {
            value = MapDefaults.defaultFloat();
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    public float tget(long key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return e.value;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        LongKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeLong(i.getKey());
            s.writeFloat(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new Entry[s.readInt()];
        int i = 0;
        while (i < this.size) {
            long key = s.readLong();
            float value = s.readFloat();
            int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
            Entry e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            ++i;
        }
    }

    private class ValueCollection
    extends AbstractFloatCollection {
        private ValueCollection() {
        }

        public void clear() {
            LongKeyFloatChainedHashMap.this.clear();
        }

        public boolean contains(float v) {
            return LongKeyFloatChainedHashMap.this.containsValue(v);
        }

        public FloatIterator iterator() {
            return new FloatIterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : LongKeyFloatChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < LongKeyFloatChainedHashMap.access$200(ValueCollection.access$600(this.this$1)).length && LongKeyFloatChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < LongKeyFloatChainedHashMap.access$200(ValueCollection.access$600(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public float next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = LongKeyFloatChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.value;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    ValueCollection.access$600(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public int size() {
            return LongKeyFloatChainedHashMap.this.size;
        }

        static /* synthetic */ LongKeyFloatChainedHashMap access$600(ValueCollection x0) {
            return x0.LongKeyFloatChainedHashMap.this;
        }
    }

    private class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        public void clear() {
            LongKeyFloatChainedHashMap.this.clear();
        }

        public boolean contains(long v) {
            return LongKeyFloatChainedHashMap.this.getEntry(v) != null;
        }

        public LongIterator iterator() {
            return new LongIterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : LongKeyFloatChainedHashMap.access$200(KeySet.access$400(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < LongKeyFloatChainedHashMap.access$200(KeySet.access$400(this.this$1)).length && LongKeyFloatChainedHashMap.access$200(KeySet.access$400(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < LongKeyFloatChainedHashMap.access$200(KeySet.access$400(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public long next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = LongKeyFloatChainedHashMap.access$200(KeySet.access$400(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.key;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    KeySet.access$400(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public boolean remove(long v) {
            boolean result = LongKeyFloatChainedHashMap.this.containsKey(v);
            if (result) {
                LongKeyFloatChainedHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return LongKeyFloatChainedHashMap.this.size;
        }

        static /* synthetic */ LongKeyFloatChainedHashMap access$400(KeySet x0) {
            return x0.LongKeyFloatChainedHashMap.this;
        }
    }

    private static class Entry {
        long key;
        float value;
        Entry next;

        Entry(long key, float value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return e.getKey() == this.key && e.getValue() == this.value;
        }
    }
}

