/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractIntCollection;
import bak.pcj.IntCollection;
import bak.pcj.IntIterator;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.list.IntList;
import bak.pcj.list.IntListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList {
    protected AbstractIntList() {
    }

    public boolean add(int v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, int v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, IntCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        IntIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(int c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, int c) {
        IntListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public IntIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(int c) {
        IntListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, int c) {
        IntListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    public IntListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new IntListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractIntList.this.size();
            }

            public int next() {
                if (this.ptr == AbstractIntList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractIntList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractIntList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(int v) {
                AbstractIntList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public int previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractIntList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(int v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractIntList.this.set(this.lptr, v);
            }
        };
    }

    public int removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntList)) {
            return false;
        }
        IntListIterator i1 = this.listIterator();
        IntListIterator i2 = ((IntList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultIntHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract int set(int var1, int var2);

    public abstract int get(int var1);
}

