/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.util.Exceptions;

public class SynchronizedLongCollection
implements LongCollection {
    protected LongCollection collection;
    protected Object m;

    public SynchronizedLongCollection(LongCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = c;
        this.m = this;
    }

    public boolean add(long v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.add(v);
            return bl;
        }
    }

    public boolean addAll(LongCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.addAll(c);
            return bl;
        }
    }

    public void clear() {
        Object object = this.m;
        synchronized (object) {
            this.collection.clear();
        }
    }

    public boolean contains(long v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.contains(v);
            return bl;
        }
    }

    public boolean containsAll(LongCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.containsAll(c);
            return bl;
        }
    }

    public boolean equals(Object obj) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.equals(obj);
            return bl;
        }
    }

    public int hashCode() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.hashCode();
            return n;
        }
    }

    public boolean isEmpty() {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.isEmpty();
            return bl;
        }
    }

    public LongIterator iterator() {
        Object object = this.m;
        synchronized (object) {
            LongIterator longIterator = this.collection.iterator();
            return longIterator;
        }
    }

    public boolean remove(long v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.remove(v);
            return bl;
        }
    }

    public boolean removeAll(LongCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.removeAll(c);
            return bl;
        }
    }

    public boolean retainAll(LongCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.retainAll(c);
            return bl;
        }
    }

    public int size() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.size();
            return n;
        }
    }

    public long[] toArray() {
        Object object = this.m;
        synchronized (object) {
            long[] lArray = this.collection.toArray();
            return lArray;
        }
    }

    public long[] toArray(long[] a) {
        Object object = this.m;
        synchronized (object) {
            long[] lArray = this.collection.toArray(a);
            return lArray;
        }
    }

    public void trimToSize() {
        Object object = this.m;
        synchronized (object) {
            this.collection.trimToSize();
        }
    }
}

