/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.DoubleCollection;
import bak.pcj.DoubleIterator;
import bak.pcj.util.Exceptions;

public class SynchronizedDoubleCollection
implements DoubleCollection {
    protected DoubleCollection collection;
    protected Object m;

    public SynchronizedDoubleCollection(DoubleCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = c;
        this.m = this;
    }

    public boolean add(double v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.add(v);
            return bl;
        }
    }

    public boolean addAll(DoubleCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.addAll(c);
            return bl;
        }
    }

    public void clear() {
        Object object = this.m;
        synchronized (object) {
            this.collection.clear();
        }
    }

    public boolean contains(double v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.contains(v);
            return bl;
        }
    }

    public boolean containsAll(DoubleCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.containsAll(c);
            return bl;
        }
    }

    public boolean equals(Object obj) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.equals(obj);
            return bl;
        }
    }

    public int hashCode() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.hashCode();
            return n;
        }
    }

    public boolean isEmpty() {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.isEmpty();
            return bl;
        }
    }

    public DoubleIterator iterator() {
        Object object = this.m;
        synchronized (object) {
            DoubleIterator doubleIterator = this.collection.iterator();
            return doubleIterator;
        }
    }

    public boolean remove(double v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.remove(v);
            return bl;
        }
    }

    public boolean removeAll(DoubleCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.removeAll(c);
            return bl;
        }
    }

    public boolean retainAll(DoubleCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.retainAll(c);
            return bl;
        }
    }

    public int size() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.size();
            return n;
        }
    }

    public double[] toArray() {
        Object object = this.m;
        synchronized (object) {
            double[] dArray = this.collection.toArray();
            return dArray;
        }
    }

    public double[] toArray(double[] a) {
        Object object = this.m;
        synchronized (object) {
            double[] dArray = this.collection.toArray(a);
            return dArray;
        }
    }

    public void trimToSize() {
        Object object = this.m;
        synchronized (object) {
            this.collection.trimToSize();
        }
    }
}

