/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.IntCollection;
import bak.pcj.IntIterator;
import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;

public abstract class AbstractIntCollection
implements IntCollection {
    protected AbstractIntCollection() {
    }

    public boolean add(int v) {
        Exceptions.unsupported("add");
        return false;
    }

    public boolean addAll(IntCollection c) {
        IntIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    public void clear() {
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean contains(int v) {
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(IntCollection c) {
        IntIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(int v) {
        IntIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    public boolean removeAll(IntCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        IntIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(IntCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        IntIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public int size() {
        IntIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public int[] toArray() {
        return this.toArray(null);
    }

    public int[] toArray(int[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new int[size];
        }
        IntIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }

    public abstract IntIterator iterator();
}

