/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.handlers;

import org.jclouds.dynect.v3.DynECTExceptions;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;

public class DynECTErrorHandler
implements HttpErrorHandler {
    private static final String JOB_STILL_RUNNING = "This session already has a job running";
    private static final String OPERATION_BLOCKED = "Operation blocked by current task";
    private static final String TARGET_EXISTS = "Name already exists";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        Object exception = new HttpResponseException(command, response);
        try {
            String message;
            byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            String string = message = data != null ? new String(data) : null;
            if (message != null) {
                exception = new HttpResponseException(command, response, message);
                if (message.indexOf(JOB_STILL_RUNNING) != -1) {
                    exception = new DynECTExceptions.JobStillRunningException(JOB_STILL_RUNNING, (Throwable)exception);
                } else if (message.indexOf(OPERATION_BLOCKED) != -1) {
                    exception = new DynECTExceptions.JobStillRunningException(OPERATION_BLOCKED, (Throwable)exception);
                } else if (message.indexOf(TARGET_EXISTS) != -1) {
                    exception = new DynECTExceptions.TargetExistsException(TARGET_EXISTS, (Throwable)exception);
                }
            } else {
                exception = new HttpResponseException(command, response);
            }
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)exception);
        }
    }
}

