/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public final class Zone {
    private final String fqdn;
    @Named(value="zone_type")
    private final Type type;
    private final int serial;
    @Named(value="serial_style")
    private final SerialStyle serialStyle;

    @ConstructorProperties(value={"zone", "zone_type", "serial", "serial_style"})
    private Zone(String fqdn, Type type, int serial, SerialStyle serialStyle) {
        this.fqdn = (String)Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (String)"type for %s", (Object[])new Object[]{fqdn}));
        this.serial = serial;
        this.serialStyle = (SerialStyle)((Object)Preconditions.checkNotNull((Object)((Object)serialStyle), (String)"serialStyle for %s", (Object[])new Object[]{fqdn}));
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public Type getType() {
        return this.type;
    }

    public int getSerial() {
        return this.serial;
    }

    public SerialStyle getSerialStyle() {
        return this.serialStyle;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fqdn, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Zone that = (Zone)Zone.class.cast(obj);
        return Objects.equal((Object)this.fqdn, (Object)that.fqdn) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("fqdn", (Object)this.fqdn).add("type", (Object)this.type).add("serial", this.serial).add("serialStyle", (Object)this.serialStyle).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Zone.builder().from(this);
    }

    public static final class Builder {
        private String fqdn;
        private Type type;
        private int serial;
        private SerialStyle serialStyle;

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder serial(int serial) {
            this.serial = serial;
            return this;
        }

        public Builder serialStyle(SerialStyle serialStyle) {
            this.serialStyle = serialStyle;
            return this;
        }

        public Zone build() {
            return new Zone(this.fqdn, this.type, this.serial, this.serialStyle);
        }

        public Builder from(Zone in) {
            return this.fqdn(in.fqdn).type(in.type).serial(in.serial).serialStyle(in.serialStyle);
        }
    }

    public static enum SerialStyle {
        INCREMENT,
        EPOCH,
        DAY,
        MINUTE,
        UNRECOGNIZED;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static SerialStyle fromValue(String serialStyle) {
            try {
                return SerialStyle.valueOf(((String)Preconditions.checkNotNull((Object)serialStyle, (Object)"serialStyle")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PRIMARY,
        SECONDARY;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static Type fromValue(String type) {
            return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
        }
    }
}

