/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import com.github.lltyk.rhino17r1.Context;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dojotoolkit.shrinksafe.Compressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StopWatch;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class DojoShrinksafeCompressorProcessor
implements ResourcePostProcessor,
ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DojoShrinksafeCompressorProcessor.class);
    public static final String ALIAS = "dojoShrinksafe";

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start("pack");
        Context.enter();
        try {
            String script = IOUtils.toString((Reader)reader);
            String stripConsole = null;
            LOG.debug("compressing script: {}", (Object)StringUtils.abbreviate((String)script, (int)40));
            String out = Compressor.compressScript((String)script, (int)0, (int)0, stripConsole);
            writer.write(out);
        }
        finally {
            Context.exit();
            reader.close();
            writer.close();
            watch.stop();
            LOG.debug(watch.prettyPrint());
        }
    }
}

