/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.core.Nullable;

public class DeleteServiceAccountTokenRequest
implements Validatable {
    private final String namespace;
    private final String serviceName;
    private final String tokenName;
    @Nullable
    private final RefreshPolicy refreshPolicy;

    public DeleteServiceAccountTokenRequest(String namespace, String serviceName, String tokenName, @Nullable RefreshPolicy refreshPolicy) {
        this.namespace = Objects.requireNonNull(namespace, "namespace is required");
        this.serviceName = Objects.requireNonNull(serviceName, "service-name is required");
        this.tokenName = Objects.requireNonNull(tokenName, "token name is required");
        this.refreshPolicy = refreshPolicy;
    }

    public DeleteServiceAccountTokenRequest(String namespace, String serviceName, String tokenName) {
        this(namespace, serviceName, tokenName, null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteServiceAccountTokenRequest that = (DeleteServiceAccountTokenRequest)o;
        return this.namespace.equals(that.namespace) && this.serviceName.equals(that.serviceName) && this.tokenName.equals(that.tokenName) && this.refreshPolicy == that.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespace, this.serviceName, this.tokenName, this.refreshPolicy});
    }
}

