/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.results;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.results.Result;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OverallBucket
implements ToXContentObject {
    public static final ParseField OVERALL_SCORE = new ParseField("overall_score", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField JOBS = new ParseField("jobs", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("overall_buckets", new String[0]);
    public static final String RESULT_TYPE_VALUE = "overall_bucket";
    public static final ConstructingObjectParser<OverallBucket, Void> PARSER = new ConstructingObjectParser("overall_bucket", true, a -> new OverallBucket((Date)a[0], (Long)a[1], (Double)a[2], (Boolean)a[3]));
    private final Date timestamp;
    private final long bucketSpan;
    private final double overallScore;
    private final boolean isInterim;
    private List<JobInfo> jobs = Collections.emptyList();

    OverallBucket(Date timestamp, long bucketSpan, double overallScore, boolean isInterim) {
        this.timestamp = Objects.requireNonNull(timestamp);
        this.bucketSpan = bucketSpan;
        this.overallScore = overallScore;
        this.isInterim = isInterim;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(OVERALL_SCORE.getPreferredName(), this.overallScore);
        builder.field(JOBS.getPreferredName(), this.jobs);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.endObject();
        return builder;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getOverallScore() {
        return this.overallScore;
    }

    public List<JobInfo> getJobs() {
        return this.jobs;
    }

    void setJobs(List<JobInfo> jobs) {
        this.jobs = Collections.unmodifiableList(jobs);
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.bucketSpan, this.overallScore, this.jobs, this.isInterim);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OverallBucket that = (OverallBucket)other;
        return Objects.equals(this.timestamp, that.timestamp) && this.bucketSpan == that.bucketSpan && this.overallScore == that.overallScore && Objects.equals(this.jobs, that.jobs) && this.isInterim == that.isInterim;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), OVERALL_SCORE);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), Result.IS_INTERIM);
        PARSER.declareObjectArray(OverallBucket::setJobs, JobInfo.PARSER, JOBS);
    }

    public static class JobInfo
    implements ToXContentObject,
    Comparable<JobInfo> {
        private static final ParseField MAX_ANOMALY_SCORE = new ParseField("max_anomaly_score", new String[0]);
        public static final ConstructingObjectParser<JobInfo, Void> PARSER = new ConstructingObjectParser("job_info", true, a -> new JobInfo((String)a[0], (Double)a[1]));
        private final String jobId;
        private final double maxAnomalyScore;

        JobInfo(String jobId, double maxAnomalyScore) {
            this.jobId = Objects.requireNonNull(jobId);
            this.maxAnomalyScore = maxAnomalyScore;
        }

        public String getJobId() {
            return this.jobId;
        }

        public double getMaxAnomalyScore() {
            return this.maxAnomalyScore;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(MAX_ANOMALY_SCORE.getPreferredName(), this.maxAnomalyScore);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.maxAnomalyScore);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            JobInfo that = (JobInfo)other;
            return Objects.equals(this.jobId, that.jobId) && this.maxAnomalyScore == that.maxAnomalyScore;
        }

        @Override
        public int compareTo(JobInfo other) {
            int result = this.jobId.compareTo(other.jobId);
            if (result == 0) {
                result = Double.compare(this.maxAnomalyScore, other.maxAnomalyScore);
            }
            return result;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), MAX_ANOMALY_SCORE);
        }
    }
}

