/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.graph.Hop;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;

public class GraphExploreRequest
implements IndicesRequest.Replaceable,
ToXContentObject,
Validatable {
    public static final String NO_HOPS_ERROR_MESSAGE = "Graph explore request must have at least one hop";
    public static final String NO_VERTICES_ERROR_MESSAGE = "Graph explore hop must have at least one VertexRequest";
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)false);
    private String[] types = Strings.EMPTY_ARRAY;
    private String routing;
    private TimeValue timeout;
    private int sampleSize = 100;
    private String sampleDiversityField;
    private int maxDocsPerDiversityValue;
    private boolean useSignificance = true;
    private boolean returnDetailedInfo;
    private List<Hop> hops = new ArrayList<Hop>();

    public GraphExploreRequest() {
    }

    public GraphExploreRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.hops.size() == 0) {
            validationException.addValidationError(NO_HOPS_ERROR_MESSAGE);
        }
        for (Hop hop : this.hops) {
            hop.validate(validationException);
        }
        return validationException.validationErrors().isEmpty() ? Optional.empty() : Optional.of(validationException);
    }

    public String[] indices() {
        return this.indices;
    }

    public GraphExploreRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public GraphExploreRequest indicesOptions(IndicesOptions indicesOptions) {
        if (indicesOptions == null) {
            throw new IllegalArgumentException("IndicesOptions must not be null");
        }
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Deprecated
    public String[] types() {
        return this.types;
    }

    @Deprecated
    public GraphExploreRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public GraphExploreRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GraphExploreRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString((Object[])routings);
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public GraphExploreRequest timeout(TimeValue timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("timeout must not be null");
        }
        this.timeout = timeout;
        return this;
    }

    public GraphExploreRequest timeout(String timeout) {
        this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
        return this;
    }

    public String toString() {
        return "graph explore [" + Arrays.toString(this.indices) + "][" + Arrays.toString(this.types) + "]";
    }

    public void sampleSize(int maxNumberOfDocsPerHop) {
        this.sampleSize = maxNumberOfDocsPerHop;
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public void sampleDiversityField(String name) {
        this.sampleDiversityField = name;
    }

    public String sampleDiversityField() {
        return this.sampleDiversityField;
    }

    public void maxDocsPerDiversityValue(int maxDocs) {
        this.maxDocsPerDiversityValue = maxDocs;
    }

    public int maxDocsPerDiversityValue() {
        return this.maxDocsPerDiversityValue;
    }

    public void useSignificance(boolean value) {
        this.useSignificance = value;
    }

    public boolean useSignificance() {
        return this.useSignificance;
    }

    public void returnDetailedInfo(boolean value) {
        this.returnDetailedInfo = value;
    }

    public boolean returnDetailedInfo() {
        return this.returnDetailedInfo;
    }

    public Hop createNextHop(QueryBuilder guidingQuery) {
        Hop parent = null;
        if (this.hops.size() > 0) {
            parent = this.hops.get(this.hops.size() - 1);
        }
        Hop newHop = new Hop(parent);
        newHop.guidingQuery = guidingQuery;
        this.hops.add(newHop);
        return newHop;
    }

    public int getHopNumbers() {
        return this.hops.size();
    }

    public Hop getHop(int hopNumber) {
        return this.hops.get(hopNumber);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("controls");
        if (this.sampleSize != 100) {
            builder.field("sample_size", this.sampleSize);
        }
        if (this.sampleDiversityField != null) {
            builder.startObject("sample_diversity");
            builder.field("field", this.sampleDiversityField);
            builder.field("max_docs_per_value", this.maxDocsPerDiversityValue);
            builder.endObject();
        }
        builder.field("use_significance", this.useSignificance);
        if (this.returnDetailedInfo) {
            builder.field("return_detailed_stats", this.returnDetailedInfo);
        }
        builder.endObject();
        for (Hop hop : this.hops) {
            if (hop.parentHop != null) {
                builder.startObject("connections");
            }
            hop.toXContent(builder, params);
        }
        for (Hop hop : this.hops) {
            if (hop.parentHop == null) continue;
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class TermBoost {
        String term;
        float boost;

        public TermBoost(String term, float boost) {
            this.term = term;
            if (boost <= 0.0f) {
                throw new IllegalArgumentException("Boosts must be a positive non-zero number");
            }
            this.boost = boost;
        }

        TermBoost() {
        }

        public String getTerm() {
            return this.term;
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

