/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.history;

import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.events.history.AbstractHistoryEvent;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class GenericMetadataEventListener {
    @Autowired
    private SettingManager settingManager;
    @Autowired
    private MetadataStatusRepository metadataStatusRepository;
    @Autowired
    private StatusValueRepository statusValueRepository;
    @Autowired
    IMetadataUtils metadataUtils;

    public abstract String getChangeMessage();

    public abstract String getEventType();

    public final void handleEvent(AbstractHistoryEvent event) {
        this.storeContentHistoryEvent(event);
    }

    public final void storeContentHistoryEvent(AbstractHistoryEvent event) {
        if (this.settingManager.getValueAsBool("system/metadata/history/enabled")) {
            Integer metadataid = Math.toIntExact(event.getMdId());
            StatusValue status = this.statusValueRepository.findOneById(Integer.parseInt(this.getEventType()));
            if (status != null) {
                MetadataStatus metadataStatus = new MetadataStatus();
                metadataStatus.setMetadataId(metadataid.intValue());
                metadataStatus.setUserId(event.getUserId().intValue());
                metadataStatus.setChangeDate(new ISODate(System.currentTimeMillis()));
                metadataStatus.setStatusValue(status);
                metadataStatus.setOwner(event.getUserId());
                if (event.getUuid() != null && event.getUuid().length() > 0) {
                    metadataStatus.setUuid(event.getUuid());
                } else {
                    try {
                        metadataStatus.setUuid(this.metadataUtils.getMetadataUuid(Integer.toString(metadataid)));
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.datamanager", (Object)String.format("Error locating uuid for metadata id: %d", (int)metadataid), (Throwable)e);
                    }
                    if (metadataStatus.getUuid() == null || metadataStatus.getUuid().length() == 0) {
                        Log.error((String)"geonetwork.datamanager", (Object)String.format("Could not located uuid for metadata id: %d", (int)metadataid));
                    }
                }
                if (event.getTitles() != null && event.getTitles().size() > 0) {
                    metadataStatus.setTitles(event.getTitles());
                } else {
                    try {
                        metadataStatus.setTitles(this.metadataUtils.extractTitles(Integer.toString(metadataid)));
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.datamanager", (Object)String.format("Error locating titles for metadata id: %d", (int)metadataid), (Throwable)e);
                    }
                }
                metadataStatus.setChangeMessage(this.getChangeMessage());
                metadataStatus.setCurrentState(event.getCurrentState());
                metadataStatus.setPreviousState(event.getPreviousState());
                metadataStatus.setRelatedMetadataStatus(event.getRelatedMetadataStatus());
                this.metadataStatusRepository.save((Object)metadataStatus);
            } else {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Status with id '%s' not found in database. Check database migration SQL file to add default status if you want to log record history.", this.getEventType()));
            }
        }
    }
}

