/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRuleWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HealthMonitor;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SSLTermination;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SessionPersistence;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SourceAddresses;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseLoadBalancer;

public class LoadBalancer
extends BaseLoadBalancer<Node, LoadBalancer> {
    private final String region;
    private final int id;
    private final Status status;
    private final Set<VirtualIPWithId> virtualIPs;
    private final String clusterName;
    private final Date created;
    private final Date updated;
    private final boolean contentCaching;
    private final int nodeCount;
    private final SSLTermination sslTermination;
    private final SourceAddresses sourceAddresses;
    private final Set<AccessRuleWithId> accessRules;
    private final Metadata metadata;
    private final URI uri;

    public LoadBalancer(String region, int id, String name, String protocol, @Nullable Integer port, Set<Node> nodes, @Nullable Integer timeout, @Nullable Boolean halfClosed, @Nullable BaseLoadBalancer.Algorithm algorithm, Status status, Set<VirtualIPWithId> virtualIPs, @Nullable Map<String, SessionPersistence> sessionPersistenceType, String clusterName, Date created, Date updated, @Nullable Map<String, Boolean> connectionLogging, @Nullable ConnectionThrottle connectionThrottle, boolean contentCaching, int nodeCount, @Nullable HealthMonitor healthMonitor, @Nullable SSLTermination sslTermination, SourceAddresses sourceAddresses, Set<AccessRuleWithId> accessRules, Metadata metadata, URI uri) {
        super(name, protocol, port, nodes, algorithm, timeout, halfClosed, sessionPersistenceType, connectionLogging, connectionThrottle, healthMonitor);
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkArgument((id != -1 ? 1 : 0) != 0, (Object)"id must be specified");
        this.id = id;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.virtualIPs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(virtualIPs, (Object)"virtualIPs")));
        this.clusterName = clusterName;
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created");
        this.updated = (Date)Preconditions.checkNotNull((Object)updated, (Object)"updated");
        this.contentCaching = contentCaching;
        this.nodeCount = nodeCount;
        this.sslTermination = sslTermination;
        this.sourceAddresses = sourceAddresses;
        this.accessRules = accessRules == null ? ImmutableSet.of() : ImmutableSet.copyOf(accessRules);
        this.metadata = metadata == null ? new Metadata() : metadata;
        this.uri = uri;
    }

    public String getRegion() {
        return this.region;
    }

    public int getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<VirtualIPWithId> getVirtualIPs() {
        return this.virtualIPs;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public boolean isContentCaching() {
        return this.contentCaching;
    }

    public int getNodeCount() {
        return !this.nodes.isEmpty() ? this.nodes.size() : this.nodeCount;
    }

    @Nullable
    public SSLTermination getSSLTermination() {
        return this.sslTermination;
    }

    public SourceAddresses getSourceAddresses() {
        return this.sourceAddresses;
    }

    public Set<AccessRuleWithId> getAccessRules() {
        return this.accessRules;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", this.id).add("region", (Object)this.region).add("status", (Object)this.status).add("name", (Object)this.name).add("protocol", (Object)this.protocol).add("port", (Object)this.port).add("nodeCount", this.getNodeCount()).add("nodes", (Object)this.nodes).add("timeout", (Object)this.timeout).add("algorithm", (Object)this.algorithm).add("halfClosed", (Object)this.halfClosed).add("clusterName", (Object)this.clusterName).add("created", (Object)this.created).add("updated", (Object)this.updated).add("contentCaching", this.contentCaching).add("sessionPersistenceType", (Object)this.getSessionPersistenceType()).add("sslTermination", (Object)this.sslTermination).add("connectionLogging", this.isConnectionLogging()).add("connectionThrottle", (Object)this.connectionThrottle).add("healthMonitor", (Object)this.healthMonitor).add("accessRules", this.accessRules).add("metadata", (Object)this.getMetadata()).add("uri", (Object)this.uri).add("sourceAddresses", (Object)this.sourceAddresses).add("virtualIPs", this.virtualIPs);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.region});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer that = (LoadBalancer)LoadBalancer.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.region, (Object)that.region);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder
    extends BaseLoadBalancer.Builder<Node, LoadBalancer> {
        private String region;
        private int id = -1;
        private Status status;
        private Set<VirtualIPWithId> virtualIPs = ImmutableSet.of();
        private String clusterName;
        private Date created;
        private Date updated;
        private boolean contentCaching;
        private int nodeCount = 0;
        private SSLTermination sslTermination;
        private SourceAddresses sourceAddresses;
        private Set<AccessRuleWithId> accessRules;
        private Metadata metadata;
        private URI uri;

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder virtualIPs(Iterable<VirtualIPWithId> virtualIPs) {
            this.virtualIPs = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(virtualIPs, (Object)"virtualIPs")));
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder contentCaching(boolean contentCaching) {
            this.contentCaching = contentCaching;
            return this;
        }

        public Builder nodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public Builder sslTermination(SSLTermination sslTermination) {
            this.sslTermination = (SSLTermination)Preconditions.checkNotNull((Object)sslTermination, (Object)"sslTermination");
            return this;
        }

        public Builder sourceAddresses(SourceAddresses sourceAddresses) {
            this.sourceAddresses = (SourceAddresses)Preconditions.checkNotNull((Object)sourceAddresses, (Object)"sourceAddresses");
            return this;
        }

        public Builder accessRules(Iterable<AccessRuleWithId> accessRules) {
            this.accessRules = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(accessRules, (Object)"accessRules")));
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = (Metadata)((Object)Preconditions.checkNotNull((Object)((Object)metadata), (Object)"metadata"));
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.region, this.id, this.name, this.protocol, this.port, this.nodes, this.timeout, this.halfClosed, this.algorithm, this.status, this.virtualIPs, this.sessionPersistence, this.clusterName, this.created, this.updated, this.connectionLogging, this.connectionThrottle, this.contentCaching, this.nodeCount, this.healthMonitor, this.sslTermination, this.sourceAddresses, this.accessRules, this.metadata, this.uri);
        }

        public Builder nodes(Iterable<Node> nodes) {
            this.nodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nodes, (Object)"nodes")));
            return this;
        }

        public Builder node(Node node) {
            this.nodes.add(Preconditions.checkNotNull((Object)node, (Object)"nodes"));
            return this;
        }

        public Builder algorithm(BaseLoadBalancer.Algorithm algorithm) {
            return (Builder)Builder.class.cast(super.algorithm(algorithm));
        }

        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        public Builder port(Integer port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder protocol(String protocol) {
            return (Builder)Builder.class.cast(super.protocol(protocol));
        }

        public Builder timeout(@Nullable Integer timeout) {
            return (Builder)Builder.class.cast(super.timeout(timeout));
        }

        public Builder halfClosed(@Nullable Boolean halfClosed) {
            return (Builder)Builder.class.cast(super.halfClosed(halfClosed));
        }

        public Builder sessionPersistenceType(@Nullable SessionPersistence sessionPersistenceType) {
            return (Builder)Builder.class.cast(super.sessionPersistenceType(sessionPersistenceType));
        }

        public Builder connectionLogging(@Nullable Boolean connectionLogging) {
            return (Builder)Builder.class.cast(super.connectionLogging(connectionLogging));
        }

        public Builder connectionThrottle(@Nullable ConnectionThrottle connectionThrottle) {
            return (Builder)Builder.class.cast(super.connectionThrottle(connectionThrottle));
        }

        public Builder healthMonitor(@Nullable HealthMonitor healthMonitor) {
            return (Builder)Builder.class.cast(super.healthMonitor(healthMonitor));
        }

        public Builder from(LoadBalancer in) {
            return ((Builder)Builder.class.cast(super.from(in))).region(in.getRegion()).id(in.getId()).status(in.getStatus()).virtualIPs(in.getVirtualIPs()).clusterName(in.getClusterName()).created(in.getCreated()).updated(in.getUpdated()).contentCaching(in.isContentCaching()).nodeCount(in.getNodeCount()).sslTermination(in.getSSLTermination()).sourceAddresses(in.getSourceAddresses()).accessRules(in.getAccessRules()).metadata(in.getMetadata()).uri(in.getUri());
        }
    }

    public static enum Status {
        BUILD,
        ACTIVE,
        PENDING_UPDATE,
        SUSPENDED,
        PENDING_DELETE,
        DELETED,
        ERROR,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf((String)Preconditions.checkNotNull((Object)status, (Object)"status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

