/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geojson.GeoJSONUtil;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.geom.GeometryCollectionHandler;
import org.geotools.geojson.geom.GeometryHandler;
import org.geotools.geojson.geom.LineHandler;
import org.geotools.geojson.geom.MultiLineHandler;
import org.geotools.geojson.geom.MultiPointHandler;
import org.geotools.geojson.geom.MultiPolygonHandler;
import org.geotools.geojson.geom.PointHandler;
import org.geotools.geojson.geom.PolygonHandler;
import org.json.simple.JSONAware;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.BoundingBox;

public class GeometryJSON {
    GeometryFactory factory = new GeometryFactory();
    boolean trace = false;
    int decimals;
    double scale;

    public GeometryJSON() {
        this(4);
    }

    public GeometryJSON(int decimals) {
        this.decimals = decimals;
        this.scale = Math.pow(10.0, decimals);
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void write(Geometry geometry, Object output) throws IOException {
        if (geometry == null || geometry.isEmpty()) {
            GeoJSONUtil.encode("null", output);
        } else {
            GeoJSONUtil.encode(this.create(geometry), output);
        }
    }

    public void write(Geometry geometry, OutputStream output) throws IOException {
        GeoJSONUtil.encode(this.create(geometry), (Object)output);
    }

    public String toString(Geometry geometry) {
        StringWriter w = new StringWriter();
        try {
            this.write(geometry, w);
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, Object> create(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.createPoint((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.createLine((LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.createPolygon((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.createMultiPoint((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.createMultiLine((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.createMultiPolygon((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.createGeometryCollection((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unable to encode object " + geometry);
    }

    public Geometry read(Object input) throws IOException {
        return this.parse(new GeometryHandler(this.factory), input);
    }

    public Geometry read(InputStream input) throws IOException {
        return this.read((Object)input);
    }

    public void writePoint(Point point, Object output) throws IOException {
        this.encode(this.createPoint(point), output);
    }

    public void writePoint(Point point, OutputStream output) throws IOException {
        this.writePoint(point, (Object)output);
    }

    Map<String, Object> createPoint(Point point) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "Point");
        obj.put("coordinates", new CoordinateSequenceEncoder(point.getCoordinateSequence(), this.scale));
        return obj;
    }

    public Point readPoint(Object input) throws IOException {
        return this.parse(new PointHandler(this.factory), input);
    }

    public Point readPoint(InputStream input) throws IOException {
        return this.readPoint((Object)input);
    }

    public void writeLine(LineString line, Object output) throws IOException {
        this.encode(this.createLine(line), output);
    }

    public void writeLine(LineString line, OutputStream output) throws IOException {
        this.writeLine(line, (Object)output);
    }

    Map<String, Object> createLine(LineString line) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "LineString");
        obj.put("coordinates", new CoordinateSequenceEncoder(line.getCoordinateSequence(), this.scale));
        return obj;
    }

    public LineString readLine(Object input) throws IOException {
        return this.parse(new LineHandler(this.factory), input);
    }

    public LineString readLine(InputStream input) throws IOException {
        return this.readLine((Object)input);
    }

    public void writePolygon(Polygon poly, Object output) throws IOException {
        this.encode(this.createPolygon(poly), output);
    }

    public void writePolygon(Polygon poly, OutputStream output) throws IOException {
        this.writePolygon(poly, (Object)output);
    }

    Map<String, Object> createPolygon(Polygon poly) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "Polygon");
        obj.put("coordinates", this.toList(poly));
        return obj;
    }

    public Polygon readPolygon(Object input) throws IOException {
        return this.parse(new PolygonHandler(this.factory), input);
    }

    public Polygon readPolygon(InputStream input) throws IOException {
        return this.readPolygon((Object)input);
    }

    public void writeMultiPoint(MultiPoint mpoint, Object output) throws IOException {
        this.encode(this.createMultiPoint(mpoint), output);
    }

    public void writeMultiPoint(MultiPoint mpoint, OutputStream output) throws IOException {
        this.writeMultiPoint(mpoint, (Object)output);
    }

    Map<String, Object> createMultiPoint(MultiPoint mpoint) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "MultiPoint");
        obj.put("coordinates", this.toList((GeometryCollection)mpoint));
        return obj;
    }

    public MultiPoint readMultiPoint(Object input) throws IOException {
        return this.parse(new MultiPointHandler(this.factory), input);
    }

    public MultiPoint readMultiPoint(InputStream input) throws IOException {
        return this.readMultiPoint((Object)input);
    }

    public void writeMultiLine(MultiLineString mline, Object output) throws IOException {
        this.encode(this.createMultiLine(mline), output);
    }

    public void writeMultiLine(MultiLineString mline, OutputStream output) throws IOException {
        this.writeMultiLine(mline, (Object)output);
    }

    Map<String, Object> createMultiLine(MultiLineString mline) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "MultiLineString");
        obj.put("coordinates", this.toList((GeometryCollection)mline));
        return obj;
    }

    public MultiLineString readMultiLine(Object input) throws IOException {
        return this.parse(new MultiLineHandler(this.factory), input);
    }

    public MultiLineString readMultiLine(InputStream input) throws IOException {
        return this.readMultiLine((Object)input);
    }

    public void writeMultiPolygon(MultiPolygon mpoly, Object output) throws IOException {
        this.encode(this.createMultiPolygon(mpoly), output);
    }

    public void writeMultiPolygon(MultiPolygon mpoly, OutputStream output) throws IOException {
        this.writeMultiPolygon(mpoly, (Object)output);
    }

    Map<String, Object> createMultiPolygon(MultiPolygon mpoly) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "MultiPolygon");
        obj.put("coordinates", this.toList((GeometryCollection)mpoly));
        return obj;
    }

    public MultiPolygon readMultiPolygon(Object input) throws IOException {
        return this.parse(new MultiPolygonHandler(this.factory), input);
    }

    public MultiPolygon readMultiPolygon(InputStream input) throws IOException {
        return this.readMultiPolygon((Object)input);
    }

    public void writeGeometryCollection(GeometryCollection gcol, Object output) throws IOException {
        this.encode(this.createGeometryCollection(gcol), output);
    }

    public void writeGeometryCollection(GeometryCollection gcol, OutputStream output) throws IOException {
        this.writeGeometryCollection(gcol, (Object)output);
    }

    Map<String, Object> createGeometryCollection(GeometryCollection gcol) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> geoms = new ArrayList<Map<String, Object>>(gcol.getNumGeometries());
        for (int i = 0; i < gcol.getNumGeometries(); ++i) {
            geoms.add(this.create(gcol.getGeometryN(i)));
        }
        obj.put("type", "GeometryCollection");
        obj.put("geometries", geoms);
        return obj;
    }

    public GeometryCollection readGeometryCollection(Object input) throws IOException {
        return this.parse(new GeometryCollectionHandler(this.factory), input);
    }

    public GeometryCollection readGeometryCollection(InputStream input) throws IOException {
        return this.readGeometryCollection((Object)input);
    }

    public String toString(BoundingBox bbox) {
        return new StringBuffer().append("[").append(bbox.getMinX()).append(",").append(bbox.getMinY()).append(",").append(bbox.getMaxX()).append(",").append(bbox.getMaxY()).append("]").toString();
    }

    public String toString(Envelope e) {
        return new StringBuffer().append("[").append(e.getMinX()).append(",").append(e.getMinY()).append(",").append(e.getMaxX()).append(",").append(e.getMaxY()).append("]").toString();
    }

    <G extends Geometry> G parse(IContentHandler<G> handler, Object input) throws IOException {
        return (G)((Geometry)GeoJSONUtil.parse(handler, input, this.trace));
    }

    void encode(Map<String, Object> obj, Object output) throws IOException {
        GeoJSONUtil.encode(obj, output);
    }

    List toList(Polygon poly) {
        ArrayList<CoordinateSequenceEncoder> list = new ArrayList<CoordinateSequenceEncoder>();
        list.add(new CoordinateSequenceEncoder(poly.getExteriorRing().getCoordinateSequence(), this.scale));
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            list.add(new CoordinateSequenceEncoder(poly.getInteriorRingN(i).getCoordinateSequence(), this.scale));
        }
        return list;
    }

    List toList(GeometryCollection mgeom) {
        ArrayList<Object> list = new ArrayList<Object>(mgeom.getNumGeometries());
        for (int i = 0; i < mgeom.getNumGeometries(); ++i) {
            Geometry g = mgeom.getGeometryN(i);
            if (g instanceof Polygon) {
                list.add(this.toList((Polygon)g));
                continue;
            }
            if (g instanceof LineString) {
                list.add(new CoordinateSequenceEncoder(((LineString)g).getCoordinateSequence(), this.scale));
                continue;
            }
            if (!(g instanceof Point)) continue;
            list.add(new CoordinateSequenceEncoder(((Point)g).getCoordinateSequence(), this.scale));
        }
        return list;
    }

    static class CoordinateSequenceEncoder
    implements JSONAware {
        private static final double DECIMAL_MIN = Math.pow(10.0, -3.0);
        private static final double DECIMAL_MAX = Math.pow(10.0, 7.0);
        CoordinateSequence seq;
        double scale;

        CoordinateSequenceEncoder(CoordinateSequence seq, double scale) {
            this.seq = seq;
            this.scale = scale;
        }

        public String toJSONString() {
            int size = this.seq.size();
            StringBuilder sb = new StringBuilder();
            if (size > 1) {
                sb.append("[");
            }
            for (int i = 0; i < this.seq.size(); ++i) {
                Coordinate coord = this.seq.getCoordinate(i);
                sb.append("[");
                this.formatDecimal(coord.x, sb);
                sb.append(",");
                this.formatDecimal(coord.y, sb);
                if (!Double.isNaN(coord.getZ())) {
                    sb.append(",");
                    this.formatDecimal(coord.getZ(), sb);
                }
                sb.append("],");
            }
            sb.setLength(sb.length() - 1);
            if (size > 1) {
                sb.append("]");
            }
            return sb.toString();
        }

        public void writeJSONString(Writer out) throws IOException {
            int size = this.seq.size();
            if (size > 1) {
                out.write("[");
            }
            for (int i = 0; i < this.seq.size(); ++i) {
                Coordinate coord = this.seq.getCoordinate(i);
                out.write("[");
                out.write(String.valueOf(coord.x));
                out.write(",");
                out.write(String.valueOf(coord.y));
                if (!Double.isNaN(coord.getZ())) {
                    out.write(",");
                    out.write(String.valueOf(coord.getZ()));
                }
                out.write("]");
                if (i >= this.seq.size() - 1) continue;
                out.write(",");
            }
            if (size > 1) {
                out.write("]");
            }
        }

        private void formatDecimal(double x, StringBuilder sb) {
            if (Math.abs(x) >= DECIMAL_MIN && x < DECIMAL_MAX) {
                long lx = (long)(x = Math.floor(x * this.scale + 0.5) / this.scale);
                if ((double)lx == x) {
                    sb.append(lx);
                } else {
                    sb.append(x);
                }
            } else {
                sb.append(x);
            }
        }
    }
}

