/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpGrid;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.WarpAdapter;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class WarpBuilder {
    static final Logger LOGGER = Logging.getLogger(WarpBuilder.class);
    static final boolean DUMP_GRIDS = Boolean.getBoolean("org.geotools.dump.warp.grid");
    static final double EPS = 1.0E-6;
    final double maxDistanceSquared;
    final double[] ordinates = new double[10];
    int maxPositions = -1;

    public WarpBuilder(double tolerance) {
        this.maxDistanceSquared = tolerance >= 0.0 ? tolerance * tolerance : 0.0;
    }

    public void setMaxPositions(int maxPositions) {
        this.maxPositions = maxPositions;
    }

    public boolean isValidDomain(Rectangle2D.Double domain) {
        return this.isValidDomain(domain.getMinX(), domain.getMaxX(), domain.getMinY(), domain.getMaxY());
    }

    private boolean isValidDomain(double minx, double maxx, double miny, double maxy) {
        int width = (int)(maxx - minx);
        int height = (int)(maxy - miny);
        return width > 0 && height > 0;
    }

    public int[] getRowColsSplit(MathTransform2D mt, Rectangle2D.Double domain) {
        int[] rowCols;
        double maxy;
        double miny;
        double maxx;
        if (mt instanceof AffineTransform2D) {
            return new int[]{1, 1};
        }
        if (this.maxDistanceSquared == 0.0) {
            return null;
        }
        double minx = domain.getMinX();
        if (!this.isValidDomain(minx, maxx = domain.getMaxX(), miny = domain.getMinY(), maxy = domain.getMaxY())) {
            throw new IllegalArgumentException("The domain is empty!");
        }
        try {
            rowCols = this.computeOptimalDepths(mt, minx, maxx, miny, maxy, 0, 0, (minx1, maxx1, miny1, maxy1, rowDepth, colDepth) -> {
                if (rowDepth + colDepth > 20) {
                    throw new ExcessiveDepthException("Warp grid getting too large to fit in memory, bailing out");
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return new int[]{(int)Math.pow(2.0, rowCols[0]), (int)Math.pow(2.0, rowCols[1])};
    }

    public Warp buildWarp(MathTransform2D mt, Rectangle domain) throws TransformException {
        int[] rowCols;
        if (mt instanceof AffineTransform2D) {
            return new WarpAffine((AffineTransform)((AffineTransform2D)mt));
        }
        if (this.maxDistanceSquared == 0.0) {
            return new WarpAdapter(null, mt);
        }
        double minx = domain.getMinX();
        double maxx = domain.getMaxX();
        double miny = domain.getMinY();
        double maxy = domain.getMaxY();
        int width = (int)(maxx - minx);
        int heigth = (int)(maxy - miny);
        if (Math.abs(width) == 0 || heigth == 0) {
            throw new IllegalArgumentException("The domain is empty!");
        }
        try {
            rowCols = this.computeOptimalDepths(mt, minx, maxx, miny, maxy, 0, 0, new DomainValidator(){

                @Override
                public void validateDomain(double minx, double maxx, double miny, double maxy, int rowDepth, int colDepth) {
                    if (maxx - minx < 4.0 || maxy - miny < 4.0) {
                        throw new ExcessiveDepthException("Warp grid getting as dense as the original data");
                    }
                    if (rowDepth + colDepth > 20) {
                        throw new ExcessiveDepthException("Warp grid getting too large to fit in memory, bailing out");
                    }
                }
            });
        }
        catch (Exception e) {
            return new WarpAdapter(null, mt);
        }
        if (rowCols[0] == 0 && rowCols[1] == 0) {
            this.ordinates[0] = minx;
            this.ordinates[1] = miny;
            this.ordinates[2] = minx;
            this.ordinates[3] = maxy;
            this.ordinates[4] = maxx;
            this.ordinates[5] = miny;
            mt.transform(this.ordinates, 0, this.ordinates, 0, 3);
            double m00 = (this.ordinates[4] - this.ordinates[0]) / (double)width;
            double m10 = (this.ordinates[5] - this.ordinates[1]) / (double)width;
            double m01 = (this.ordinates[2] - this.ordinates[0]) / (double)heigth;
            double m11 = (this.ordinates[3] - this.ordinates[1]) / (double)heigth;
            double m02 = this.ordinates[0];
            double m12 = this.ordinates[1];
            AffineTransform at = new AffineTransform(m00, m10, m01, m11, m02, m12);
            at.translate(-minx, -miny);
            XAffineTransform.round(at, 1.0E-6);
            LOGGER.log(Level.FINE, "Optimizing the warp into an affine transformation: {0}", at);
            return new WarpAffine(at);
        }
        int stepx = (int)((double)width / Math.pow(2.0, rowCols[1]));
        int stepy = (int)((double)heigth / Math.pow(2.0, rowCols[0]));
        int cols = width / stepx;
        int rows = heigth / stepy;
        int cmax = (int)(minx + (double)(cols * stepx));
        int rmax = (int)(miny + (double)(rows * stepy));
        if (this.maxPositions > 0 && cols * rows > this.maxPositions) {
            LOGGER.log(Level.FINE, "Bailing out to WarpAdapter, the number of rows and col grew too much, rows: " + rows + " and cols: " + cols);
            return new WarpAdapter(null, mt);
        }
        if ((double)cmax < maxx) {
            if (cmax + stepx < cols * (stepx + 1)) {
                cmax += stepx;
                ++cols;
            } else {
                cmax = (int)(minx + (double)(cols * ++stepx));
            }
        }
        if ((double)rmax < maxy) {
            if (rmax + stepy < rows * (stepy + 1)) {
                rmax += stepy;
                ++rows;
            } else {
                rmax = (int)(miny + (double)(rows * ++stepy));
            }
        }
        float[] warpPositions = new float[(rows + 1) * (cols + 1) * 2];
        int idx = 0;
        for (int r = (int)miny; r <= rmax; r += stepy) {
            for (int c = (int)minx; c <= cmax; c += stepx) {
                warpPositions[idx++] = (float)Math.min((double)c, maxx);
                warpPositions[idx++] = (float)Math.min((double)r, maxy);
            }
        }
        if (DUMP_GRIDS) {
            this.dumpPropertyFile(warpPositions, "original");
        }
        mt.transform(warpPositions, 0, warpPositions, 0, warpPositions.length / 2);
        if (DUMP_GRIDS) {
            this.dumpPropertyFile(warpPositions, "transformed");
        }
        LOGGER.log(Level.FINE, "Optimizing the warp into an grid warp {0} x {1}", new Object[]{rows, cols});
        return new WarpGrid((int)minx, stepx, cols, (int)miny, stepy, rows, warpPositions);
    }

    int[] computeOptimalDepths(MathTransform2D mt, double minx, double maxx, double miny, double maxy, int rowDepth, int colDepth, DomainValidator validator) throws TransformException {
        boolean withinTolHorizontal;
        validator.validateDomain(minx, maxx, miny, maxy, rowDepth, colDepth);
        double midx = (minx + maxx) / 2.0;
        double midy = (miny + maxy) / 2.0;
        boolean withinTolVertical = this.isWithinTolerance(mt, minx, miny, minx, midy, minx, maxy) && this.isWithinTolerance(mt, maxx, miny, maxx, midy, maxx, maxy);
        boolean bl = withinTolHorizontal = this.isWithinTolerance(mt, minx, miny, midx, miny, maxx, miny) && this.isWithinTolerance(mt, minx, maxy, midx, maxy, maxx, maxy);
        if (withinTolVertical && withinTolHorizontal && (!this.isWithinTolerance(mt, minx, miny, midx, midy, maxx, maxy) || !this.isWithinTolerance(mt, minx, maxy, midx, midy, maxx, miny))) {
            withinTolVertical = false;
            withinTolHorizontal = false;
        }
        if (!withinTolHorizontal && !withinTolVertical) {
            int[] d1 = this.computeOptimalDepths(mt, minx, midx, miny, midy, ++rowDepth, ++colDepth, validator);
            int[] d2 = this.computeOptimalDepths(mt, minx, midx, midy, maxy, rowDepth, colDepth, validator);
            int[] d3 = this.computeOptimalDepths(mt, midx, maxx, miny, midy, rowDepth, colDepth, validator);
            int[] d4 = this.computeOptimalDepths(mt, midx, maxx, midy, maxy, rowDepth, colDepth, validator);
            return new int[]{Math.max(Math.max(d1[0], d2[0]), Math.max(d3[0], d4[0])), Math.max(Math.max(d1[1], d2[1]), Math.max(d3[1], d4[1]))};
        }
        if (!withinTolHorizontal) {
            int[] d1 = this.computeOptimalDepths(mt, minx, midx, miny, maxy, rowDepth, ++colDepth, validator);
            int[] d2 = this.computeOptimalDepths(mt, midx, maxx, miny, maxy, rowDepth, colDepth, validator);
            return new int[]{Math.max(d1[0], d2[0]), Math.max(d1[1], d2[1])};
        }
        if (!withinTolVertical) {
            int[] d1 = this.computeOptimalDepths(mt, minx, maxx, miny, midy, ++rowDepth, colDepth, validator);
            int[] d2 = this.computeOptimalDepths(mt, minx, maxx, midy, maxy, rowDepth, colDepth, validator);
            return new int[]{Math.max(d1[0], d2[0]), Math.max(d1[1], d2[1])};
        }
        return new int[]{rowDepth, colDepth};
    }

    boolean isWithinTolerance(MathTransform2D mt, double x1, double y1, double x2, double y2, double x3, double y3) throws TransformException {
        double dy;
        double dx;
        double distance;
        this.ordinates[0] = x1;
        this.ordinates[1] = y1;
        this.ordinates[2] = (x1 + x2) / 2.0;
        this.ordinates[3] = (y1 + y2) / 2.0;
        this.ordinates[4] = x2;
        this.ordinates[5] = y2;
        this.ordinates[6] = (x2 + x3) / 2.0;
        this.ordinates[7] = (y2 + y3) / 2.0;
        this.ordinates[8] = x3;
        this.ordinates[9] = y3;
        mt.transform(this.ordinates, 0, this.ordinates, 0, 5);
        boolean withinTolerance = true;
        for (int i = 1; i < 4 && withinTolerance; withinTolerance &= (distance = dx * dx + dy * dy) < this.maxDistanceSquared, ++i) {
            double tx1 = this.ordinates[0];
            double ty1 = this.ordinates[1];
            double tx2 = this.ordinates[i * 2];
            double ty2 = this.ordinates[i * 2 + 1];
            double tx3 = this.ordinates[8];
            double ty3 = this.ordinates[9];
            dx = 0.0;
            if (Math.abs(x3 - x1) > 1.0E-6) {
                double xmid = i == 1 ? (x1 + x2) / 2.0 : (i == 2 ? x2 : (x2 + x3) / 2.0);
                dx = tx2 - (tx3 - tx1) / (x3 - x1) * (xmid - x1) - tx1;
            }
            dy = 0.0;
            if (!(Math.abs(y3 - y1) > 1.0E-6)) continue;
            double ymid = i == 1 ? (y1 + y2) / 2.0 : (i == 2 ? y2 : (y2 + y3) / 2.0);
            dy = ty2 - (ty3 - ty1) / (y3 - y1) * (ymid - y1) - ty1;
        }
        return withinTolerance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpPropertyFile(float[] points, String name) {
        long start = System.currentTimeMillis();
        BufferedWriter writer = null;
        try {
            File output = File.createTempFile(start + name, ".properties");
            writer = new BufferedWriter(new FileWriter(output));
            writer.write("_=geom:Point:srid=32632");
            writer.newLine();
            for (int i = 0; i < points.length; i += 2) {
                writer.write("p." + i / 2 + "=POINT(" + points[i] + " " + points[i + 1] + ")");
                writer.newLine();
            }
            LOGGER.info(name + " dumped as " + output.getName());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to dump points: " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    class ExcessiveDepthException
    extends RuntimeException {
        private static final long serialVersionUID = -3533898904532522502L;

        public ExcessiveDepthException() {
        }

        public ExcessiveDepthException(String message, Throwable cause) {
            super(message, cause);
        }

        public ExcessiveDepthException(String message) {
            super(message);
        }

        public ExcessiveDepthException(Throwable cause) {
            super(cause);
        }
    }

    static interface DomainValidator {
        public void validateDomain(double var1, double var3, double var5, double var7, int var9, int var10);
    }
}

