/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.xsd.XSDSchema;
import org.geotools.gml2.GML;
import org.geotools.util.URLs;
import org.geotools.xsd.SchemaLocationResolver;
import org.geotools.xsd.XSD;

public class ApplicationSchemaXSD
extends XSD {
    private String namespaceURI;
    private String schemaLocation;

    public ApplicationSchemaXSD(String namespaceURI, String schemaLocation) {
        this.namespaceURI = namespaceURI;
        this.schemaLocation = schemaLocation;
    }

    protected void addDependencies(Set dependencies) {
        dependencies.add(GML.getInstance());
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public SchemaLocationResolver createSchemaLocationResolver() {
        return new SchemaLocationResolver(this){

            public String resolveSchemaLocation(XSDSchema schema, String uri, String location) {
                String schemaLocation = schema == null ? ApplicationSchemaXSD.this.getSchemaLocation() : schema.getSchemaLocation();
                String locationUri = null;
                if (null != schemaLocation && !"".equals(schemaLocation)) {
                    File locationFile;
                    String schemaLocationFolder = schemaLocation;
                    int lastSlash = schemaLocation.lastIndexOf(47);
                    if (lastSlash > 0) {
                        schemaLocationFolder = schemaLocation.substring(0, lastSlash);
                    }
                    if (schemaLocationFolder.startsWith("file:")) {
                        try {
                            schemaLocationFolder = URLs.urlToFile((URL)new URL(schemaLocationFolder)).getPath();
                        }
                        catch (MalformedURLException e) {
                            schemaLocationFolder = schemaLocationFolder.substring("file:".length());
                        }
                    }
                    if ((locationFile = new File(schemaLocationFolder, location)).exists()) {
                        locationUri = locationFile.toURI().toString();
                    }
                    if (locationUri == null && location != null && schemaLocationFolder.startsWith("jar:file:")) {
                        locationUri = schemaLocationFolder + "/" + location;
                    }
                }
                if (locationUri == null && location != null && location.startsWith("http:")) {
                    locationUri = location;
                }
                return locationUri;
            }
        };
    }
}

