/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

public final class Es6ToEs3ClassSideInheritance
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Multimap<String, String> staticMembers = ArrayListMultimap.create();
    static final DiagnosticType DUPLICATE_CLASS = DiagnosticType.error("DUPLICATE_CLASS", "Multiple classes cannot share the same name.");
    private final Set<String> multiplyDefinedClasses = new HashSet<String>();

    public Es6ToEs3ClassSideInheritance(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindCopyProp findCopyProp = new FindCopyProp();
        NodeTraversal.traverse(this.compiler, root, findCopyProp);
        if (findCopyProp.found) {
            NodeTraversal.traverse(this.compiler, root, new FindStaticMembers());
            NodeTraversal.traverse(this.compiler, root, this);
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isCall()) {
            return;
        }
        if (n.getFirstChild().matchesQualifiedName("$jscomp.copyProperties")) {
            Node superClassName = n.getLastChild();
            Node subClassName = n.getChildBefore(superClassName);
            String key = superClassName.getQualifiedName();
            if (this.multiplyDefinedClasses.contains(key)) {
                this.compiler.report(JSError.make(n, DUPLICATE_CLASS, new String[0]));
                return;
            }
            if (this.staticMembers.containsKey((Object)key)) {
                for (String staticMember : this.staticMembers.get((Object)key)) {
                    Node sAssign = IR.exprResult(IR.assign(IR.getprop(subClassName.cloneTree(), IR.string(staticMember)), IR.getprop(superClassName.cloneTree(), IR.string(staticMember))));
                    sAssign.useSourceInfoIfMissingFromForTree(n);
                    parent.getParent().addChildAfter(sAssign, parent);
                    this.staticMembers.put((Object)subClassName.getQualifiedName(), (Object)staticMember);
                }
            }
            parent.detachFromParent();
        }
    }

    private class FindStaticMembers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> classNames = new HashSet<String>();

        private FindStaticMembers() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getType()) {
                case 118: {
                    this.visitVar(n);
                    break;
                }
                case 86: {
                    this.visitAssign(n);
                    break;
                }
                case 105: {
                    this.visitFunctionClassDef(n);
                }
            }
        }

        private void visitFunctionClassDef(Node n) {
            JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(n);
            if (classInfo != null && classInfo.isConstructor()) {
                String name = NodeUtil.getFunctionName(n);
                if (this.classNames.contains(name)) {
                    Es6ToEs3ClassSideInheritance.this.multiplyDefinedClasses.add(name);
                } else if (name != null) {
                    this.classNames.add(name);
                }
            }
        }

        private void visitAssign(Node n) {
            Node getProp;
            String maybeClassName;
            if (this.classNames.contains(n.getLastChild().getQualifiedName())) {
                String maybeAlias = n.getFirstChild().getQualifiedName();
                if (maybeAlias != null) {
                    this.classNames.add(maybeAlias);
                    Es6ToEs3ClassSideInheritance.this.staticMembers.putAll((Object)maybeAlias, (Iterable)Es6ToEs3ClassSideInheritance.this.staticMembers.get((Object)n.getLastChild().getQualifiedName()));
                }
            } else if (n.getFirstChild().isGetProp() && this.classNames.contains(maybeClassName = (getProp = n.getFirstChild()).getFirstChild().getQualifiedName())) {
                Es6ToEs3ClassSideInheritance.this.staticMembers.put((Object)maybeClassName, (Object)getProp.getLastChild().getString());
            }
        }

        private void visitVar(Node n) {
            String maybeAlias;
            Node child = n.getFirstChild();
            if (!child.hasChildren()) {
                return;
            }
            String maybeOriginalName = child.getFirstChild().getQualifiedName();
            if (this.classNames.contains(maybeOriginalName) && (maybeAlias = child.getQualifiedName()) != null) {
                this.classNames.add(maybeAlias);
                Es6ToEs3ClassSideInheritance.this.staticMembers.putAll((Object)maybeAlias, (Iterable)Es6ToEs3ClassSideInheritance.this.staticMembers.get((Object)maybeOriginalName));
            }
        }
    }

    private class FindCopyProp
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found = false;

        private FindCopyProp() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (this.found || n.isCall() && n.getFirstChild().matchesQualifiedName("$jscomp.copyProperties")) {
                this.found = true;
                return false;
            }
            return true;
        }
    }
}

