/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.fop.render.pdf.pdfbox.PSPDFGraphics2D;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.graphics.DrawObject;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GeneralGraphics2DImagePainter;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class ImageConverterPDF2G2D
extends AbstractImageConverter {
    private static final Log LOG = LogFactory.getLog(ImageConverterPDF2G2D.class);

    public Image convert(Image src, Map hints) throws ImageException, IOException {
        float dpi = 72.0f;
        if (hints != null && (dpi = ((Float)hints.get("SOURCE_RESOLUTION")).floatValue()) == 72.0f) {
            dpi *= 2.0f;
        }
        this.checkSourceFlavor(src);
        assert (src instanceof ImagePDF);
        ImagePDF imgPDF = (ImagePDF)src;
        int selectedPage = ImageUtil.needPageIndexFromURI((String)src.getInfo().getOriginalURI());
        PDDocument pddoc = imgPDF.getPDDocument();
        Graphics2DImagePainterPDF painter = new Graphics2DImagePainterPDF(pddoc, dpi, selectedPage, imgPDF.getInfo().getOriginalURI());
        ImageGraphics2D g2dImage = new ImageGraphics2D(src.getInfo(), (Graphics2DImagePainter)painter);
        return g2dImage;
    }

    public ImageFlavor getSourceFlavor() {
        return ImagePDF.PDFBOX_IMAGE;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    public int getConversionPenalty() {
        return 1000;
    }

    static class FopFontMapper
    implements FontMapper {
        private FontMapper defaultFontMapper;
        private ThreadLocal<FopFontProvider> fopFontProvider = new ThreadLocal();

        FopFontMapper() {
            this.defaultFontMapper = FontMappers.instance();
        }

        private TrueTypeFont getTrueTypeFont(String baseFont) {
            FopFontProvider fontProvider = this.fopFontProvider.get();
            if (fontProvider == null) {
                return null;
            }
            return fontProvider.getTrueTypeFont(baseFont);
        }

        public FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
            TrueTypeFont fopFont = this.getTrueTypeFont(baseFont);
            if (fopFont != null) {
                return new FontMapping((FontBoxFont)fopFont, true);
            }
            return this.defaultFontMapper.getTrueTypeFont(baseFont, fontDescriptor);
        }

        public FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
            TrueTypeFont fopFont = this.getTrueTypeFont(baseFont);
            if (fopFont != null) {
                return new FontMapping((FontBoxFont)fopFont, true);
            }
            return this.defaultFontMapper.getFontBoxFont(baseFont, fontDescriptor);
        }

        public CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
            TrueTypeFont ttFont = this.getTrueTypeFont(baseFont);
            if (ttFont != null) {
                return new CIDFontMapping(null, (FontBoxFont)ttFont, true);
            }
            return this.defaultFontMapper.getCIDFont(baseFont, fontDescriptor, cidSystemInfo);
        }
    }

    static class FopFontProvider {
        private static FopFontMapper fopFontMapper = new FopFontMapper();
        private Map<String, Object> fonts = new HashMap<String, Object>();
        private Map<String, TrueTypeFont> ttFonts = new HashMap<String, TrueTypeFont>();

        FopFontProvider() {
        }

        void start() {
            fopFontMapper.fopFontProvider.set(this);
        }

        void close() {
            fopFontMapper.fopFontProvider.remove();
        }

        private CustomFont getFont(String name) throws IOException {
            Object typeface = this.fonts.get(name);
            if (typeface instanceof LazyFont) {
                Typeface rf = ((LazyFont)typeface).getRealFont();
                return (CustomFont)rf;
            }
            if (typeface instanceof CustomFontMetricsMapper) {
                Typeface rf = ((CustomFontMetricsMapper)typeface).getRealFont();
                return (CustomFont)rf;
            }
            return null;
        }

        public TrueTypeFont getTrueTypeFont(String postScriptName) {
            if (!this.ttFonts.containsKey(postScriptName)) {
                try {
                    CustomFont font = this.getFont(postScriptName);
                    if (font instanceof MultiByteFont && !((MultiByteFont)font).isOTFFile()) {
                        TTFParser ttfParser = new TTFParser(false, true);
                        TrueTypeFont ttf = ttfParser.parse(font.getInputStream());
                        this.ttFonts.put(postScriptName, ttf);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.ttFonts.get(postScriptName);
        }

        static {
            FontMappers.set((FontMapper)fopFontMapper);
        }
    }

    static final class CheckImageMask
    extends PDFStreamEngine {
        private static final String DRAWOBJECT = new DrawObject().getName();
        private static final String SETNONSTROKINGDEVICEGRAYCOLOR = new SetNonStrokingDeviceGrayColor().getName();
        private boolean foundWhite;
        private boolean checkColor;
        private Map<String, PDXObject> xobjects;
        private PDPage page;

        private CheckImageMask(Map<String, PDXObject> visitedXOjects, PDPage page) throws IOException {
            this.xobjects = visitedXOjects;
            this.page = page;
            for (PDXObject pdxObject : this.xobjects.values()) {
                if (!(pdxObject instanceof PDImageXObject) || !((PDImageXObject)pdxObject).isStencil()) continue;
                this.processChildStream((PDContentStream)page, page);
                return;
            }
        }

        protected void processOperator(Operator operator, List<COSBase> arguments) throws IOException {
            if (!this.foundWhite) {
                String op = operator.getName();
                if (this.checkColor && op.equals(SETNONSTROKINGDEVICEGRAYCOLOR)) {
                    COSBase color = arguments.get(0);
                    if (color instanceof COSInteger && ((COSInteger)color).intValue() == 1) {
                        this.foundWhite = true;
                    }
                } else if (op.equals(DRAWOBJECT)) {
                    COSName name = (COSName)arguments.get(0);
                    PDXObject xobject = this.xobjects.get(name.getName());
                    if (xobject instanceof PDFormXObject) {
                        this.checkColor = true;
                        this.processChildStream((PDContentStream)((PDFormXObject)xobject), this.page);
                    }
                    this.checkColor = false;
                }
            }
        }
    }

    private static class Graphics2DImagePainterPDF
    implements GeneralGraphics2DImagePainter {
        private final PDPage page;
        private final PDDocument pdDocument;
        private float dpi;
        private int selectedPage;
        private FopFontProvider fopFontProvider = new FopFontProvider();
        private String uri;

        public Graphics2DImagePainterPDF(PDDocument pddoc, float dpi, int selectedPage, String uri) {
            this.dpi = dpi;
            this.pdDocument = pddoc;
            this.selectedPage = selectedPage;
            this.page = this.pdDocument.getPage(selectedPage);
            this.uri = uri;
        }

        public Dimension getImageSize() {
            PDRectangle mediaBox = this.page.getMediaBox();
            int wmpt = (int)Math.ceil(mediaBox.getWidth() * 1000.0f);
            int hmpt = (int)Math.ceil(mediaBox.getHeight() * 1000.0f);
            return new Dimension(wmpt, hmpt);
        }

        public void paint(Graphics2D g2d, Rectangle2D area) {
            this.fopFontProvider.start();
            try {
                PDRectangle mediaBox = this.page.getCropBox();
                AffineTransform at = new AffineTransform();
                int rotation = this.page.getRotation();
                if (rotation == 90 || rotation == 270) {
                    at.scale(area.getWidth() / area.getHeight(), area.getHeight() / area.getWidth());
                }
                if (g2d instanceof PSGraphics2D && new PageUtil().pageHasTransparency(this.page.getResources(), this.page)) {
                    this.drawPageAsImage(at, g2d);
                } else {
                    at.translate(area.getX(), area.getY());
                    at.scale(area.getWidth() / (double)mediaBox.getWidth(), area.getHeight() / (double)mediaBox.getHeight());
                    g2d.transform(at);
                    this.normaliseScale(g2d);
                    new PDFRenderer(this.pdDocument).renderPageToGraphics(this.selectedPage, g2d);
                }
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while painting PDF page: " + this.uri + " " + t.getMessage(), t);
            }
            finally {
                this.fopFontProvider.close();
            }
        }

        private void normaliseScale(Graphics2D g2d) {
            if (!(g2d instanceof AbstractGraphics2D)) {
                AffineTransform old = g2d.getTransform();
                double scaleX = BigDecimal.valueOf(old.getScaleX()).setScale(2, RoundingMode.HALF_UP).doubleValue();
                double scaleY = BigDecimal.valueOf(old.getScaleY()).setScale(2, RoundingMode.HALF_UP).doubleValue();
                AffineTransform newat = new AffineTransform(scaleX, old.getShearY(), old.getShearX(), scaleY, old.getTranslateX(), old.getTranslateY());
                g2d.setTransform(newat);
            }
        }

        private void drawPageAsImage(AffineTransform at, Graphics2D g2d) throws IOException {
            PDFRenderer renderer = new PDFRenderer(this.pdDocument);
            BufferedImage bi = renderer.renderImageWithDPI(this.selectedPage, this.dpi);
            at.scale(72.0f / this.dpi, 72.0f / this.dpi);
            g2d.drawImage(bi, at, null);
        }

        public Graphics2D getGraphics(boolean textAsShapes, PSGenerator gen) {
            PSPDFGraphics2D graphics = new PSPDFGraphics2D(textAsShapes, gen);
            return graphics;
        }

        public void addFallbackFont(String s, Object font) {
            this.fopFontProvider.fonts.put(s, font);
        }

        static class PageUtil {
            private List<COSDictionary> visited = new ArrayList<COSDictionary>();
            private Map<String, PDXObject> visitedXOjects = new HashMap<String, PDXObject>();

            PageUtil() {
            }

            private boolean pageHasTransparency(PDResources res, PDPage page) throws IOException {
                if (res != null) {
                    this.visited.add(res.getCOSObject());
                    if (res.getShadingNames() != null) {
                        for (COSName name : res.getShadingNames()) {
                            PDShading s = res.getShading(name);
                            if (!(s.getShadingType() != 2 && s.getShadingType() != 3 || s.getShadingType() == 3 && s.getFunction().getFunctionType() == 2) && (s.getShadingType() != 2 || !s.getColorSpace().toString().contains("FunctionType"))) continue;
                            LOG.warn((Object)(s.getClass().getName() + " not supported converting to image"));
                            return true;
                        }
                    }
                    for (COSName pdxObjectName : res.getXObjectNames()) {
                        PDXObject pdxObject = res.getXObject(pdxObjectName);
                        this.visitedXOjects.put(pdxObjectName.getName(), pdxObject);
                        if (!(pdxObject instanceof PDFormXObject)) continue;
                        PDFormXObject form = (PDFormXObject)pdxObject;
                        if (form.getGroup() != null && COSName.TRANSPARENCY.equals((Object)form.getGroup().getCOSObject().getDictionaryObject(COSName.S))) {
                            return true;
                        }
                        PDResources formRes = form.getResources();
                        if (formRes == null || this.visited.contains(formRes.getCOSObject()) || !this.pageHasTransparency(formRes, page)) continue;
                        return true;
                    }
                }
                CheckImageMask checkImageMask = new CheckImageMask(this.visitedXOjects, page);
                return checkImageMask.foundWhite;
            }
        }
    }
}

