/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.schema.dublincore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fao.geonet.kernel.schema.AssociatedResource;
import org.fao.geonet.kernel.schema.AssociatedResourcesSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.schema.dublincore.DublinCoreNamespaces;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;

public class DublinCoreSchemaPlugin
extends SchemaPlugin
implements AssociatedResourcesSchemaPlugin {
    public static final String IDENTIFIER = "dublin-core";
    private static ImmutableSet<Namespace> allNamespaces = ImmutableSet.builder().add((Object)DublinCoreNamespaces.DC).add((Object)DublinCoreNamespaces.DCT).build();
    private static Map<String, Namespace> allTypenames = ImmutableMap.builder().put((Object)"csw:Record", (Object)Namespace.getNamespace((String)"csw", (String)"http://www.opengis.net/cat/csw/2.0.2")).put((Object)"dcat", (Object)Namespace.getNamespace((String)"dcat", (String)"http://www.w3.org/ns/dcat#")).build();

    public DublinCoreSchemaPlugin() {
        super(IDENTIFIER, allNamespaces);
    }

    public Set<AssociatedResource> getAssociatedResourcesUUIDs(Element metadata) {
        return null;
    }

    public Set<String> getAssociatedParentUUIDs(Element metadata) {
        return this.getAssociatedParents(metadata).stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
    }

    public Set<String> getAssociatedDatasetUUIDs(Element metadata) {
        return null;
    }

    public Set<String> getAssociatedFeatureCatalogueUUIDs(Element metadata) {
        return null;
    }

    public Set<String> getAssociatedSourceUUIDs(Element metadata) {
        return null;
    }

    public Set<AssociatedResource> getAssociatedParents(Element metadata) {
        ElementFilter elementFilter = new ElementFilter("isPartOf", DublinCoreNamespaces.DCT);
        return Xml.filterElementValues((Element)metadata, (ElementFilter)elementFilter, null, null, null).stream().map(uuid -> new AssociatedResource(uuid, "", "isPartOf")).collect(Collectors.toSet());
    }

    public Set<AssociatedResource> getAssociatedDatasets(Element metadata) {
        return new HashSet<AssociatedResource>();
    }

    public Set<AssociatedResource> getAssociatedFeatureCatalogues(Element metadata) {
        return new HashSet<AssociatedResource>();
    }

    public Set<AssociatedResource> getAssociatedSources(Element metadata) {
        return new HashSet<AssociatedResource>();
    }

    public Map<String, Namespace> getCswTypeNames() {
        return allTypenames;
    }
}

