/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.hooks.ISvnFileListHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNStatusEditor17 {
    protected SVNWCContext myWCContext;
    protected File myPath;
    protected boolean myIsReportAll;
    protected boolean myIsNoIgnore;
    protected SVNDepth myDepth;
    protected ISvnObjectReceiver<SvnStatus> myStatusHandler;
    protected Map<File, File> myExternalsMap;
    protected Collection<String> myGlobalIgnores;
    protected SVNURL myRepositoryRoot;
    protected Map<String, SVNLock> myRepositoryLocks;
    protected long myTargetRevision;
    protected String myWCRootPath;
    protected ISvnFileListHook myFileListHook;
    protected ISvnFileListHook myDefaultFileListHook;
    protected boolean myIsGetExcluded;
    private boolean myIgnoreTextMods;
    private SVNWCDbRoot wcRoot;

    public SVNStatusEditor17(File path, SVNWCContext wcContext, ISVNOptions options, boolean noIgnore, boolean reportAll, SVNDepth depth, ISvnObjectReceiver<SvnStatus> handler) {
        this.myWCContext = wcContext;
        this.myPath = path;
        this.myIsNoIgnore = noIgnore;
        this.myIsReportAll = reportAll;
        this.myDepth = depth;
        this.myStatusHandler = handler;
        this.myExternalsMap = new HashMap<File, File>();
        this.myGlobalIgnores = SVNStatusEditor17.getGlobalIgnores(options);
        this.myTargetRevision = -1L;
        this.myFileListHook = this.myDefaultFileListHook = new DefaultSvnFileListHook();
        this.myIsGetExcluded = false;
    }

    protected void collectExternals(File path) throws SVNException {
        this.myExternalsMap = this.myWCContext.getDb().getExternalsDefinedBelow(path);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        boolean skip_root;
        String target_name;
        File anchor_abspath;
        SVNNodeKind localKind = SVNFileType.getNodeKind(SVNFileType.getType(this.myPath));
        SVNNodeKind kind = this.myWCContext.readKind(this.myPath, false);
        if (kind == SVNNodeKind.FILE && localKind == SVNNodeKind.FILE) {
            anchor_abspath = SVNFileUtil.getFileDir(this.myPath);
            target_name = SVNFileUtil.getFileName(this.myPath);
            skip_root = true;
        } else if (kind == SVNNodeKind.DIR && localKind == SVNNodeKind.DIR) {
            anchor_abspath = this.myPath;
            target_name = null;
            skip_root = false;
        } else {
            anchor_abspath = SVNFileUtil.getFileDir(this.myPath);
            target_name = SVNFileUtil.getFileName(this.myPath);
            skip_root = false;
        }
        SVNFileType fileType = SVNFileType.getType(anchor_abspath);
        this.getDirStatus(anchor_abspath, target_name, skip_root, null, null, fileType, this.myGlobalIgnores, this.myDepth, this.myIsReportAll, true, this.getDefaultHandler());
        return null;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long revision) {
        this.myTargetRevision = revision;
    }

    public void setFileListHook(ISvnFileListHook filesListHook) {
        if (filesListHook != null) {
            this.myFileListHook = filesListHook;
        }
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    protected ISvnObjectReceiver<SvnStatus> getDefaultHandler() {
        return this.myStatusHandler;
    }

    protected boolean isReportAll() {
        return this.myIsReportAll;
    }

    protected boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    private static Collection<String> getGlobalIgnores(ISVNOptions options) {
        String[] ignores;
        if (options != null && (ignores = options.getIgnorePatterns()) != null) {
            HashSet<String> patterns = new HashSet<String>();
            for (int i = 0; i < ignores.length; ++i) {
                patterns.add(ignores[i]);
            }
            return patterns;
        }
        return Collections.emptySet();
    }

    private void sendStatusStructure(File localAbsPath, ISVNWCDb.WCDbRepositoryInfo parentReposInfo, ISVNWCDb.SVNWCDbInfo info, SVNNodeKind pathKind, boolean pathSpecial, boolean getAll, ISvnObjectReceiver<SvnStatus> handler) throws SVNException {
        SvnStatus status;
        ISVNWCDb.WCDbRepositoryInfo reposInfo;
        SVNLock repositoryLock = null;
        if (this.myRepositoryLocks != null && (reposInfo = SVNStatusEditor17.getRepositoryRootUrlRelPath(this.myWCContext, parentReposInfo, info, localAbsPath)) != null && reposInfo.relPath != null) {
            repositoryLock = this.myRepositoryLocks.get("/" + SVNFileUtil.getFilePath(reposInfo.relPath));
        }
        if ((status = SVNStatusEditor17.assembleStatus(this.myWCContext, localAbsPath, parentReposInfo, info, pathKind, pathSpecial, getAll, this.myIgnoreTextMods, repositoryLock)) != null && handler != null) {
            handler.receive(SvnTarget.fromFile(localAbsPath), status);
        }
    }

    private void sendUnversionedItem(File nodeAbsPath, SVNNodeKind pathKind, boolean treeConflicted, Collection<String> patterns, boolean noIgnore, ISvnObjectReceiver<SvnStatus> handler) throws SVNException {
        boolean isIgnored = SvnNgPropertiesManager.isIgnored(SVNFileUtil.getFileName(nodeAbsPath), patterns);
        boolean isExternal = this.isExternal(nodeAbsPath);
        SvnStatus status = SVNStatusEditor17.assembleUnversioned17(nodeAbsPath, pathKind, treeConflicted, isIgnored);
        if (status != null) {
            if (isExternal) {
                status.setNodeStatus(SVNStatusType.STATUS_EXTERNAL);
            }
            if (status.isConflicted()) {
                isIgnored = false;
            }
            if (handler != null && (noIgnore || !isIgnored || isExternal)) {
                handler.receive(SvnTarget.fromFile(nodeAbsPath), status);
            }
        }
    }

    public static SvnStatus assembleUnversioned17(File localAbspath, SVNNodeKind pathKind, boolean treeConflicted, boolean isIgnored) throws SVNException {
        SvnStatus stat = new SvnStatus();
        stat.setPath(localAbspath);
        stat.setKind(SVNNodeKind.UNKNOWN);
        stat.setDepth(SVNDepth.UNKNOWN);
        stat.setNodeStatus(SVNStatusType.STATUS_NONE);
        stat.setTextStatus(SVNStatusType.STATUS_NONE);
        stat.setPropertiesStatus(SVNStatusType.STATUS_NONE);
        stat.setRepositoryNodeStatus(SVNStatusType.STATUS_NONE);
        stat.setRepositoryTextStatus(SVNStatusType.STATUS_NONE);
        stat.setRepositoryPropertiesStatus(SVNStatusType.STATUS_NONE);
        if (pathKind != SVNNodeKind.NONE) {
            if (isIgnored) {
                stat.setNodeStatus(SVNStatusType.STATUS_IGNORED);
            } else {
                stat.setNodeStatus(SVNStatusType.STATUS_UNVERSIONED);
            }
        } else if (treeConflicted) {
            stat.setNodeStatus(SVNStatusType.STATUS_CONFLICTED);
        }
        stat.setRevision(-1L);
        stat.setChangedRevision(-1L);
        stat.setRepositoryChangedRevision(-1L);
        stat.setRepositoryKind(SVNNodeKind.NONE);
        stat.setConflicted(treeConflicted);
        stat.setChangelist(null);
        return stat;
    }

    public static SvnStatus assembleStatus(SVNWCContext context, File localAbsPath, ISVNWCDb.WCDbRepositoryInfo parentReposInfo, ISVNWCDb.SVNWCDbInfo info, SVNNodeKind pathKind, boolean pathSpecial, boolean getAll, boolean ignoreTextMods, SVNLock repositoryLock) throws SVNException {
        SvnStatus stat;
        block57: {
            boolean conflicted;
            boolean switched_p;
            boolean copied = false;
            SVNStatusType node_status = SVNStatusType.STATUS_NORMAL;
            SVNStatusType text_status = SVNStatusType.STATUS_NORMAL;
            SVNStatusType prop_status = SVNStatusType.STATUS_NONE;
            if (info == null) {
                info = SVNStatusEditor17.readInfo(context, localAbsPath);
            }
            if (info.reposRelpath == null || parentReposInfo == null || parentReposInfo.relPath == null) {
                switched_p = false;
            } else {
                String name = SVNFileUtil.getFilePath(SVNWCUtils.skipAncestor(parentReposInfo.relPath, info.reposRelpath));
                boolean bl = switched_p = name == null || !name.equals(SVNFileUtil.getFileName(localAbsPath));
            }
            if (info.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                if (info.status == ISVNWCDb.SVNWCDbStatus.Incomplete || info.incomplete) {
                    node_status = SVNStatusType.STATUS_INCOMPLETE;
                } else if (info.status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                    node_status = SVNStatusType.STATUS_DELETED;
                    copied = !info.haveBase ? true : context.getNodeScheduleInternal((File)localAbsPath, (boolean)false, (boolean)true).copied;
                } else if (pathKind == null || pathKind != SVNNodeKind.DIR) {
                    node_status = pathKind == null || pathKind == SVNNodeKind.NONE ? SVNStatusType.STATUS_MISSING : SVNStatusType.STATUS_OBSTRUCTED;
                }
            } else if (info.status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                node_status = SVNStatusType.STATUS_DELETED;
                copied = context.getNodeScheduleInternal((File)localAbsPath, (boolean)false, (boolean)true).copied;
            } else if (pathKind == null || pathKind != SVNNodeKind.FILE) {
                node_status = pathKind == null || pathKind == SVNNodeKind.NONE ? SVNStatusType.STATUS_MISSING : SVNStatusType.STATUS_OBSTRUCTED;
            }
            if (info.status != ISVNWCDb.SVNWCDbStatus.Deleted) {
                if (info.propsMod) {
                    prop_status = SVNStatusType.STATUS_MODIFIED;
                } else if (info.hadProps) {
                    prop_status = SVNStatusType.STATUS_NORMAL;
                }
            }
            if (info.kind != ISVNWCDb.SVNWCDbKind.Dir && node_status == SVNStatusType.STATUS_NORMAL) {
                boolean text_modified_p = false;
                long fileSize = SVNFileUtil.getFileLength(localAbsPath);
                long fileTime = SVNFileUtil.getFileLastModified(localAbsPath);
                if (!(info.kind != ISVNWCDb.SVNWCDbKind.File && info.kind != ISVNWCDb.SVNWCDbKind.Symlink || SVNFileUtil.symlinksSupported() && info.special != pathSpecial)) {
                    if (!info.hasChecksum) {
                        text_modified_p = true;
                    } else if (ignoreTextMods || pathKind != null && info.recordedSize != -1L && info.recordedModTime != 0L && info.recordedModTime / 1000L == fileTime && info.recordedSize == fileSize) {
                        text_modified_p = false;
                    } else {
                        try {
                            text_modified_p = context.isTextModified(localAbsPath, false);
                        }
                        catch (SVNException e) {
                            if (!SVNWCContext.isErrorAccess(e)) {
                                throw e;
                            }
                            text_modified_p = true;
                        }
                    }
                } else if (SVNFileUtil.symlinksSupported() && info.special != (pathKind != null && pathSpecial)) {
                    node_status = SVNStatusType.STATUS_OBSTRUCTED;
                }
                if (text_modified_p) {
                    text_status = SVNStatusType.STATUS_MODIFIED;
                }
            }
            if (conflicted = info.conflicted) {
                SVNWCContext.ConflictInfo conflictInfo = context.getConflicted(localAbsPath, true, true, true);
                if (!(conflictInfo.propConflicted || conflictInfo.textConflicted || conflictInfo.treeConflicted)) {
                    conflicted = false;
                }
            }
            if (node_status == SVNStatusType.STATUS_NORMAL && info.status == ISVNWCDb.SVNWCDbStatus.Added) {
                if (!info.opRoot) {
                    copied = true;
                } else if (info.kind == ISVNWCDb.SVNWCDbKind.File && !info.haveBase && !info.haveMoreWork) {
                    node_status = SVNStatusType.STATUS_ADDED;
                    copied = info.hasChecksum;
                } else {
                    SVNWCContext.ScheduleInternalInfo scheduleInfo = context.getNodeScheduleInternal(localAbsPath, true, true);
                    copied = scheduleInfo.copied;
                    if (scheduleInfo.schedule == SVNWCContext.SVNWCSchedule.add) {
                        node_status = SVNStatusType.STATUS_ADDED;
                    } else if (scheduleInfo.schedule == SVNWCContext.SVNWCSchedule.replace) {
                        node_status = SVNStatusType.STATUS_REPLACED;
                    }
                }
            }
            if (node_status == SVNStatusType.STATUS_NORMAL) {
                node_status = text_status;
            }
            if (node_status == SVNStatusType.STATUS_NORMAL && prop_status != SVNStatusType.STATUS_NONE) {
                node_status = prop_status;
            }
            if (!(getAll || node_status != SVNStatusType.STATUS_NONE && node_status != SVNStatusType.STATUS_NORMAL || switched_p || info.locked || info.lock != null || repositoryLock != null || info.changelist != null || conflicted)) {
                return null;
            }
            SVNURL copyFromUrl = null;
            long copyFromRevision = -1L;
            if (copied) {
                Structure<StructureFields.NodeOriginInfo> origin = context.getNodeOrigin(localAbsPath, false, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.revision);
                copyFromUrl = (SVNURL)origin.get(StructureFields.NodeOriginInfo.reposRootUrl);
                if (copyFromUrl != null) {
                    copyFromUrl = SVNWCUtils.join(copyFromUrl, (File)origin.get(StructureFields.NodeOriginInfo.reposRelpath));
                    copyFromRevision = origin.lng(StructureFields.NodeOriginInfo.revision);
                }
                origin.release();
            }
            ISVNWCDb.WCDbRepositoryInfo reposInfo = SVNStatusEditor17.getRepositoryRootUrlRelPath(context, parentReposInfo, info, localAbsPath);
            SVNNodeKind statusKind = null;
            switch (info.kind) {
                case Dir: {
                    statusKind = SVNNodeKind.DIR;
                    break;
                }
                case File: 
                case Symlink: {
                    statusKind = SVNNodeKind.FILE;
                    break;
                }
                default: {
                    statusKind = SVNNodeKind.UNKNOWN;
                }
            }
            stat = new SvnStatus();
            stat.setKind(statusKind);
            stat.setPath(localAbsPath);
            if (info.lock != null) {
                stat.setLock(new SVNLock(SVNFileUtil.getFilePath(reposInfo.relPath), info.lock.token, info.lock.owner, info.lock.comment, info.lock.date, null));
            }
            stat.setCopyFromUrl(copyFromUrl);
            stat.setCopyFromRevision(copyFromRevision);
            stat.setDepth(info.depth);
            stat.setNodeStatus(node_status);
            stat.setTextStatus(text_status);
            stat.setPropertiesStatus(prop_status);
            stat.setRepositoryNodeStatus(SVNStatusType.STATUS_NONE);
            stat.setRepositoryTextStatus(SVNStatusType.STATUS_NONE);
            stat.setRepositoryPropertiesStatus(SVNStatusType.STATUS_NONE);
            stat.setSwitched(switched_p);
            stat.setCopied(copied);
            stat.setRepositoryLock(repositoryLock);
            stat.setRevision(info.revnum);
            stat.setChangedRevision(info.changedRev);
            stat.setChangedAuthor(info.changedAuthor);
            stat.setChangedDate(info.changedDate);
            stat.setRepositoryKind(SVNNodeKind.NONE);
            stat.setRepositoryChangedRevision(-1L);
            stat.setRepositoryChangedDate(null);
            stat.setRepositoryChangedAuthor(null);
            stat.setWcLocked(info.locked);
            stat.setConflicted(info.conflicted);
            stat.setVersioned(true);
            stat.setChangelist(info.changelist);
            stat.setRepositoryRootUrl(reposInfo.rootUrl);
            stat.setRepositoryRelativePath(SVNFileUtil.getFilePath(reposInfo.relPath));
            stat.setRepositoryUuid(reposInfo.uuid);
            if (stat.isVersioned() && stat.isConflicted()) {
                SVNWCContext.ConflictInfo conflictInfo = context.getConflicted(stat.getPath(), true, true, true);
                if (conflictInfo.textConflicted) {
                    stat.setTextStatus(SVNStatusType.STATUS_CONFLICTED);
                }
                if (conflictInfo.propConflicted) {
                    stat.setPropertiesStatus(SVNStatusType.STATUS_CONFLICTED);
                }
                if (conflictInfo.textConflicted || conflictInfo.propConflicted) {
                    stat.setNodeStatus(SVNStatusType.STATUS_CONFLICTED);
                }
            }
            if (stat.isSwitched() && stat.isVersioned() && stat.getKind() == SVNNodeKind.FILE) {
                try {
                    Structure<StructureFields.ExternalNodeInfo> externalInfo = SvnWcDbExternals.readExternal(context, stat.getPath(), stat.getPath(), StructureFields.ExternalNodeInfo.kind);
                    if (externalInfo != null) {
                        stat.setFileExternal(externalInfo.get(StructureFields.ExternalNodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File);
                        stat.setSwitched(false);
                        stat.setNodeStatus(stat.getTextStatus());
                        externalInfo.release();
                    }
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block57;
                    throw e;
                }
            }
        }
        return stat;
    }

    private boolean isExternal(File nodeAbsPath) {
        if (!this.myExternalsMap.containsKey(nodeAbsPath)) {
            for (File externalPath : this.myExternalsMap.keySet()) {
                if (!SVNWCUtils.isChild(nodeAbsPath, externalPath)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Collection<String> collectIgnorePatterns(SVNWCDbRoot root, File localRelPath, Collection<String> ignores) throws SVNException {
        String localIgnores;
        SVNProperties props = SvnWcDbProperties.readProperties(root, localRelPath);
        String string = localIgnores = props != null ? props.getStringValue("svn:ignore") : null;
        if (localIgnores != null) {
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.addAll(ignores);
            StringTokenizer tokens = new StringTokenizer(localIgnores, "\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                patterns.add(token);
            }
            return patterns;
        }
        return ignores;
    }

    public void setRepositoryInfo(SVNURL repositoryRoot, HashMap<String, SVNLock> repositoryLocks) {
        this.myRepositoryRoot = repositoryRoot;
        this.myRepositoryLocks = repositoryLocks;
    }

    private static ISVNWCDb.SVNWCDbInfo readInfo(SVNWCContext context, File localAbsPath) throws SVNException {
        ISVNWCDb.SVNWCDbInfo result = new ISVNWCDb.SVNWCDbInfo();
        ISVNWCDb.WCDbInfo readInfo = context.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedAuthor, ISVNWCDb.WCDbInfo.InfoField.depth, ISVNWCDb.WCDbInfo.InfoField.checksum, ISVNWCDb.WCDbInfo.InfoField.lock, ISVNWCDb.WCDbInfo.InfoField.translatedSize, ISVNWCDb.WCDbInfo.InfoField.lastModTime, ISVNWCDb.WCDbInfo.InfoField.changelist, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.opRoot, ISVNWCDb.WCDbInfo.InfoField.hadProps, ISVNWCDb.WCDbInfo.InfoField.propsMod, ISVNWCDb.WCDbInfo.InfoField.haveBase, ISVNWCDb.WCDbInfo.InfoField.haveMoreWork);
        result.load(readInfo);
        result.locked = context.getDb().isWCLocked(localAbsPath);
        if (result.haveBase && (result.status == ISVNWCDb.SVNWCDbStatus.Added || result.status == ISVNWCDb.SVNWCDbStatus.Deleted)) {
            result.lock = context.getDb().getBaseInfo((File)localAbsPath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock}).lock;
        }
        boolean bl = result.hasChecksum = readInfo.checksum != null;
        if (result.kind == ISVNWCDb.SVNWCDbKind.File && (result.hadProps || result.propsMod)) {
            SVNProperties properties = result.propsMod ? context.getDb().readProperties(localAbsPath) : context.getDb().readPristineProperties(localAbsPath);
            result.special = properties.getSVNPropertyValue("svn:special") != null;
        }
        return result;
    }

    public void walkStatus(File localAbsPath, SVNDepth depth, boolean getAll, boolean noIgnore, boolean ignoreTextMods, Collection<String> ignorePatterns) throws SVNException {
        boolean skipRoot;
        String targetName;
        File anchorAbsPath;
        ISVNWCDb.SVNWCDbInfo dirInfo;
        block5: {
            this.collectExternals(localAbsPath);
            if (ignorePatterns == null) {
                ignorePatterns = SVNStatusEditor17.getGlobalIgnores(this.myWCContext.getOptions());
            }
            dirInfo = null;
            try {
                dirInfo = SVNStatusEditor17.readInfo(this.myWCContext, localAbsPath);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block5;
                throw e;
            }
        }
        SVNFileType fileType = SVNFileType.getType(localAbsPath);
        if (dirInfo != null && dirInfo.kind == ISVNWCDb.SVNWCDbKind.Dir && dirInfo.status != ISVNWCDb.SVNWCDbStatus.Excluded && dirInfo.status != ISVNWCDb.SVNWCDbStatus.NotPresent && dirInfo.status != ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
            anchorAbsPath = localAbsPath;
            targetName = null;
            skipRoot = false;
        } else {
            dirInfo = null;
            anchorAbsPath = SVNFileUtil.getParentFile(localAbsPath);
            targetName = SVNFileUtil.getFileName(localAbsPath);
            skipRoot = true;
        }
        this.myIgnoreTextMods = ignoreTextMods;
        this.getDirStatus(anchorAbsPath, targetName, skipRoot, null, dirInfo, fileType, ignorePatterns, depth, getAll, noIgnore, this.getDefaultHandler());
    }

    /*
     * WARNING - void declaration
     */
    protected void getDirStatus(File localAbsPath, String selected, boolean skipThisDir, ISVNWCDb.WCDbRepositoryInfo parentReposInfo, ISVNWCDb.SVNWCDbInfo dirInfo, SVNFileType fileType, Collection<String> ignorePatterns, SVNDepth depth, boolean getAll, boolean noIgnore, ISvnObjectReceiver<SvnStatus> handler) throws SVNException {
        Map<String, File> childrenFiles;
        this.myWCContext.checkCancelled();
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        if ((childrenFiles = this.myFileListHook.listFiles(localAbsPath)) == null) {
            childrenFiles = Collections.emptyMap();
        }
        HashSet<Object> allChildren = new HashSet<Object>();
        HashSet<String> conflicts = new HashSet<String>();
        HashMap<String, ISVNWCDb.SVNWCDbInfo> nodes = new HashMap<String, ISVNWCDb.SVNWCDbInfo>();
        Collection<String> patterns = null;
        if (dirInfo == null) {
            dirInfo = SVNStatusEditor17.readInfo(this.myWCContext, localAbsPath);
        }
        ISVNWCDb.WCDbRepositoryInfo dirReposInfo = SVNStatusEditor17.getRepositoryRootUrlRelPath(this.myWCContext, parentReposInfo, dirInfo, localAbsPath);
        if (this.wcRoot == null) {
            SVNWCDb.DirParsedInfo pdh = ((SVNWCDb)this.myWCContext.getDb()).parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
            this.wcRoot = pdh.wcDbDir.getWCRoot();
        }
        if (selected == null) {
            File localRelPath = this.wcRoot.computeRelPath(localAbsPath);
            ((SVNWCDb)this.myWCContext.getDb()).readChildren(this.wcRoot, localRelPath, nodes, conflicts);
            allChildren.addAll(nodes.keySet());
            allChildren.addAll(childrenFiles.keySet());
            allChildren.addAll(conflicts);
        } else {
            void var19_21;
            block19: {
                File selectedAbsPath = SVNFileUtil.createFilePath(localAbsPath, selected);
                Object var19_19 = null;
                try {
                    ISVNWCDb.SVNWCDbInfo sVNWCDbInfo = SVNStatusEditor17.readInfo(this.myWCContext, selectedAbsPath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block19;
                    throw e;
                }
            }
            if (var19_21 != null) {
                if (!var19_21.conflicted || var19_21.status != ISVNWCDb.SVNWCDbStatus.Normal || var19_21.kind != ISVNWCDb.SVNWCDbKind.Unknown) {
                    nodes.put(selected, (ISVNWCDb.SVNWCDbInfo)var19_21);
                }
                if (var19_21.conflicted) {
                    conflicts.add(selected);
                }
            }
            allChildren.add(selected);
        }
        if (selected == null) {
            if (!skipThisDir) {
                this.sendStatusStructure(localAbsPath, parentReposInfo, dirInfo, SVNFileType.getNodeKind(fileType), fileType == SVNFileType.SYMLINK, getAll, handler);
            }
            if (depth == SVNDepth.EMPTY) {
                return;
            }
        }
        for (String string : allChildren) {
            File nodeAbsPath = SVNFileUtil.createFilePath(localAbsPath, string);
            SVNFileType nodeFileType = childrenFiles.containsKey(string) ? SVNFileType.getType(childrenFiles.get(string)) : null;
            ISVNWCDb.SVNWCDbInfo nodeInfo = (ISVNWCDb.SVNWCDbInfo)nodes.get(string);
            if (nodeInfo != null && nodeInfo.status != ISVNWCDb.SVNWCDbStatus.NotPresent && nodeInfo.status != ISVNWCDb.SVNWCDbStatus.Excluded && nodeInfo.status != ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
                if (depth == SVNDepth.FILES && nodeInfo.kind == ISVNWCDb.SVNWCDbKind.Dir) continue;
                this.sendStatusStructure(nodeAbsPath, dirReposInfo, nodeInfo, SVNFileType.getNodeKind(nodeFileType), nodeFileType == SVNFileType.SYMLINK, getAll, handler);
                if (depth != SVNDepth.INFINITY || nodeInfo.kind != ISVNWCDb.SVNWCDbKind.Dir) continue;
                this.getDirStatus(nodeAbsPath, null, true, dirReposInfo, nodeInfo, nodeFileType, ignorePatterns, SVNDepth.INFINITY, getAll, noIgnore, handler);
                continue;
            }
            if (conflicts.contains(string)) {
                if (ignorePatterns != null && patterns == null) {
                    patterns = this.collectIgnorePatterns(this.wcRoot, this.wcRoot.computeRelPath(localAbsPath), ignorePatterns);
                }
                this.sendUnversionedItem(nodeAbsPath, SVNFileType.getNodeKind(nodeFileType), true, patterns, noIgnore, handler);
                continue;
            }
            if (nodeFileType == null || depth == SVNDepth.FILES && nodeFileType == SVNFileType.DIRECTORY || SVNFileUtil.getAdminDirectoryName().equals(string)) continue;
            if (ignorePatterns != null && patterns == null) {
                patterns = this.collectIgnorePatterns(this.wcRoot, this.wcRoot.computeRelPath(localAbsPath), ignorePatterns);
            }
            this.sendUnversionedItem(nodeAbsPath, SVNFileType.getNodeKind(nodeFileType), false, patterns, noIgnore || selected != null, handler);
        }
    }

    private static ISVNWCDb.WCDbRepositoryInfo getRepositoryRootUrlRelPath(SVNWCContext context, ISVNWCDb.WCDbRepositoryInfo parentRelPath, ISVNWCDb.SVNWCDbInfo info, File localAbsPath) throws SVNException {
        ISVNWCDb.WCDbRepositoryInfo result = new ISVNWCDb.WCDbRepositoryInfo();
        if (info.reposRelpath != null && info.reposRootUrl != null) {
            result.relPath = info.reposRelpath;
            result.uuid = info.reposUuid;
            result.rootUrl = info.reposRootUrl;
        } else if (parentRelPath != null && parentRelPath.rootUrl != null && parentRelPath.relPath != null) {
            result.relPath = SVNFileUtil.createFilePath(parentRelPath.relPath, SVNFileUtil.getFileName(localAbsPath));
            result.uuid = parentRelPath.uuid;
            result.rootUrl = parentRelPath.rootUrl;
        } else if (info.status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo additionInfo = context.getDb().scanAddition(localAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid);
            result.relPath = additionInfo.reposRelPath;
            result.uuid = additionInfo.reposUuid;
            result.rootUrl = additionInfo.reposRootUrl;
        } else if (info.haveBase) {
            ISVNWCDb.WCDbRepositoryInfo repoInfo = context.getDb().scanBaseRepository(localAbsPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
            result.relPath = repoInfo.relPath;
            result.uuid = repoInfo.uuid;
            result.rootUrl = repoInfo.rootUrl;
        }
        return result;
    }

    public static SvnStatus internalStatus(SVNWCContext context, File localAbsPath) throws SVNException {
        boolean hidden;
        boolean conflicted;
        ISVNWCDb.SVNWCDbKind node_kind;
        ISVNWCDb.SVNWCDbStatus node_status = null;
        assert (SVNWCDb.isAbsolute(localAbsPath));
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
        try {
            ISVNWCDb.WCDbInfo info = context.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.conflicted);
            node_status = info.status;
            node_kind = info.kind;
            conflicted = info.conflicted;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            node_kind = ISVNWCDb.SVNWCDbKind.Unknown;
            conflicted = false;
        }
        if (node_status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || node_status == ISVNWCDb.SVNWCDbStatus.NotPresent || node_status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            node_kind = ISVNWCDb.SVNWCDbKind.Unknown;
        }
        if (node_kind != ISVNWCDb.SVNWCDbKind.Unknown && (hidden = context.getDb().isNodeHidden(localAbsPath))) {
            node_kind = ISVNWCDb.SVNWCDbKind.Unknown;
        }
        if (node_kind == ISVNWCDb.SVNWCDbKind.Unknown) {
            return SVNStatusEditor17.assembleUnversioned17(localAbsPath, kind, conflicted, false);
        }
        boolean isRoot = SVNFileUtil.getParentFile(localAbsPath) == null ? true : context.getDb().isWCRoot(localAbsPath);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        if (SVNFileUtil.getFileDir(localAbsPath) != null && !isRoot) {
            File parent_abspath = SVNFileUtil.getFileDir(localAbsPath);
            try {
                ISVNWCDb.WCDbInfo parent_info = context.getDb().readInfo(parent_abspath, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
                reposInfo.relPath = parent_info.reposRelPath;
                reposInfo.rootUrl = parent_info.reposRootUrl;
                reposInfo.uuid = parent_info.reposUuid;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                    reposInfo.relPath = null;
                    reposInfo.rootUrl = null;
                    reposInfo.uuid = null;
                }
                throw e;
            }
        }
        return SVNStatusEditor17.assembleStatus(context, localAbsPath, reposInfo, null, kind, false, true, false, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSvnFileListHook
    implements ISvnFileListHook {
        private DefaultSvnFileListHook() {
        }

        @Override
        public Map<String, File> listFiles(File parent) {
            File[] children = SVNFileListUtil.listFiles(parent);
            if (children != null) {
                SVNHashMap map = new SVNHashMap();
                for (int i = 0; i < children.length; ++i) {
                    map.put(SVNFileUtil.getFileName(children[i]), children[i]);
                }
                return map;
            }
            return Collections.emptyMap();
        }
    }
}

