/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.features;

import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.trove.v1.binders.BindCreateUserToJson;
import org.jclouds.openstack.trove.v1.binders.BindGrantUserToJson;
import org.jclouds.openstack.trove.v1.domain.User;
import org.jclouds.openstack.trove.v1.filters.EncodeDotsForUserGet;
import org.jclouds.openstack.trove.v1.functions.ParseDatabaseListForUser;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface UserApi {
    @Named(value="user:create")
    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @MapBinder(value=BindCreateUserToJson.class)
    public void create(@PayloadParam(value="users") Set<User> var1);

    @Named(value="user:create")
    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @MapBinder(value=BindCreateUserToJson.class)
    public void create(@PayloadParam(value="name") String var1, @PayloadParam(value="password") String var2, @PayloadParam(value="databaseName") String var3);

    @Named(value="user:create")
    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @MapBinder(value=BindCreateUserToJson.class)
    public void create(@PayloadParam(value="name") String var1, @PayloadParam(value="password") String var2, @PayloadParam(value="host") String var3, @PayloadParam(value="databaseName") String var4);

    @Named(value="user:grant")
    @PUT
    @Path(value="/users/{name}/databases")
    @Consumes(value={"application/json"})
    @MapBinder(value=BindGrantUserToJson.class)
    public void grant(@PathParam(value="name") String var1, @PayloadParam(value="databases") List<String> var2);

    @Named(value="user:grant")
    @PUT
    @Path(value="/users/{name}/databases")
    @Consumes(value={"application/json"})
    @MapBinder(value=BindGrantUserToJson.class)
    public void grant(@PathParam(value="name") String var1, @PayloadParam(value="databaseName") String var2);

    @Named(value="user:revoke")
    @DELETE
    @Path(value="/users/{name}/databases/{databaseName}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean revoke(@PathParam(value="name") String var1, @PathParam(value="databaseName") String var2);

    @Named(value="users:delete/{name}")
    @DELETE
    @Path(value="/users/{name}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="name") String var1);

    @Named(value="user:list")
    @GET
    @Path(value="/users")
    @SelectJson(value={"users"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<User> list();

    @Named(value="user:getDatabaseList/{name}")
    @GET
    @Path(value="/users/{name}/databases")
    @ResponseParser(value=ParseDatabaseListForUser.class)
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<String> getDatabaseList(@PathParam(value="name") String var1);

    @Named(value="user:get/{name}")
    @GET
    @Path(value="/users/{name}")
    @RequestFilters(value={EncodeDotsForUserGet.class})
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public User get(@PathParam(value="name") String var1);

    @Named(value="user:get/{name}@{hostname}")
    @GET
    @Path(value="/users/{name}@{hostname}")
    @RequestFilters(value={EncodeDotsForUserGet.class})
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public User get(@PathParam(value="name") String var1, @PathParam(value="hostname") String var2);
}

