/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gram.CallbackHandler;
import org.globus.gram.GramJob;
import org.globus.gram.internal.CallbackResponse;
import org.globus.gram.internal.GRAMProtocol;
import org.globus.gsi.gssapi.auth.AuthorizationException;

class GramCallbackHandler
implements Runnable {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$gram$GramCallbackHandler == null ? (class$org$globus$gram$GramCallbackHandler = GramCallbackHandler.class$("org.globus.gram.GramCallbackHandler")) : class$org$globus$gram$GramCallbackHandler).getName());
    private CallbackHandler handler;
    private Socket socket;
    static /* synthetic */ Class class$org$globus$gram$GramCallbackHandler;

    public GramCallbackHandler(CallbackHandler handler, Socket socket) {
        this.handler = handler;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            try {
                CallbackResponse hd = new CallbackResponse(this.socket.getInputStream());
                if (hd.protocolVersion != 2) {
                    throw new Exception("Gram callback protocol version mismatch");
                }
                GramJob job = this.handler.getJob(hd.jobManagerUrl);
                if (job == null) {
                    throw new Exception("Not registered with this handler: " + hd.jobManagerUrl);
                }
                job.setError(hd.failureCode);
                job.setStatus(hd.status);
                if (job.getStatus() == 8 || job.getStatus() == 4) {
                    this.handler.unregisterJob(job);
                }
                try {
                    out.write(GRAMProtocol.OKReply());
                    out.flush();
                }
                catch (IOException ignoreE) {
                    logger.debug((Object)"Ignoring IOException");
                }
            }
            catch (AuthorizationException ex) {
                logger.debug((Object)"Authorization failed", (Throwable)ex);
                out.write(GRAMProtocol.ErrorReply(401, "Authorization Failed"));
                out.flush();
            }
            catch (Exception ex) {
                logger.debug((Object)"General error", (Throwable)ex);
                out.write(GRAMProtocol.ErrorReply(400, ex.getMessage()));
                out.flush();
            }
        }
        catch (IOException e) {
            logger.debug((Object)"IO Error", (Throwable)e);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

