/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.DefaultWildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.JarWildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.StringUtils;

public class ClasspathUriLocator
extends WildcardUriLocatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathUriLocator.class);
    public static final String ALIAS = "classpath";
    public static final String PREFIX = String.format("%s:", "classpath");

    public static String createUri(String path) {
        Validate.notNull((Object)path);
        return PREFIX + path;
    }

    public boolean accept(String url) {
        return ClasspathUriLocator.isValid(url);
    }

    public static boolean isValid(String uri) {
        return uri.trim().startsWith(PREFIX);
    }

    public InputStream locate(String uri) throws IOException {
        InputStream is;
        String location;
        block4: {
            Validate.notNull((Object)uri, (String)"URI cannot be NULL!", (Object[])new Object[0]);
            location = StringUtils.cleanPath(uri.replaceFirst(PREFIX, "")).trim();
            if (this.getWildcardStreamLocator().hasWildcard(location)) {
                try {
                    return this.locateWildcardStream(uri, location);
                }
                catch (IOException e) {
                    if (!location.contains("?")) break block4;
                    location = DefaultWildcardStreamLocator.stripQueryPath(location);
                    LOG.debug("Trying fallback location: {}", (Object)location);
                }
            }
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location)) == null) {
            throw new IOException("Couldn't get InputStream from this resource: " + uri);
        }
        return is;
    }

    private InputStream locateWildcardStream(String uri, String location) throws IOException {
        LOG.debug("wildcard detected for location: {}", (Object)location);
        String fullPath = "/" + FilenameUtils.getFullPathNoEndSeparator((String)location);
        URL url = this.getClass().getResource(fullPath);
        LOG.debug("Attempting to find resource {} at the following location: {}", (Object)uri, (Object)fullPath);
        try {
            return this.locateWildcardStream(uri, url);
        }
        catch (IOException e) {
            if (e instanceof WildcardExpanderModelTransformer.NoMoreAttemptsIOException) {
                throw e;
            }
            url = this.getClass().getResource("");
            LOG.debug("Attempting to find resource {} at the following URL: {}", (Object)uri, (Object)url);
            return this.locateWildcardStream(uri, url);
        }
    }

    private InputStream locateWildcardStream(String uri, URL url) throws IOException {
        if (url == null) {
            LOG.debug("Failed to locate stream for {} because URL is null", (Object)uri);
            throw new IOException("Cannot locate stream for null URL");
        }
        return this.getWildcardStreamLocator().locateStream(uri, new File(URLDecoder.decode(url.getFile(), "UTF-8")));
    }

    public WildcardStreamLocator newWildcardStreamLocator() {
        return new JarWildcardStreamLocator(){

            public boolean hasWildcard(String uri) {
                return ClasspathUriLocator.this.isEnableWildcards() && super.hasWildcard(uri);
            }
        };
    }
}

