/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.decorator.DefaultProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;

public class GroupsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsProcessor.class);
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private ProcessorsFactory processorsFactory;
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private Injector injector;
    @Inject
    private transient PreProcessorExecutor preProcessorExecutor;

    public String process(CacheKey cacheKey) {
        Validate.notNull((Object)cacheKey);
        try {
            LOG.debug("Starting processing group [{}] of type [{}] with minimized flag: " + cacheKey.isMinimize(), (Object)cacheKey.getGroupName(), (Object)cacheKey.getType());
            WroModel model = (WroModel)this.modelFactory.create();
            Group group = new WroModelInspector(model).getGroupByName(cacheKey.getGroupName());
            if (group == null) {
                throw new WroRuntimeException("No such group available in the model: " + cacheKey.getGroupName());
            }
            Group filteredGroup = group.collectResourcesOfType(cacheKey.getType());
            if (filteredGroup.getResources().isEmpty()) {
                LOG.debug("No resources found in group: {} and resource type: {}", (Object)group.getName(), (Object)cacheKey.getType());
                if (!this.context.getConfig().isIgnoreEmptyGroup()) {
                    throw new WroRuntimeException("No resources found in group: " + group.getName());
                }
            }
            String result = this.preProcessorExecutor.processAndMerge(filteredGroup.getResources(), cacheKey.isMinimize());
            String string = this.applyPostProcessors(cacheKey, result);
            return string;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while merging resources: " + e.getMessage(), e).logError();
        }
        finally {
            this.callbackRegistry.onProcessingComplete();
        }
    }

    private String applyPostProcessors(CacheKey cacheKey, String content) throws IOException {
        Collection<ResourcePostProcessor> processors = this.processorsFactory.getPostProcessors();
        LOG.debug("appying post processors: {}", processors);
        if (processors.isEmpty()) {
            return content;
        }
        Resource resource = Resource.create(cacheKey.getGroupName(), cacheKey.getType());
        StringReader reader = new StringReader(content.toString());
        Object writer = null;
        for (ResourcePostProcessor processor : processors) {
            ProcessorDecorator decoratedProcessor = this.decorateProcessor(processor, cacheKey.isMinimize());
            writer = new StringWriter();
            decoratedProcessor.process(resource, reader, (Writer)writer);
            reader = new StringReader(writer.toString());
        }
        return writer.toString();
    }

    private synchronized ProcessorDecorator decorateProcessor(ResourcePostProcessor processor, boolean minimize) {
        DefaultProcessorDecorator decorated = new DefaultProcessorDecorator(processor, minimize){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                try {
                    GroupsProcessor.this.callbackRegistry.onBeforePostProcess();
                    super.process(resource, reader, writer);
                }
                finally {
                    GroupsProcessor.this.callbackRegistry.onAfterPostProcess();
                }
            }
        };
        this.injector.inject(decorated);
        return decorated;
    }

    final void setPreProcessorExecutor(PreProcessorExecutor preProcessorExecutor) {
        this.preProcessorExecutor = preProcessorExecutor;
    }

    public void destroy() {
        this.preProcessorExecutor.destroy();
    }
}

