/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.util.Arrays;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;

public class SqlJetBtreeCursor
extends SqlJetCloneable
implements ISqlJetBtreeCursor {
    private static final int NN = 1;
    private static final int NB = 3;
    SqlJetBtree pBtree;
    SqlJetBtreeShared pBt;
    SqlJetBtreeCursor pNext;
    SqlJetBtreeCursor pPrev;
    ISqlJetKeyInfo pKeyInfo;
    int pgnoRoot;
    SqlJetBtreeCellInfo info = new SqlJetBtreeCellInfo();
    boolean wrFlag;
    boolean atLast;
    boolean validNKey;
    CursorState eState;
    ISqlJetMemoryPointer pKey;
    long nKey;
    SqlJetErrorCode error;
    int skip;
    boolean isIncrblobHandle;
    int[] aOverflow;
    boolean pagesShuffled;
    int iPage;
    SqlJetMemPage[] apPage = new SqlJetMemPage[20];
    int[] aiIdx = new int[20];

    public SqlJetBtreeCursor(SqlJetBtree btree, int table, boolean wrFlag, ISqlJetKeyInfo keyInfo) throws SqlJetException {
        SqlJetBtreeShared pBt = btree.pBt;
        assert (btree.holdsMutex());
        if (wrFlag) {
            assert (!pBt.readOnly);
            if (pBt.readOnly) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            if (btree.checkReadLocks(table, null, 0L)) {
                throw new SqlJetException(SqlJetErrorCode.LOCKED);
            }
        }
        if (pBt.pPage1 == null) {
            btree.lockWithRetry();
        }
        this.pgnoRoot = table;
        int nPage = pBt.pPager.getPageCount();
        try {
            if (table == 1 && nPage == 0) {
                throw new SqlJetException(SqlJetErrorCode.EMPTY);
            }
            this.apPage[0] = pBt.getAndInitPage(this.pgnoRoot);
            this.pKeyInfo = keyInfo;
            this.pBtree = btree;
            this.pBt = pBt;
            this.wrFlag = wrFlag;
            this.pNext = pBt.pCursor;
            if (this.pNext != null) {
                this.pNext.pPrev = this;
            }
            pBt.pCursor = this;
            this.eState = CursorState.INVALID;
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(this.apPage[0]);
            pBt.unlockBtreeIfUnused();
            throw e;
        }
    }

    private boolean holdsMutex() {
        return this.pBt.mutex.held();
    }

    private boolean cursorHoldsMutex(SqlJetBtreeCursor cur) {
        return cur.holdsMutex();
    }

    public void clearCursor() {
        assert (this.holdsMutex());
        this.pKey = null;
        this.eState = CursorState.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor() throws SqlJetException {
        if (this.pBtree != null) {
            this.pBtree.enter();
            try {
                this.pBt.db = this.pBtree.db;
                this.clearCursor();
                if (this.pPrev != null) {
                    this.pPrev.pNext = this.pNext;
                } else {
                    this.pBt.pCursor = this.pNext;
                }
                if (this.pNext != null) {
                    this.pNext.pPrev = this.pPrev;
                }
                for (int i = 0; i <= this.iPage; ++i) {
                    SqlJetMemPage.releasePage(this.apPage[i]);
                }
                this.pBt.unlockBtreeIfUnused();
                this.invalidateOverflowCache();
            }
            finally {
                SqlJetBtree p = this.pBtree;
                this.pBtree = null;
                p.leave();
            }
        }
    }

    private void invalidateOverflowCache() {
        assert (this.holdsMutex());
        this.aOverflow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveTo(ISqlJetMemoryPointer pKey, long nKey, boolean bias) throws SqlJetException {
        SqlJetUnpackedRecord pIdxKey;
        if (pKey != null) {
            assert (nKey == (long)((int)nKey));
            pIdxKey = this.pKeyInfo.recordUnpack((int)nKey, pKey);
            if (pIdxKey == null) {
                throw new SqlJetException(SqlJetErrorCode.NOMEM);
            }
        } else {
            pIdxKey = null;
        }
        try {
            int n = this.moveToUnpacked(pIdxKey, nKey, bias);
            return n;
        }
        finally {
            if (pKey != null) {
                SqlJetUnpackedRecord.delete(pIdxKey);
            }
        }
    }

    private void moveToRoot() throws SqlJetException {
        assert (this.holdsMutex());
        assert (CursorState.INVALID.compareTo(CursorState.REQUIRESEEK) < 0);
        assert (CursorState.VALID.compareTo(CursorState.REQUIRESEEK) < 0);
        assert (CursorState.FAULT.compareTo(CursorState.REQUIRESEEK) > 0);
        if (this.eState.compareTo(CursorState.REQUIRESEEK) >= 0) {
            if (this.eState == CursorState.FAULT) {
                throw new SqlJetException(this.error);
            }
            this.clearCursor();
        }
        if (this.iPage >= 0) {
            for (int i = 1; i <= this.iPage; ++i) {
                SqlJetMemPage.releasePage(this.apPage[i]);
            }
        } else {
            try {
                this.apPage[0] = this.pBt.getAndInitPage(this.pgnoRoot);
            }
            catch (SqlJetException e) {
                this.eState = CursorState.INVALID;
                throw e;
            }
        }
        SqlJetMemPage pRoot = this.apPage[0];
        assert (pRoot.pgno == this.pgnoRoot);
        this.iPage = 0;
        this.aiIdx[0] = 0;
        this.info.nSize = 0;
        this.atLast = false;
        this.validNKey = false;
        if (pRoot.nCell == 0 && !pRoot.leaf) {
            assert (pRoot.pgno == 1);
            int subpage = SqlJetUtility.get4byte(pRoot.aData, pRoot.hdrOffset + 8);
            assert (subpage > 0);
            this.eState = CursorState.VALID;
            this.moveToChild(subpage);
        } else {
            this.eState = pRoot.nCell > 0 ? CursorState.VALID : CursorState.INVALID;
        }
    }

    private void moveToChild(int newPgno) throws SqlJetException {
        SqlJetMemPage pNewPage;
        int i = this.iPage;
        assert (this.holdsMutex());
        assert (this.eState == CursorState.VALID);
        assert (this.iPage < 20);
        if (this.iPage >= 19) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.apPage[i + 1] = pNewPage = this.pBt.getAndInitPage(newPgno);
        this.aiIdx[i + 1] = 0;
        ++this.iPage;
        this.info.nSize = 0;
        this.validNKey = false;
        if (pNewPage.nCell < 1) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void getCellInfo() {
        if (this.info.nSize == 0) {
            this.info = this.apPage[this.iPage].parseCell(this.aiIdx[this.iPage]);
            this.validNKey = true;
        }
    }

    private ISqlJetMemoryPointer fetchPayload(int[] pAmt, boolean skipKey) {
        int nLocal;
        assert (this.iPage >= 0 && this.apPage[this.iPage] != null);
        assert (this.eState == CursorState.VALID);
        assert (this.holdsMutex());
        SqlJetMemPage pPage = this.apPage[this.iPage];
        assert (this.aiIdx[this.iPage] < pPage.nCell);
        this.getCellInfo();
        ISqlJetMemoryPointer aPayload = SqlJetUtility.pointer(this.info.pCell, this.info.nHeader);
        int nKey = pPage.intKey ? 0 : (int)this.info.nKey;
        if (skipKey) {
            SqlJetUtility.movePtr(aPayload, nKey);
            nLocal = this.info.nLocal - nKey;
        } else {
            nLocal = this.info.nLocal;
            if (nLocal > nKey) {
                nLocal = nKey;
            }
        }
        pAmt[0] = nLocal;
        return aPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveToUnpacked(ISqlJetUnpackedRecord pIdxKey, long intKey, boolean biasRight) throws SqlJetException {
        assert (this.holdsMutex());
        assert (this.pBtree.db.getMutex().held());
        if (this.eState == CursorState.VALID && this.validNKey && this.apPage[0].intKey) {
            if (this.info.nKey == intKey) {
                return 0;
            }
            if (this.atLast && this.info.nKey < intKey) {
                return -1;
            }
        }
        this.moveToRoot();
        assert (this.apPage[this.iPage] != null);
        assert (this.apPage[this.iPage].isInit);
        if (this.eState == CursorState.INVALID) {
            assert (this.apPage[this.iPage].nCell == 0);
            return -1;
        }
        assert (this.apPage[0].intKey || pIdxKey != null);
        while (true) {
            SqlJetMemPage pPage = this.apPage[this.iPage];
            int c = -1;
            int lwr = 0;
            int upr = pPage.nCell - 1;
            if (!pPage.intKey && pIdxKey == null || upr < 0) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.aiIdx[this.iPage] = biasRight ? upr : (upr + lwr) / 2;
            while (true) {
                long[] nCellKey = new long[1];
                int idx = this.aiIdx[this.iPage];
                this.info.nSize = 0;
                this.validNKey = true;
                if (pPage.intKey) {
                    ISqlJetMemoryPointer pCell = SqlJetUtility.pointer(pPage.findCell(idx), pPage.childPtrSize);
                    if (pPage.hasData) {
                        int[] dummy = new int[1];
                        SqlJetUtility.movePtr(pCell, SqlJetUtility.getVarint32(pCell, dummy));
                    }
                    SqlJetUtility.getVarint(pCell, nCellKey);
                    if (nCellKey[0] == intKey) {
                        c = 0;
                    } else if (nCellKey[0] < intKey) {
                        c = -1;
                    } else {
                        assert (nCellKey[0] > intKey);
                        c = 1;
                    }
                } else {
                    int[] available = new int[1];
                    ISqlJetMemoryPointer pCellKey = this.fetchPayload(available, false);
                    nCellKey[0] = this.info.nKey;
                    if ((long)available[0] >= nCellKey[0]) {
                        c = pIdxKey.recordCompare((int)nCellKey[0], pCellKey);
                    } else {
                        pCellKey = SqlJetUtility.allocatePtr((int)nCellKey[0]);
                        try {
                            this.key(0, (int)nCellKey[0], pCellKey);
                        }
                        finally {
                            c = pIdxKey.recordCompare((int)nCellKey[0], pCellKey);
                        }
                    }
                }
                if (c == 0) {
                    this.info.nKey = nCellKey[0];
                    if (pPage.intKey && !pPage.leaf) {
                        lwr = idx;
                        upr = lwr - 1;
                        break;
                    }
                    return 0;
                }
                if (c < 0) {
                    lwr = idx + 1;
                } else {
                    upr = idx - 1;
                }
                if (lwr > upr) {
                    this.info.nKey = nCellKey[0];
                    break;
                }
                this.aiIdx[this.iPage] = (lwr + upr) / 2;
            }
            assert (lwr == upr + 1);
            assert (pPage.isInit);
            int chldPg = pPage.leaf ? 0 : (lwr >= pPage.nCell ? SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8) : SqlJetUtility.get4byte(pPage.findCell(lwr)));
            if (chldPg == 0) {
                assert (this.aiIdx[this.iPage] < this.apPage[this.iPage].nCell);
                return c;
            }
            this.aiIdx[this.iPage] = lwr;
            this.info.nSize = 0;
            this.validNKey = false;
            this.moveToChild(chldPg);
        }
    }

    public void restoreCursorPosition() throws SqlJetException {
        if (this.eState.compareTo(CursorState.REQUIRESEEK) < 0) {
            return;
        }
        assert (this.holdsMutex());
        if (this.eState == CursorState.FAULT) {
            throw new SqlJetException(this.error);
        }
        this.eState = CursorState.INVALID;
        this.skip = this.moveTo(this.pKey, this.nKey, false);
        this.pKey = null;
        assert (this.eState == CursorState.VALID || this.eState == CursorState.INVALID);
    }

    public boolean cursorHasMoved() {
        try {
            this.restoreCursorPosition();
        }
        catch (SqlJetException e) {
            return true;
        }
        return this.eState != CursorState.VALID || this.skip != 0;
    }

    public void delete() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetBtree p = pCur.pBtree;
        SqlJetBtreeShared pBt = p.pBt;
        assert (pCur.holdsMutex());
        assert (pBt.inTransaction == SqlJetBtree.TransMode.WRITE);
        assert (!pBt.readOnly);
        assert (pCur.wrFlag);
        if (pCur.aiIdx[pCur.iPage] >= pCur.apPage[pCur.iPage].nCell || pCur.eState != CursorState.VALID) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        int iCellDepth = pCur.iPage;
        int iCellIdx = pCur.aiIdx[iCellDepth];
        SqlJetMemPage pPage = pCur.apPage[iCellDepth];
        ISqlJetMemoryPointer pCell = pPage.findCell(iCellIdx);
        if (!pPage.leaf) {
            pCur.previous();
        }
        pBt.saveAllCursors(pCur.pgnoRoot, pCur);
        pPage.pDbPage.write();
        pPage.clearCell(pCell);
        pPage.dropCell(iCellIdx, pPage.cellSizePtr(pCell));
        if (!pPage.leaf) {
            SqlJetMemPage pLeaf = pCur.apPage[pCur.iPage];
            int n = pCur.apPage[iCellDepth + 1].pgno;
            pCell = pLeaf.findCell(pLeaf.nCell - 1);
            int nCell = pLeaf.cellSizePtr(pCell);
            assert (pBt.MX_CELL_SIZE() >= nCell);
            pBt.allocateTempSpace();
            ISqlJetMemoryPointer pTmp = pBt.pTmpSpace;
            pLeaf.pDbPage.write();
            pPage.insertCell(iCellIdx, pCell.getMoved(-4), nCell + 4, pTmp, n);
            pLeaf.dropCell(pLeaf.nCell - 1, nCell);
        }
        pCur.balance(false);
        if (pCur.iPage > iCellDepth) {
            while (pCur.iPage > iCellDepth) {
                SqlJetMemPage.releasePage(pCur.apPage[pCur.iPage--]);
            }
            pCur.balance(false);
        }
        pCur.moveToRoot();
    }

    private void balance(boolean isInsert) throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        int nMin = pCur.pBt.usableSize * 2 / 3;
        ISqlJetMemoryPointer aBalanceQuickSpace = SqlJetUtility.allocatePtr(13);
        int balance_quick_called = 0;
        int balance_deeper_called = 0;
        while (true) {
            int iPage = --pCur.iPage;
            SqlJetMemPage pPage = pCur.apPage[iPage];
            if (iPage == 0) {
                if (pPage.nOverflow <= 0) break;
                assert (balance_deeper_called++ == 0);
                pCur.apPage[1] = this.balance_deeper(pPage);
                pCur.iPage = 1;
                pCur.aiIdx[0] = 0;
                pCur.aiIdx[1] = 0;
                assert (pCur.apPage[1].nOverflow > 0);
                continue;
            }
            if (pPage.nOverflow == 0 && pPage.nFree <= nMin) break;
            SqlJetMemPage pParent = pCur.apPage[iPage - 1];
            int iIdx = pCur.aiIdx[iPage - 1];
            pParent.pDbPage.write();
            if (pPage.hasData && pPage.nOverflow == 1 && pPage.aOvfl[0].idx == pPage.nCell && pParent.pgno != 1 && pParent.nCell == iIdx) {
                assert (balance_quick_called++ == 0);
                this.balance_quick(pParent, pPage, aBalanceQuickSpace);
            } else {
                ISqlJetMemoryPointer pSpace = SqlJetUtility.allocatePtr(pCur.pBt.pageSize);
                this.balance_nonroot(pParent, iIdx, pSpace, iPage == 1);
            }
            pPage.nOverflow = 0;
            SqlJetMemPage.releasePage(pPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balance_nonroot(SqlJetMemPage pParent, int iParentIdx, ISqlJetMemoryPointer aOvflSpace, boolean isRoot) throws SqlJetException {
        int i;
        int nCell = 0;
        int nMaxCells = 0;
        int nNew = 0;
        int nOld = 0;
        int iSpace1 = 0;
        int iOvflSpace = 0;
        Object[] apOld = new SqlJetMemPage[3];
        SqlJetMemPage[] apCopy = new SqlJetMemPage[3];
        SqlJetMemPage[] apNew = new SqlJetMemPage[5];
        ISqlJetMemoryPointer[] apDiv = new ISqlJetMemoryPointer[2];
        int[] cntNew = new int[5];
        int[] szNew = new int[5];
        SqlJetBtreeShared pBt = pParent.pBt;
        assert (SqlJetUtility.mutex_held(pBt.mutex));
        assert (pParent.pDbPage.isWriteable());
        assert (pParent.nOverflow == 0 || pParent.nOverflow == 1);
        assert (pParent.nOverflow == 0 || pParent.aOvfl[0].idx == iParentIdx);
        if (aOvflSpace == null) {
            throw new SqlJetException(SqlJetErrorCode.NOMEM);
        }
        try {
            int j;
            int nxDiv;
            i = pParent.nOverflow + pParent.nCell;
            if (i < 2) {
                nxDiv = 0;
                nOld = i + 1;
            } else {
                nOld = 3;
                nxDiv = iParentIdx == 0 ? 0 : (iParentIdx == i ? i - 2 : iParentIdx - 1);
                i = 2;
            }
            ISqlJetMemoryPointer pRight = i + nxDiv - pParent.nOverflow == pParent.nCell ? pParent.aData.getMoved(pParent.hdrOffset + 8) : pParent.findCell(i + nxDiv - pParent.nOverflow);
            int pgno = SqlJetUtility.get4byte(pRight);
            while (true) {
                apOld[i] = pBt.getAndInitPage(pgno);
                nMaxCells += 1 + apOld[i].nCell + apOld[i].nOverflow;
                if (i-- == 0) break;
                if (i + nxDiv == pParent.aOvfl[0].idx && pParent.nOverflow > 0) {
                    apDiv[i] = pParent.aOvfl[0].pCell;
                    pgno = SqlJetUtility.get4byte(apDiv[i]);
                    szNew[i] = pParent.cellSizePtr(apDiv[i]);
                    pParent.nOverflow = 0;
                    continue;
                }
                apDiv[i] = pParent.findCell(i + nxDiv - pParent.nOverflow);
                pgno = SqlJetUtility.get4byte(apDiv[i]);
                szNew[i] = pParent.cellSizePtr(apDiv[i]);
                if (ISqlJetConfig.SECURE_DELETE) {
                    int iOff = apDiv[i].getPointer() - pParent.aData.getPointer();
                    if (iOff + szNew[i] > pBt.usableSize) {
                        Arrays.fill(apOld, 0, i, null);
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                    SqlJetUtility.memcpy(aOvflSpace.getMoved(iOff), apDiv[i], szNew[i]);
                    apDiv[i] = aOvflSpace.getMoved(apDiv[i].getPointer() - pParent.aData.getPointer());
                }
                try {
                    pParent.dropCell(i + nxDiv - pParent.nOverflow, szNew[i]);
                }
                catch (SqlJetException e) {
                    SqlJetBtree.TRACE("exception in dropCell call: %s", e.getMessage());
                }
            }
            nMaxCells = nMaxCells + 3 & 0xFFFFFFFC;
            ISqlJetMemoryPointer[] apCell = new SqlJetMemoryPointer[nMaxCells];
            int[] szCell = new int[nMaxCells];
            int leafCorrection = apOld[0].leaf ? 4 : 0;
            boolean leafData = apOld[0].hasData;
            for (i = 0; i < nOld; ++i) {
                SqlJetMemPage pOld = apCopy[i] = SqlJetUtility.memcpy(apOld[i]);
                pOld.aData.copyFrom(apOld[i].aData, pBt.pageSize);
                int limit = pOld.nCell + pOld.nOverflow;
                if (pOld.nOverflow > 0) {
                    for (j = 0; j < limit; ++j) {
                        assert (nCell < nMaxCells);
                        apCell[nCell] = pOld.findOverflowCell(j);
                        szCell[nCell] = pOld.cellSizePtr(apCell[nCell]);
                        ++nCell;
                    }
                } else {
                    ISqlJetMemoryPointer aData = pOld.aData;
                    int maskPage = pOld.maskPage;
                    int cellOffset = pOld.cellOffset;
                    for (j = 0; j < limit; ++j) {
                        assert (nCell < nMaxCells);
                        apCell[nCell] = this.findCellv2(aData, maskPage, cellOffset, j);
                        szCell[nCell] = pOld.cellSizePtr(apCell[nCell]);
                        ++nCell;
                    }
                }
                if (i >= nOld - 1 || leafData) continue;
                int sz = szNew[i];
                assert (nCell < nMaxCells);
                szCell[nCell] = sz;
                ISqlJetMemoryPointer pTemp = SqlJetUtility.allocatePtr(sz);
                iSpace1 += sz;
                assert (sz <= pBt.maxLocal + 23);
                assert (iSpace1 <= pBt.pageSize);
                SqlJetUtility.memcpy(pTemp, apDiv[i], sz);
                apCell[nCell] = pTemp.getMoved(leafCorrection);
                assert (leafCorrection == 0 || leafCorrection == 4);
                szCell[nCell] = szCell[nCell] - leafCorrection;
                if (!pOld.leaf) {
                    assert (leafCorrection == 0);
                    assert (pOld.hdrOffset == 0);
                    SqlJetUtility.memcpy(apCell[nCell], pOld.aData.getMoved(8), 4);
                } else {
                    assert (leafCorrection == 4);
                    if (szCell[nCell] < 4) {
                        szCell[nCell] = 4;
                    }
                }
                ++nCell;
            }
            int usableSpace = pBt.usableSize - 12 + leafCorrection;
            int k = 0;
            int subtotal = 0;
            for (i = 0; i < nCell; ++i) {
                assert (i < nMaxCells);
                if ((subtotal += szCell[i] + 2) <= usableSpace) continue;
                szNew[k] = subtotal - szCell[i];
                cntNew[k] = i--;
                if (leafData) {
                    // empty if block
                }
                subtotal = 0;
                if (++k <= 4) continue;
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            szNew[k] = subtotal;
            cntNew[k] = nCell;
            for (i = ++k - 1; i > 0; --i) {
                int szRight = szNew[i];
                int szLeft = szNew[i - 1];
                int r = cntNew[i - 1] - 1;
                int d = r + 1 - (leafData ? 1 : 0);
                assert (d < nMaxCells);
                assert (r < nMaxCells);
                while (szRight == 0 || szRight + szCell[d] + 2 <= szLeft - (szCell[r] + 2)) {
                    szRight += szCell[d] + 2;
                    szLeft -= szCell[r] + 2;
                    int n = i - 1;
                    cntNew[n] = cntNew[n] - 1;
                    r = cntNew[i - 1] - 1;
                    d = r + 1 - (leafData ? 1 : 0);
                }
                szNew[i] = szRight;
                szNew[i - 1] = szLeft;
            }
            assert (cntNew[0] > 0 || pParent.pgno == 1 && pParent.nCell == 0);
            SqlJetBtree.TRACE("BALANCE: old: %d %d %d  ", ((SqlJetMemPage)apOld[0]).pgno, nOld >= 2 ? ((SqlJetMemPage)apOld[1]).pgno : 0, nOld >= 3 ? ((SqlJetMemPage)apOld[2]).pgno : 0);
            if (((SqlJetMemPage)apOld[0]).pgno <= 1) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            int pageFlags = ((SqlJetMemPage)apOld[0]).aData.getByteUnsigned(0);
            for (i = 0; i < k; ++i) {
                Object pNew;
                if (i < nOld) {
                    pNew = apNew[i] = apOld[i];
                    apOld[i] = null;
                    ++nNew;
                    ((SqlJetMemPage)pNew).pDbPage.write();
                    continue;
                }
                assert (i > 0);
                int[] p = new int[]{0};
                pNew = pBt.allocatePage(p, pgno, false);
                pgno = p[0];
                apNew[i] = pNew;
                ++nNew;
                if (!pBt.autoVacuum) continue;
                pBt.ptrmapPut(((SqlJetMemPage)pNew).pgno, (short)5, pParent.pgno);
            }
            while (i < nOld) {
                ((SqlJetMemPage)apOld[i]).freePage();
                SqlJetMemPage.releasePage((SqlJetMemPage)apOld[i]);
                apOld[i] = null;
                ++i;
            }
            for (i = 0; i < k - 1; ++i) {
                int minV = apNew[i].pgno;
                int minI = i;
                for (j = i + 1; j < k; ++j) {
                    if (apNew[j].pgno >= minV) continue;
                    minI = j;
                    minV = apNew[j].pgno;
                }
                if (minI <= i) continue;
                SqlJetMemPage pT = apNew[i];
                apNew[i] = apNew[minI];
                apNew[minI] = pT;
            }
            SqlJetBtree.TRACE("new: %d(%d) %d(%d) %d(%d) %d(%d) %d(%d)\n", apNew[0].pgno, szNew[0], nNew >= 2 ? apNew[1].pgno : 0, nNew >= 2 ? szNew[1] : 0, nNew >= 3 ? apNew[2].pgno : 0, nNew >= 3 ? szNew[2] : 0, nNew >= 4 ? apNew[3].pgno : 0, nNew >= 4 ? szNew[3] : 0, nNew >= 5 ? apNew[4].pgno : 0, nNew >= 5 ? szNew[4] : 0);
            assert (pParent.pDbPage.isWriteable());
            SqlJetUtility.put4byte(pRight, apNew[nNew - 1].pgno);
            j = 0;
            for (i = 0; i < nNew; ++i) {
                SqlJetMemPage pNew = apNew[i];
                assert (j < nMaxCells);
                pNew.zeroPage(pageFlags);
                pNew.assemblePage(cntNew[i] - j, apCell, j, szCell, j);
                assert (pNew.nCell > 0 || nNew == 1 && cntNew[0] == 0);
                assert (pNew.nOverflow == 0);
                j = cntNew[i];
                assert (i < nNew - 1 || j == nCell);
                if (j >= nCell) continue;
                assert (j < nMaxCells);
                ISqlJetMemoryPointer pCell = apCell[j];
                int sz = szCell[j] + leafCorrection;
                ISqlJetMemoryPointer pTemp = aOvflSpace.getMoved(iOvflSpace);
                if (!pNew.leaf) {
                    SqlJetUtility.memcpy(pNew.aData.getMoved(8), pCell, 4);
                } else if (leafData) {
                    SqlJetBtreeCellInfo info = pNew.parseCellPtr(apCell[--j]);
                    pCell = pTemp;
                    sz = 4 + SqlJetUtility.putVarint(pCell.getMoved(4), info.nKey);
                    SqlJetUtility.put4byte(pCell, pNew.pgno);
                    pTemp = null;
                } else {
                    pCell = SqlJetUtility.getMoved(j > 0 ? apCell[j - 1] : null, pCell, -4);
                    if (szCell[j] == 4) {
                        assert (leafCorrection == 4);
                        sz = pParent.cellSizePtr(pCell);
                    }
                }
                iOvflSpace += sz;
                assert (sz <= pBt.maxLocal + 23);
                assert (iOvflSpace <= pBt.pageSize);
                pParent.insertCell(nxDiv, pCell, sz, pTemp, pNew.pgno);
                assert (pParent.pDbPage.isWriteable());
                ++j;
                ++nxDiv;
            }
            assert (j == nCell);
            assert (nOld > 0);
            assert (nNew > 0);
            if ((pageFlags & 8) == 0) {
                ISqlJetMemoryPointer zChild = apCopy[nOld - 1].aData.getMoved(8);
                SqlJetUtility.memcpy(apNew[nNew - 1].aData.getMoved(8), zChild, 4);
            }
            if (isRoot && pParent.nCell == 0 && pParent.hdrOffset <= apNew[0].nFree) {
                assert (nNew == 1);
                assert (apNew[0].nFree == SqlJetUtility.get2byte(apNew[0].aData.getMoved(5)) - apNew[0].cellOffset - apNew[0].nCell * 2);
                apNew[0].copyNodeContent(pParent);
                apNew[0].freePage();
            } else if (pBt.autoVacuum) {
                SqlJetMemPage pNew = apNew[0];
                SqlJetMemPage pOld = apCopy[0];
                int nOverflow = pOld.nOverflow;
                int iNextOld = pOld.nCell + nOverflow;
                int iOverflow = nOverflow > 0 ? pOld.aOvfl[0].idx : -1;
                j = 0;
                k = 0;
                boolean isDivider = false;
                for (i = 0; i < nCell; ++i) {
                    while (i == iNextOld) {
                        assert (j + 1 < apCopy.length);
                        pOld = apCopy[++j];
                        iNextOld = i + (!leafData ? 1 : 0) + pOld.nCell + pOld.nOverflow;
                        if (pOld.nOverflow > 0) {
                            nOverflow = pOld.nOverflow;
                            iOverflow = i + (!leafData ? 1 : 0) + pOld.aOvfl[0].idx;
                        }
                        isDivider = !leafData;
                    }
                    assert (nOverflow > 0 || iOverflow < i);
                    assert (nOverflow < 2 || pOld.aOvfl[0].idx == pOld.aOvfl[1].idx - 1);
                    assert (nOverflow < 3 || pOld.aOvfl[1].idx == pOld.aOvfl[2].idx - 1);
                    if (i == iOverflow) {
                        isDivider = true;
                        if (--nOverflow > 0) {
                            ++iOverflow;
                        }
                    }
                    if (i == cntNew[k]) {
                        pNew = apNew[++k];
                        if (!leafData) continue;
                    }
                    assert (j < nOld);
                    assert (k < nNew);
                    if (!isDivider && pOld.pgno == pNew.pgno) continue;
                    if (leafCorrection <= 0) {
                        pBt.ptrmapPut(SqlJetUtility.get4byte(apCell[i]), (short)5, pNew.pgno);
                    }
                    if (szCell[i] <= pNew.minLocal) continue;
                    pBt.ptrmapPutOvflPtr(pNew, apCell[i]);
                }
                if (leafCorrection <= 0) {
                    for (i = 0; i < nNew; ++i) {
                        int key = SqlJetUtility.get4byte(apNew[i].aData.getMoved(8));
                        pBt.ptrmapPut(key, (short)5, apNew[i].pgno);
                    }
                }
            }
            assert (pParent.isInit);
            SqlJetBtree.TRACE("BALANCE: finished: old=%d new=%d cells=%d\n", nOld, nNew, nCell);
        }
        finally {
            for (i = 0; i < nOld; ++i) {
                SqlJetMemPage.releasePage((SqlJetMemPage)apOld[i]);
            }
            for (i = 0; i < nNew; ++i) {
                SqlJetMemPage.releasePage(apNew[i]);
            }
        }
    }

    private ISqlJetMemoryPointer findCellv2(ISqlJetMemoryPointer D, int M, int O, int I) {
        return D.getMoved(M & SqlJetUtility.get2byte(D.getMoved(O + 2 * I)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balance_quick(SqlJetMemPage pParent, SqlJetMemPage pPage, ISqlJetMemoryPointer pSpace) throws SqlJetException {
        SqlJetBtreeShared pBt = pPage.pBt;
        int[] pgnoNew = new int[]{0};
        assert (SqlJetUtility.mutex_held(pPage.pBt.mutex));
        assert (pParent.pDbPage.isWriteable());
        assert (pPage.nOverflow == 1);
        if (pPage.nCell <= 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        SqlJetMemPage pNew = pBt.allocatePage(pgnoNew, 0, false);
        try {
            boolean b;
            ISqlJetMemoryPointer pOut = pSpace.getMoved(4);
            ISqlJetMemoryPointer pCell = pPage.aOvfl[0].pCell;
            int szCell = pPage.cellSizePtr(pCell);
            assert (pNew.pDbPage.isWriteable());
            assert (pPage.aData.getByteUnsigned(0) == 13);
            pNew.zeroPage(13);
            pNew.assemblePage(1, new ISqlJetMemoryPointer[]{pCell}, 0, new int[]{szCell}, 0);
            if (pBt.autoVacuum) {
                pBt.ptrmapPut(pgnoNew[0], (short)5, pParent.pgno);
                if (szCell > pNew.minLocal) {
                    pNew.ptrmapPutOvflPtr(pCell);
                }
            }
            pCell = pPage.findCell(pPage.nCell - 1);
            ISqlJetMemoryPointer pStop = pCell.getMoved(9);
            do {
                b = (pCell.getByteUnsigned() & 0x80) == 0;
                pCell.movePointer(1);
            } while (!b && pCell.getPointer() < pStop.getPointer());
            pStop = pCell.getMoved(9);
            do {
                pOut.putByteUnsigned(pCell.getByteUnsigned());
                pOut.movePointer(1);
                b = (pCell.getByteUnsigned() & 0x80) == 0;
                pCell.movePointer(1);
            } while (!b && pCell.getPointer() < pStop.getPointer());
            pParent.insertCell(pParent.nCell, pSpace, pOut.getPointer() - pSpace.getPointer(), null, pPage.pgno);
            SqlJetUtility.put4byte(pParent.aData.getMoved(pParent.hdrOffset + 8), pgnoNew[0]);
        }
        finally {
            SqlJetMemPage.releasePage(pNew);
        }
    }

    private SqlJetMemPage balance_deeper(SqlJetMemPage pRoot) throws SqlJetException {
        SqlJetMemPage pChild = null;
        int[] pgnoChild = new int[]{0};
        SqlJetBtreeShared pBt = pRoot.pBt;
        assert (pRoot.nOverflow > 0);
        assert (SqlJetUtility.mutex_held(pBt.mutex));
        pRoot.pDbPage.write();
        try {
            pChild = pBt.allocatePage(pgnoChild, pRoot.pgno, false);
            pRoot.copyNodeContent(pChild);
            if (pBt.autoVacuum) {
                pBt.ptrmapPut(pgnoChild[0], (short)5, pRoot.pgno);
            }
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(pChild);
            throw e;
        }
        assert (pChild.pDbPage.isWriteable());
        assert (pRoot.pDbPage.isWriteable());
        assert (pChild.nCell == pRoot.nCell);
        SqlJetBtree.TRACE("BALANCE: copy root %d into %d\n", pRoot.pgno, pChild.pgno);
        SqlJetUtility.memcpy(pChild.aOvfl, pRoot.aOvfl, pRoot.nOverflow);
        pChild.nOverflow = pRoot.nOverflow;
        pRoot.zeroPage(SqlJetUtility.getUnsignedByte(pChild.aData, 0) & 0xFFFFFFF7);
        SqlJetUtility.put4byte(pRoot.aData.getMoved(pRoot.hdrOffset + 8), pgnoChild[0]);
        return pChild;
    }

    void releaseTempCursor() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        for (int i = 0; i <= pCur.iPage; ++i) {
            pCur.apPage[i].pDbPage.unref();
        }
        pCur.pKey = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ISqlJetMemoryPointer pKey, long nKey, ISqlJetMemoryPointer pData, int nData, int zero, boolean bias) throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetBtree p = pCur.pBtree;
        SqlJetBtreeShared pBt = p.pBt;
        ISqlJetMemoryPointer newCell = null;
        assert (this.cursorHoldsMutex(pCur));
        assert (pBt.inTransaction == SqlJetBtree.TransMode.WRITE);
        assert (!pBt.readOnly);
        assert (pCur.wrFlag);
        if (pCur.pBtree.checkReadLocks(pCur.pgnoRoot, pCur, nKey)) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        if (pCur.eState == CursorState.FAULT) {
            throw new SqlJetException(pCur.error);
        }
        pBt.saveAllCursors(pCur.pgnoRoot, pCur);
        int loc = pCur.moveTo(pKey, nKey, bias);
        assert (pCur.eState == CursorState.VALID || pCur.eState == CursorState.INVALID && loc != 0);
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (pPage.intKey || nKey >= 0L);
        assert (pPage.leaf || !pPage.intKey);
        SqlJetBtree.TRACE("INSERT: table=%d nkey=%d ndata=%b page=%d %s\n", pCur.pgnoRoot, nKey, pData, pPage.pgno, loc == 0 ? "overwrite" : "new entry");
        assert (pPage.isInit);
        pBt.allocateTempSpace();
        newCell = pBt.pTmpSpace;
        int szNew = pPage.fillInCell(newCell, pKey, nKey, pData, nData, zero);
        assert (szNew == pPage.cellSizePtr(newCell));
        assert (szNew <= pBt.MX_CELL_SIZE());
        int idx = pCur.aiIdx[pCur.iPage];
        if (loc == 0 && CursorState.VALID == pCur.eState) {
            assert (idx < pPage.nCell);
            pPage.pDbPage.write();
            ISqlJetMemoryPointer oldCell = pPage.findCell(idx);
            if (!pPage.leaf) {
                SqlJetUtility.memcpy(newCell, oldCell, 4);
            }
            int szOld = pPage.cellSizePtr(oldCell);
            pPage.clearCell(oldCell);
            pPage.dropCell(idx, szOld);
        } else if (loc < 0 && pPage.nCell > 0) {
            assert (pPage.leaf);
            int n = pCur.iPage;
            int n2 = pCur.aiIdx[n] + 1;
            pCur.aiIdx[n] = n2;
            idx = n2;
        } else assert (pPage.leaf);
        try {
            pPage.insertCell(idx, newCell, szNew, null, 0);
            assert (pPage.nCell > 0 || pPage.nOverflow > 0);
        }
        finally {
            pCur.info.nSize = 0;
            pCur.validNKey = false;
        }
        if (pPage.nOverflow > 0) {
            try {
                pCur.balance(true);
            }
            finally {
                pCur.apPage[pCur.iPage].nOverflow = 0;
                pCur.eState = CursorState.INVALID;
            }
        }
        assert (pCur.apPage[pCur.iPage].nOverflow == 0);
    }

    public boolean first() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.pBtree.db.getMutex().held());
        pCur.moveToRoot();
        if (pCur.eState == CursorState.INVALID) {
            assert (pCur.apPage[pCur.iPage].nCell == 0);
            return true;
        }
        assert (pCur.apPage[pCur.iPage].nCell > 0);
        pCur.moveToLeftmost();
        return false;
    }

    private void moveToLeftmost() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.eState == CursorState.VALID);
        while (true) {
            SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
            if (pPage.leaf) break;
            assert (pCur.aiIdx[pCur.iPage] < pPage.nCell);
            int pgno = SqlJetUtility.get4byte(pPage.findCell(pCur.aiIdx[pCur.iPage]));
            pCur.moveToChild(pgno);
        }
    }

    private void moveToRightmost() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetMemPage pPage = null;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.eState == CursorState.VALID);
        while (true) {
            pPage = pCur.apPage[pCur.iPage];
            if (pPage.leaf) break;
            int pgno = SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8);
            pCur.aiIdx[pCur.iPage] = pPage.nCell;
            pCur.moveToChild(pgno);
        }
        pCur.aiIdx[pCur.iPage] = pPage.nCell - 1;
        pCur.info.nSize = 0;
        pCur.validNKey = false;
    }

    public boolean last() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.pBtree.db.getMutex().held());
        pCur.moveToRoot();
        if (CursorState.INVALID == pCur.eState) {
            assert (pCur.apPage[pCur.iPage].nCell == 0);
            return true;
        }
        assert (pCur.eState == CursorState.VALID);
        try {
            pCur.moveToRightmost();
        }
        catch (SqlJetException e) {
            pCur.atLast = false;
            throw e;
        }
        finally {
            pCur.getCellInfo();
        }
        pCur.atLast = true;
        return false;
    }

    public boolean next() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        if (CursorState.INVALID == pCur.eState) {
            return true;
        }
        if (pCur.skip > 0) {
            pCur.skip = 0;
            return false;
        }
        pCur.skip = 0;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        int n = pCur.iPage;
        int n2 = pCur.aiIdx[n] + 1;
        pCur.aiIdx[n] = n2;
        int idx = n2;
        assert (pPage.isInit);
        assert (idx <= pPage.nCell);
        pCur.info.nSize = 0;
        pCur.validNKey = false;
        if (idx >= pPage.nCell) {
            if (!pPage.leaf) {
                pCur.moveToChild(SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8));
                pCur.moveToLeftmost();
                return false;
            }
            do {
                if (pCur.iPage == 0) {
                    pCur.eState = CursorState.INVALID;
                    return true;
                }
                pCur.moveToParent();
                pPage = pCur.apPage[pCur.iPage];
            } while (pCur.aiIdx[pCur.iPage] >= pPage.nCell);
            if (pPage.intKey) {
                return pCur.next();
            }
            return false;
        }
        if (pPage.leaf) {
            return false;
        }
        pCur.moveToLeftmost();
        return false;
    }

    private void moveToParent() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.eState == CursorState.VALID);
        assert (pCur.iPage > 0);
        assert (pCur.apPage[pCur.iPage] != null);
        pCur.apPage[pCur.iPage - 1].assertParentIndex(pCur.aiIdx[pCur.iPage - 1], pCur.apPage[pCur.iPage].pgno);
        SqlJetMemPage.releasePage(pCur.apPage[pCur.iPage]);
        --pCur.iPage;
        pCur.info.nSize = 0;
        pCur.validNKey = false;
    }

    public boolean previous() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        pCur.atLast = false;
        if (CursorState.INVALID == pCur.eState) {
            return true;
        }
        if (pCur.skip < 0) {
            pCur.skip = 0;
            return false;
        }
        pCur.skip = 0;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (pPage.isInit);
        if (!pPage.leaf) {
            int idx = pCur.aiIdx[pCur.iPage];
            pCur.moveToChild(SqlJetUtility.get4byte(pPage.findCell(idx)));
            pCur.moveToRightmost();
        } else {
            while (pCur.aiIdx[pCur.iPage] == 0) {
                if (pCur.iPage == 0) {
                    pCur.eState = CursorState.INVALID;
                    return true;
                }
                pCur.moveToParent();
            }
            pCur.info.nSize = 0;
            pCur.validNKey = false;
            int n = pCur.iPage;
            pCur.aiIdx[n] = pCur.aiIdx[n] - 1;
            pPage = pCur.apPage[pCur.iPage];
            if (pPage.intKey && !pPage.leaf) {
                return pCur.previous();
            }
        }
        return false;
    }

    public boolean eof() {
        SqlJetBtreeCursor pCur = this;
        return CursorState.VALID != pCur.eState;
    }

    public short flags() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        pCur.restoreCursorPosition();
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (this.cursorHoldsMutex(pCur));
        assert (pPage != null);
        assert (pPage.pBt == pCur.pBt);
        return (short)SqlJetUtility.getUnsignedByte(pPage.aData, pPage.hdrOffset);
    }

    public long getKeySize() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        assert (pCur.eState == CursorState.INVALID || pCur.eState == CursorState.VALID);
        if (pCur.eState == CursorState.INVALID) {
            return 0L;
        }
        pCur.getCellInfo();
        return pCur.info.nKey;
    }

    public void key(int offset, int amt, ISqlJetMemoryPointer buf) throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        assert (pCur.eState == CursorState.VALID);
        assert (pCur.iPage >= 0 && pCur.apPage[pCur.iPage] != null);
        if (pCur.apPage[0].intKey) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        assert (pCur.aiIdx[pCur.iPage] < pCur.apPage[pCur.iPage].nCell);
        pCur.accessPayload(offset, amt, buf, 0, false);
    }

    private void accessPayload(int offset, int amt, ISqlJetMemoryPointer pBuf, int skipKey, boolean eOp) throws SqlJetException {
        int nKey;
        pBuf = SqlJetUtility.pointer(pBuf);
        SqlJetBtreeCursor pCur = this;
        int iIdx = 0;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        SqlJetBtreeShared pBt = pCur.pBt;
        assert (pPage != null);
        assert (pCur.eState == CursorState.VALID);
        assert (pCur.aiIdx[pCur.iPage] < pPage.nCell);
        assert (this.cursorHoldsMutex(pCur));
        pCur.getCellInfo();
        ISqlJetMemoryPointer aPayload = SqlJetUtility.pointer(pCur.info.pCell, pCur.info.nHeader);
        int n = nKey = pPage.intKey ? 0 : (int)pCur.info.nKey;
        if (skipKey != 0) {
            offset += nKey;
        }
        if (offset + amt > nKey + pCur.info.nData || aPayload.getPointer() + pCur.info.nLocal > pPage.aData.getPointer() + pBt.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (offset < pCur.info.nLocal) {
            int a = amt;
            if (a + offset > pCur.info.nLocal) {
                a = pCur.info.nLocal - offset;
            }
            this.copyPayload(aPayload, offset, pBuf, 0, a, eOp, pPage.pDbPage);
            offset = 0;
            pBuf.movePointer(a);
            amt -= a;
        } else {
            offset -= pCur.info.nLocal;
        }
        if (amt > 0) {
            int ovflSize = pBt.usableSize - 4;
            int nextPage = SqlJetUtility.get4byte(aPayload, pCur.info.nLocal);
            if (pCur.isIncrblobHandle && pCur.aOverflow == null) {
                int nOvfl = (pCur.info.nPayload - pCur.info.nLocal + ovflSize - 1) / ovflSize;
                pCur.aOverflow = new int[nOvfl];
            }
            if (pCur.aOverflow != null && pCur.aOverflow[offset / ovflSize] != 0) {
                iIdx = offset / ovflSize;
                nextPage = pCur.aOverflow[iIdx];
                offset %= ovflSize;
            }
            while (amt > 0 && nextPage != 0) {
                if (pCur.aOverflow != null) {
                    assert (pCur.aOverflow[iIdx] == 0 || pCur.aOverflow[iIdx] == nextPage);
                    pCur.aOverflow[iIdx] = nextPage;
                }
                if (offset >= ovflSize) {
                    if (pCur.aOverflow != null && pCur.aOverflow[iIdx + 1] != 0) {
                        nextPage = pCur.aOverflow[iIdx + 1];
                    } else {
                        int[] pNextPage = new int[]{nextPage};
                        pBt.getOverflowPage(nextPage, null, pNextPage);
                        nextPage = pNextPage[0];
                    }
                    offset -= ovflSize;
                } else {
                    int a = amt;
                    ISqlJetPage pDbPage = pBt.pPager.getPage(nextPage);
                    aPayload = pDbPage.getData();
                    nextPage = SqlJetUtility.get4byte(aPayload);
                    if (a + offset > ovflSize) {
                        a = ovflSize - offset;
                    }
                    this.copyPayload(aPayload, offset + 4, pBuf, 0, a, eOp, pDbPage);
                    pDbPage.unref();
                    offset = 0;
                    amt -= a;
                    pBuf.movePointer(a);
                }
                ++iIdx;
            }
        }
        if (amt > 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void copyPayload(ISqlJetMemoryPointer pPayload, int payloadOffset, ISqlJetMemoryPointer pBuf, int bufOffset, int nByte, boolean eOp, ISqlJetPage pDbPage) throws SqlJetException {
        if (eOp) {
            pDbPage.write();
            SqlJetUtility.memcpy(pPayload, payloadOffset, pBuf, bufOffset, nByte);
        } else {
            SqlJetUtility.memcpy(pBuf, bufOffset, pPayload, payloadOffset, nByte);
        }
    }

    public ISqlJetDbHandle getCursorDb() {
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        return this.pBtree.db;
    }

    public ISqlJetMemoryPointer keyFetch(int[] amt) {
        assert (this.cursorHoldsMutex(this));
        if (this.eState == CursorState.VALID) {
            return this.fetchPayload(amt, false);
        }
        return null;
    }

    public ISqlJetMemoryPointer dataFetch(int[] amt) {
        assert (this.cursorHoldsMutex(this));
        if (this.eState == CursorState.VALID) {
            return this.fetchPayload(amt, true);
        }
        return null;
    }

    public int getDataSize() throws SqlJetException {
        assert (this.cursorHoldsMutex(this));
        this.restoreCursorPosition();
        assert (this.eState == CursorState.INVALID || this.eState == CursorState.VALID);
        if (this.eState == CursorState.INVALID) {
            return 0;
        }
        this.getCellInfo();
        return this.info.nData;
    }

    public void data(int offset, int amt, ISqlJetMemoryPointer buf) throws SqlJetException {
        if (this.eState == CursorState.INVALID) {
            throw new SqlJetException(SqlJetErrorCode.ABORT);
        }
        assert (this.cursorHoldsMutex(this));
        this.restoreCursorPosition();
        assert (this.eState == CursorState.VALID);
        assert (this.iPage >= 0 && this.apPage[this.iPage] != null);
        assert (this.aiIdx[this.iPage] < this.apPage[this.iPage].nCell);
        this.accessPayload(offset, amt, buf, 1, false);
    }

    public void putData(int offset, int amt, ISqlJetMemoryPointer data) throws SqlJetException {
        assert (this.cursorHoldsMutex(this));
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        assert (this.isIncrblobHandle);
        this.restoreCursorPosition();
        assert (this.eState != CursorState.REQUIRESEEK);
        if (this.eState != CursorState.VALID) {
            throw new SqlJetException(SqlJetErrorCode.ABORT);
        }
        if (!this.wrFlag) {
            throw new SqlJetException(SqlJetErrorCode.READONLY);
        }
        assert (!this.pBt.readOnly && this.pBt.inTransaction == SqlJetBtree.TransMode.WRITE);
        if (this.pBtree.checkReadLocks(this.pgnoRoot, this, 0L)) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        if (this.eState == CursorState.INVALID || !this.apPage[this.iPage].intKey) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.accessPayload(offset, amt, data, 0, true);
    }

    public void cacheOverflow() {
        assert (this.cursorHoldsMutex(this));
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        assert (!this.isIncrblobHandle);
        assert (this.aOverflow == null);
        this.isIncrblobHandle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCursorPosition() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (CursorState.VALID == pCur.eState);
        assert (null == pCur.pKey);
        assert (this.cursorHoldsMutex(pCur));
        try {
            pCur.nKey = pCur.getKeySize();
            if (!pCur.apPage[0].intKey) {
                ISqlJetMemoryPointer pKey = SqlJetUtility.allocatePtr((int)pCur.nKey);
                pCur.key(0, (int)pCur.nKey, pKey);
                pCur.pKey = pKey;
            }
            assert (!pCur.apPage[0].intKey || pCur.pKey == null);
            for (int i = 0; i <= pCur.iPage; ++i) {
                SqlJetMemPage.releasePage(pCur.apPage[i]);
                pCur.apPage[i] = null;
            }
            pCur.iPage = -1;
            pCur.eState = CursorState.REQUIRESEEK;
        }
        finally {
            pCur.invalidateOverflowCache();
        }
        return true;
    }

    public void enterCursor() {
        if (this.pBtree != null) {
            this.pBtree.enter();
        }
    }

    public void leaveCursor() {
        if (this.pBtree != null) {
            this.pBtree.leave();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CursorState {
        INVALID,
        VALID,
        REQUIRESEEK,
        FAULT;

    }
}

