/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.fao.oaipmh.requests.ListRequest;
import org.fao.oaipmh.responses.ListResponse;
import org.fao.oaipmh.responses.Record;
import org.fao.oaipmh.responses.ResumptionToken;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class ListRecordsResponse
extends ListResponse {
    private List<Record> records = new ArrayList<Record>();

    public ListRecordsResponse() {
    }

    public ListRecordsResponse(ListRequest lr, Element response) {
        super(lr, response);
    }

    @Override
    public Record next() throws IOException, OaiPmhException, JDOMException, SAXException, Exception {
        return (Record)super.next();
    }

    public void clearRecords() {
        this.records.clear();
    }

    public void addRecord(Record r) {
        this.records.add(r);
    }

    public int getRecordsCount() {
        return this.records.size();
    }

    @Override
    public int getSize() {
        return this.getRecordsCount();
    }

    @Override
    public Element toXml() {
        Element root = new Element("ListRecords", OaiPmh.Namespaces.OAI_PMH);
        for (Record r : this.records) {
            root.addContent((Content)r.toXml());
        }
        ResumptionToken token = this.getResumptionToken();
        if (token != null) {
            root.addContent((Content)token.toXml());
        }
        return root;
    }

    @Override
    protected Object createObject(Element object) {
        return new Record(object);
    }

    @Override
    protected String getListElementName() {
        return "record";
    }
}

