/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.PermissionCacheOptimizer;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.method.MethodSecurityEvaluationContext;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.access.expression.method.MethodSecurityExpressionRoot;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.parameters.DefaultSecurityParameterNameDiscoverer;
import org.springframework.util.Assert;

public class DefaultMethodSecurityExpressionHandler
extends AbstractSecurityExpressionHandler<MethodInvocation>
implements MethodSecurityExpressionHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultSecurityParameterNameDiscoverer();
    private PermissionCacheOptimizer permissionCacheOptimizer = null;
    private String defaultRolePrefix = "ROLE_";

    @Override
    public StandardEvaluationContext createEvaluationContextInternal(Authentication auth, MethodInvocation mi) {
        return new MethodSecurityEvaluationContext(auth, mi, this.getParameterNameDiscoverer());
    }

    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        MethodSecurityExpressionRoot root = new MethodSecurityExpressionRoot(authentication);
        root.setThis(invocation.getThis());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(this.getTrustResolver());
        root.setRoleHierarchy(this.getRoleHierarchy());
        root.setDefaultRolePrefix(this.getDefaultRolePrefix());
        return root;
    }

    @Override
    public Object filter(Object filterTarget, Expression filterExpression, EvaluationContext ctx) {
        MethodSecurityExpressionOperations rootObject = (MethodSecurityExpressionOperations)ctx.getRootObject().getValue();
        boolean debug = this.logger.isDebugEnabled();
        if (debug) {
            this.logger.debug((Object)("Filtering with expression: " + filterExpression.getExpressionString()));
        }
        if (filterTarget instanceof Collection) {
            Collection collection = (Collection)filterTarget;
            ArrayList retainList = new ArrayList(collection.size());
            if (debug) {
                this.logger.debug((Object)("Filtering collection with " + collection.size() + " elements"));
            }
            if (this.permissionCacheOptimizer != null) {
                this.permissionCacheOptimizer.cachePermissionsFor(rootObject.getAuthentication(), collection);
            }
            for (Object filterObject2 : (Collection)filterTarget) {
                rootObject.setFilterObject(filterObject2);
                if (!ExpressionUtils.evaluateAsBoolean(filterExpression, ctx)) continue;
                retainList.add(filterObject2);
            }
            if (debug) {
                this.logger.debug((Object)("Retaining elements: " + retainList));
            }
            collection.clear();
            collection.addAll(retainList);
            return filterTarget;
        }
        if (filterTarget.getClass().isArray()) {
            Object[] array = (Object[])filterTarget;
            ArrayList<Object> retainList = new ArrayList<Object>(array.length);
            if (debug) {
                this.logger.debug((Object)("Filtering array with " + array.length + " elements"));
            }
            if (this.permissionCacheOptimizer != null) {
                this.permissionCacheOptimizer.cachePermissionsFor(rootObject.getAuthentication(), Arrays.asList(array));
            }
            for (Object o : array) {
                rootObject.setFilterObject(o);
                if (!ExpressionUtils.evaluateAsBoolean(filterExpression, ctx)) continue;
                retainList.add(o);
            }
            if (debug) {
                this.logger.debug((Object)("Retaining elements: " + retainList));
            }
            Object[] filtered = (Object[])Array.newInstance(filterTarget.getClass().getComponentType(), retainList.size());
            for (int i = 0; i < retainList.size(); ++i) {
                filtered[i] = retainList.get(i);
            }
            return filtered;
        }
        if (filterTarget instanceof Stream) {
            Stream original = (Stream)filterTarget;
            return original.filter(filterObject -> {
                rootObject.setFilterObject(filterObject);
                return ExpressionUtils.evaluateAsBoolean(filterExpression, ctx);
            }).onClose(original::close);
        }
        throw new IllegalArgumentException("Filter target must be a collection, array, or stream type, but was " + filterTarget);
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, (String)"trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }

    protected AuthenticationTrustResolver getTrustResolver() {
        return this.trustResolver;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    protected ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setPermissionCacheOptimizer(PermissionCacheOptimizer permissionCacheOptimizer) {
        this.permissionCacheOptimizer = permissionCacheOptimizer;
    }

    @Override
    public void setReturnObject(Object returnObject, EvaluationContext ctx) {
        ((MethodSecurityExpressionOperations)ctx.getRootObject().getValue()).setReturnObject(returnObject);
    }

    public void setDefaultRolePrefix(String defaultRolePrefix) {
        this.defaultRolePrefix = defaultRolePrefix;
    }

    protected String getDefaultRolePrefix() {
        return this.defaultRolePrefix;
    }
}

