/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import org.jclouds.json.gson.internal.bind.TypeAdapters;

public abstract class NullHackJsonLiteralAdapter<L>
extends TypeAdapter<L> {
    private static final Field outField;

    public L read(JsonReader reader) throws IOException {
        return this.createJsonLiteralFromRawJson(((JsonElement)TypeAdapters.JSON_ELEMENT.read(reader)).toString());
    }

    protected abstract L createJsonLiteralFromRawJson(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonWriter jsonWriter, L value) throws IOException {
        Writer writer = this.getWriter(jsonWriter);
        boolean serializeNulls = jsonWriter.getSerializeNulls();
        try {
            NullReplacingWriter nullReplacingWriter = new NullReplacingWriter(writer, this.toString(value));
            this.setWriter(jsonWriter, nullReplacingWriter);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.nullValue();
        }
        finally {
            this.setWriter(jsonWriter, writer);
            jsonWriter.setSerializeNulls(serializeNulls);
        }
    }

    protected String toString(L value) {
        return value.toString();
    }

    protected Writer getWriter(JsonWriter arg0) {
        try {
            return (Writer)Writer.class.cast(outField.get(arg0));
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setWriter(JsonWriter arg0, Writer arg1) {
        try {
            outField.set(arg0, arg1);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            outField = JsonWriter.class.getDeclaredField("out");
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
        outField.setAccessible(true);
    }

    public static final class NullReplacingWriter
    extends Writer {
        private final Writer delegate;
        private final String nullReplacement;

        public NullReplacingWriter(Writer delegate, String nullReplacement) {
            this.delegate = delegate;
            this.nullReplacement = nullReplacement;
        }

        @Override
        public void write(char[] buffer, int offset, int count) throws IOException {
            this.delegate.write(buffer, offset, count);
        }

        @Override
        public void write(String s) throws IOException {
            if (this.nullReplacement != null && s.equals("null")) {
                s = this.nullReplacement;
            }
            super.write(s);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

