/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.CatalogConfigurationGetRecordsField;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;

public class CatalogConfiguration {
    private final HashMap<String, CatalogConfigurationGetRecordsField> _fieldMapping = new HashMap();
    private final Set<String> _isoQueryables = new HashSet<String>();
    private final Set<String> _additionalQueryables = new HashSet<String>();
    private final Set<String> _getRecordsConstraintLanguage = new HashSet<String>();
    private final Set<String> _getRecordsOutputFormat = new HashSet<String>();
    private final Set<String> _getRecordsOutputSchema = new HashSet<String>();
    private final Set<String> _getRecordsTypenames = new HashSet<String>();
    private final Set<String> _getRecordsRangeFields = new HashSet<String>();
    private final HashMap<String, String> _describeRecordTypenames = new HashMap();
    private final Set<Namespace> _describeRecordNamespaces = new HashSet<Namespace>();
    private final Set<String> _describeRecordOutputFormat = new HashSet<String>();
    private int _numberOfKeywords = 10;
    private int _maxNumberOfRecordsForKeywords = Integer.MAX_VALUE;
    private int _maxNumberOfRecordsForPropertyNames = Integer.MAX_VALUE;
    private boolean _increasePopularity = false;
    @Autowired
    private GeonetworkDataDirectory _dataDir;
    @Autowired(required=false)
    private ServletContext _servletContext;
    @Autowired
    private SchemaManager _schemaManager;
    private volatile boolean initialized = false;

    public synchronized void init() {
        if (!this.initialized) {
            Log.info((String)"geonetwork.csw", (Object)"  - Catalogue services for the web...");
            Path webappDir = this._dataDir.getWebappDir();
            try {
                this.loadCatalogConfig(webappDir, "config-csw.xml");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.initialized = true;
        }
    }

    private void loadCatalogConfig(Path path, String configFileName) throws Exception {
        Path configFile = path.resolve("WEB-INF").resolve(configFileName);
        Log.info((String)"geonetwork.csw", (Object)("Loading : " + configFile));
        Element configRoot = Xml.loadFile((Path)configFile);
        List operationsList = configRoot.getChildren("operations");
        for (Element element : operationsList) {
            this.initOperations(element);
        }
        List includes = configRoot.getChildren("include");
        for (Element include : includes) {
            this.loadCatalogConfig(path, include.getText());
        }
    }

    private void initOperations(Element element) {
        List operationLst = element.getChildren("operation");
        for (Element operation : operationLst) {
            String operationName = operation.getAttributeValue("name");
            if (operationName.equals("GetCapabilities")) {
                this.initCapabilities(operation);
                continue;
            }
            if (operationName.equals("GetDomain")) {
                this.initDomain(operation);
                continue;
            }
            if (operationName.equals("GetRecords")) {
                this.initGetRecordsConfig(operation);
                continue;
            }
            if (operationName.equals("DescribeRecord")) {
                this.initDescribeRecordConfig(operation);
            }
            if (!operationName.equals("GetRecordById")) continue;
            this.initGetRecordByIdConfig(operation);
        }
    }

    private void initGetRecordByIdConfig(Element operation) {
        Element increasePopularityConfig = operation.getChild("increasePopularity");
        if (increasePopularityConfig != null && "yes".equals(increasePopularityConfig.getText())) {
            this._increasePopularity = true;
        }
    }

    private void initCapabilities(Element operation) {
        Element kn = operation.getChild("numberOfKeywords");
        if (kn != null && kn.getText() != null) {
            this._numberOfKeywords = Integer.parseInt(kn.getText());
        }
        if ((kn = operation.getChild("maxNumberOfRecordsForKeywords")) != null && kn.getText() != null) {
            this._maxNumberOfRecordsForKeywords = Integer.parseInt(kn.getText());
        }
    }

    private void initDomain(Element operation) {
        Element kn = operation.getChild("maxNumberOfRecordsForPropertyNames");
        if (kn != null && kn.getText() != null) {
            this._maxNumberOfRecordsForPropertyNames = Integer.parseInt(kn.getText());
        }
    }

    private void initDescribeRecordConfig(Element operation) {
        Map typenames = this._schemaManager.getHmSchemasTypenames();
        for (Map.Entry entry : typenames.entrySet()) {
            String typeName = (String)entry.getKey();
            Namespace ns = (Namespace)entry.getValue();
            String typename = typeName;
            String schema = ns.getPrefix().equals("csw") ? "record.xsd" : (ns.getPrefix().equals("gmd") ? "identification.xsd" : "unknown.xsd");
            this._describeRecordNamespaces.add(ns);
            this._describeRecordTypenames.put(typename, schema);
        }
        this._describeRecordOutputFormat.addAll(this.getOutputFormat(operation));
    }

    private void initGetRecordsConfig(Element operation) {
        Element params = operation.getChild("parameters");
        List paramsList = params.getChildren("parameter");
        for (Element param : paramsList) {
            String name = param.getAttributeValue("name");
            String field = param.getAttributeValue("field");
            String type = param.getAttributeValue("type");
            String range = param.getAttributeValue("range", "false");
            String sortField = param.getAttributeValue("sortField");
            if (StringUtils.isEmpty((String)sortField)) {
                sortField = field;
            }
            if (range.equals("true")) {
                this._getRecordsRangeFields.add(field);
            }
            if (type.equals("SupportedISOQueryables")) {
                this._isoQueryables.add(name);
            } else {
                this._additionalQueryables.add(name);
            }
            List xpathList = param.getChildren("xpath");
            Iterator itXPath = xpathList.iterator();
            HashMap<String, String> xpathMap = new HashMap<String, String>();
            while (itXPath.hasNext()) {
                Element xpath = (Element)itXPath.next();
                String schema = xpath.getAttributeValue("schema");
                String path = xpath.getAttributeValue("path");
                xpathMap.put(schema, path);
            }
            CatalogConfigurationGetRecordsField fieldInfo = new CatalogConfigurationGetRecordsField(name, type, range.equals("true"), field, sortField, xpathMap);
            this._fieldMapping.put(name.toLowerCase(), fieldInfo);
        }
        this._getRecordsOutputFormat.addAll(this.getOutputFormat(operation));
        Element constraintLanguageElt = operation.getChild("constraintLanguage");
        List constraintLanguageList = constraintLanguageElt.getChildren("value");
        for (Element constraint : constraintLanguageList) {
            String value = constraint.getText();
            this._getRecordsConstraintLanguage.add(value);
        }
        Map typenames = this._schemaManager.getHmSchemasTypenames();
        for (Map.Entry entry : typenames.entrySet()) {
            String typeName = (String)entry.getKey();
            Namespace ns = (Namespace)entry.getValue();
            String typename = ns.getPrefix() + ":" + typeName;
            this._getRecordsOutputSchema.add(ns.getURI());
            this._getRecordsTypenames.add(typename);
        }
    }

    private Set<String> getOutputFormat(Element operation) {
        HashSet<String> outformatList = new HashSet<String>();
        Element outputFormat = operation.getChild("outputformat");
        List formatList = outputFormat.getChildren("format");
        for (Element currentFormat : formatList) {
            String format = currentFormat.getText();
            outformatList.add(format);
        }
        return outformatList;
    }

    public HashMap<String, CatalogConfigurationGetRecordsField> getFieldMapping() {
        this.init();
        return this._fieldMapping;
    }

    public Set<String> getTypeMapping(String type) {
        this.init();
        if (type.equals("SupportedISOQueryables")) {
            return this._isoQueryables;
        }
        return this._additionalQueryables;
    }

    public int getNumberOfKeywords() {
        this.init();
        return this._numberOfKeywords;
    }

    public int getMaxNumberOfRecordsForKeywords() {
        this.init();
        return this._maxNumberOfRecordsForKeywords;
    }

    public int getMaxNumberOfRecordsForPropertyNames() {
        this.init();
        return this._maxNumberOfRecordsForPropertyNames;
    }

    public HashMap<String, String> getDescribeRecordTypename() {
        this.init();
        return this._describeRecordTypenames;
    }

    public Set<Namespace> getDescribeRecordNamespaces() {
        this.init();
        return this._describeRecordNamespaces;
    }

    public Set<String> getDescribeRecordOutputFormat() {
        this.init();
        return this._describeRecordOutputFormat;
    }

    public Set<String> getGetRecordsOutputFormat() {
        this.init();
        return this._getRecordsOutputFormat;
    }

    public Set<String> getGetRecordsOutputSchema() {
        this.init();
        return this._getRecordsOutputSchema;
    }

    public Set<String> getGetRecordsTypenames() {
        this.init();
        return this._getRecordsTypenames;
    }

    public Set<String> getGetRecordsRangeFields() {
        this.init();
        return this._getRecordsRangeFields;
    }

    public boolean isIncreasePopularity() {
        this.init();
        return this._increasePopularity;
    }
}

