/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common.exceptions;

import java.util.List;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.InvalidUpdateSequenceEx;
import org.fao.geonet.csw.common.exceptions.MissingParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.csw.common.exceptions.OperationNotSupportedEx;
import org.fao.geonet.csw.common.exceptions.VersionNegotiationFailedEx;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class CatalogException
extends Exception {
    protected static final String INVALID_PARAMETER_VALUE = "InvalidParameterValue";
    protected static final String INVALID_UPDATE_SEQUENCE = "InvalidUpdateSequence";
    protected static final String MISSING_PARAMETER_VALUE = "MissingParameterValue";
    protected static final String NO_APPLICABLE_CODE = "NoApplicableCode";
    protected static final String OPERATION_NOT_SUPPORTED = "OperationNotSupported";
    protected static final String VERSION_NEGOTIATION_FAILED = "VersionNegotiationFailed";
    private static final long serialVersionUID = -2483411203445474288L;
    private String code;
    private String locator;

    public CatalogException(String code, String message, String locator) {
        super(message);
        this.code = code;
        this.locator = locator;
    }

    public CatalogException(String code, String message, String locator, CatalogException cause) {
        super(message, cause);
        this.code = code;
        this.locator = locator;
    }

    public static Element marshal(CatalogException e) {
        Element root = new Element("ExceptionReport", Csw.NAMESPACE_OWS);
        root.setAttribute("version", "1.2.0");
        root.addNamespaceDeclaration(Csw.NAMESPACE_XSI);
        root.setAttribute("schemaLocation", Csw.NAMESPACE_OWS.getURI() + " " + "http://schemas.opengis.net" + "/ows/1.0.0/owsExceptionReport.xsd", Csw.NAMESPACE_XSI);
        while (e != null) {
            Element exc = new Element("Exception", Csw.NAMESPACE_OWS);
            exc.setAttribute("exceptionCode", e.getCode());
            if (e.getMessage() != null) {
                exc.addContent((Content)new Element("ExceptionText", Csw.NAMESPACE_OWS).setText(e.getMessage()));
            }
            if (e.getLocator() != null) {
                exc.setAttribute("locator", e.getLocator());
            }
            root.addContent((Content)exc);
            e = (CatalogException)e.getCause();
        }
        return root;
    }

    public static void unmarshal(Element response) throws Exception {
        if (!response.getName().equals("ExceptionReport")) {
            return;
        }
        Namespace ns = response.getNamespace();
        List exceptions = response.getChildren("Exception", ns);
        if (exceptions.size() == 0) {
            throw new Exception("Bad exception (no 'Exception' elem) : \n" + Xml.getString((Element)response));
        }
        CatalogException e = null;
        for (int i = exceptions.size() - 1; i >= 0; --i) {
            Element ex = (Element)exceptions.get(i);
            e = CatalogException.createException(ex, response, e);
        }
        throw e;
    }

    private static CatalogException createException(Element ex, Element response, CatalogException prev) throws Exception {
        Namespace ns = response.getNamespace();
        String code = ex.getAttributeValue("exceptionCode");
        if (code == null) {
            throw new Exception("Bad exception (no 'exceptionCode' attr) : \n" + Xml.getString((Element)response));
        }
        Element text = ex.getChild("ExceptionText", ns);
        String locator = ex.getAttributeValue("locator");
        String message = text == null ? null : text.getText();
        CatalogException e = null;
        if (code.equals(INVALID_PARAMETER_VALUE)) {
            e = new InvalidParameterValueEx(null, message, prev);
        }
        if (code.equals(INVALID_UPDATE_SEQUENCE)) {
            e = new InvalidUpdateSequenceEx(message, prev);
        }
        if (code.equals(MISSING_PARAMETER_VALUE)) {
            e = new MissingParameterValueEx(null, prev);
        }
        if (code.equals(NO_APPLICABLE_CODE)) {
            e = new NoApplicableCodeEx(message, prev);
        }
        if (code.equals(OPERATION_NOT_SUPPORTED)) {
            e = new OperationNotSupportedEx(null, prev);
        }
        if (code.equals(VERSION_NEGOTIATION_FAILED)) {
            e = new VersionNegotiationFailedEx(message, prev);
        }
        if (e == null) {
            throw new Exception("Bad exception (unknown 'exceptionCode') : \n" + Xml.getString((Element)response));
        }
        e.locator = locator;
        return e;
    }

    public String getCode() {
        return this.code;
    }

    public String getLocator() {
        return this.locator;
    }

    @Override
    public String toString() {
        String clazz = this.getClass().getName();
        return clazz + ": code=" + this.code + ", locator=" + this.locator + ", message=" + this.getMessage();
    }
}

