/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CswService.DescribeRecord")
public class DescribeRecord
extends AbstractOperation
implements CatalogService {
    static final String NAME = "DescribeRecord";
    @Autowired
    private CatalogConfiguration _catalogConfig;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        this.checkService(request);
        this.checkVersion(request);
        String outputFormat = request.getAttributeValue("outputFormat");
        String schemaLanguage = request.getAttributeValue("schemaLanguage");
        if (outputFormat != null && !outputFormat.equals("application/xml")) {
            throw new InvalidParameterValueEx("outputFormat", outputFormat);
        }
        if (schemaLanguage != null && !schemaLanguage.equals("http://www.w3.org/XML/Schema")) {
            throw new InvalidParameterValueEx("schemaLanguage", schemaLanguage);
        }
        Element response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
        response.addNamespaceDeclaration(Csw.NAMESPACE_CSW);
        Attribute schemaLocation = new Attribute("schemaLocation", "http://www.opengis.net/cat/csw/2.0.2 http://schemas.opengis.net/csw/2.0.2/CSW-discovery.xsd", Csw.NAMESPACE_XSI);
        response.setAttribute(schemaLocation);
        Iterator i = request.getChildren("TypeName", Csw.NAMESPACE_CSW).iterator();
        HashMap<Object, Object> scMap = new HashMap();
        if (!i.hasNext()) {
            scMap = this.getSchemaComponents(context, null);
        } else {
            while (i.hasNext()) {
                Element elem = (Element)i.next();
                String typeName = elem.getText();
                scMap.put(typeName, this.getSchemaComponents(context, typeName).get(typeName));
            }
        }
        for (Element schemaComponent : scMap.values()) {
            if (schemaComponent == null) continue;
            response.addContent((Content)schemaComponent);
        }
        return response;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) throws CatalogException {
        String service = params.get("service");
        String version = params.get("version");
        String outputFormat = params.get("outputformat");
        String schemaLang = params.get("schemalanguage");
        String typeNames = params.get("typename");
        String namespace = params.get("namespace");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "version", version);
        this.setAttrib(request, "outputFormat", outputFormat);
        this.setAttrib(request, "schemaLanguage", schemaLang);
        if (typeNames != null && namespace == null) {
            throw new InvalidParameterValueEx("Namespace", "Typename's namespace not declared for " + typeNames + ".");
        }
        Map<String, String> hmTypeNames = this.retrieveTypeNames(typeNames, namespace);
        for (Map.Entry<String, String> entry : hmTypeNames.entrySet()) {
            Element el = new Element("TypeName", Csw.NAMESPACE_CSW);
            el.setText(entry.getKey());
            request.addContent((Content)el);
        }
        return request;
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        List<Element> values;
        Element listOfValues = null;
        if (parameterName.equalsIgnoreCase("outputformat") || parameterName.equalsIgnoreCase("namespace") || parameterName.equalsIgnoreCase("typename")) {
            listOfValues = new Element("ListOfValues", Csw.NAMESPACE_CSW);
        }
        if (parameterName.equalsIgnoreCase("outputformat")) {
            Set<String> formats = this._catalogConfig.getDescribeRecordOutputFormat();
            values = this.createValuesElement(formats);
            if (listOfValues != null) {
                listOfValues.addContent(values);
            }
        }
        if (parameterName.equalsIgnoreCase("namespace")) {
            Set<Namespace> namespaces = this._catalogConfig.getDescribeRecordNamespaces();
            values = this.createValuesElementNS(namespaces);
            if (listOfValues != null) {
                listOfValues.addContent(values);
            }
        }
        if (parameterName.equalsIgnoreCase("typename")) {
            Set<String> typenames = this._catalogConfig.getDescribeRecordTypename().keySet();
            values = this.createValuesElement(typenames);
            if (listOfValues != null) {
                listOfValues.addContent(values);
            }
        }
        return listOfValues;
    }

    private HashMap<String, Element> getSchemaComponents(ServiceContext context, String typeName) throws NoApplicableCodeEx, InvalidParameterValueEx {
        HashMap<String, Element> scElements = new HashMap<String, Element>();
        if (typeName == null) {
            for (String tname : this._catalogConfig.getDescribeRecordTypename().keySet()) {
                String schema = this._catalogConfig.getDescribeRecordTypename().get(tname);
                try {
                    Element currentSC = this.loadSchemaComponent(context, tname, schema);
                    scElements.put(tname, currentSC);
                }
                catch (Exception ex) {
                    context.warning("Error while getting schema " + tname + " (" + schema + "): " + ex.getMessage());
                }
            }
        } else if (this._catalogConfig.getDescribeRecordTypename().containsKey(typeName)) {
            scElements.put(typeName, this.loadSchemaComponent(context, typeName, this._catalogConfig.getDescribeRecordTypename().get(typeName)));
        } else if (!typeName.contains(":")) {
            throw new InvalidParameterValueEx("TypeName", "csw:TypeName not qualified for typename: " + typeName);
        }
        return scElements;
    }

    private Element loadSchemaComponent(ServiceContext context, String tname, String schemafile) throws NoApplicableCodeEx {
        Path dir = context.getAppPath().resolve("xml/validation/").resolve("csw202_apiso100/csw/2.0.2/");
        try {
            Element schema = Xml.loadFile((Path)dir.resolve(schemafile));
            Element sc = new Element("SchemaComponent", Csw.NAMESPACE_CSW);
            sc.setAttribute("targetNamespace", Csw.NAMESPACE_CSW.getURI());
            sc.setAttribute("schemaLanguage", "http://www.w3.org/XML/Schema");
            sc.addContent((Content)schema);
            return sc;
        }
        catch (Throwable e) {
            context.error("Cannot get schema file : " + dir);
            context.error("  (C) StackTrace\n" + Util.getStackTrace((Throwable)e));
            throw new NoApplicableCodeEx("Cannot get schema file for : " + tname);
        }
    }
}

